/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

final class Transformer {
    double mat00 = 1.0;
    double mat11 = 1.0;
    double mat01 = 0.0;
    double mat10 = 0.0;
    double mat20 = 0.0;
    double mat21 = 0.0;
    static final Transformer IDENTITY = new Transformer();

    public Transformer() {
    }

    public Transformer(Rectangle wrld, Rectangle scrn) {
        this();
        this.translate(scrn.x - wrld.x, scrn.y - wrld.y);
        this.scale((double)scrn.width / (double)wrld.width, (double)scrn.height / (double)wrld.height);
    }

    public String toString() {
        return "[(" + this.mat00 + " " + this.mat10 + " " + this.mat20 + ") (" + this.mat01 + " " + this.mat11 + " " + this.mat21 + ")]";
    }

    public void scale(double sx, double sy) {
        this.mat00 *= sx;
        this.mat01 *= sy;
        this.mat10 *= sx;
        this.mat11 *= sy;
        this.mat20 *= sx;
        this.mat21 *= sy;
    }

    public void scale(Point s) {
        this.scale(s.x, s.y);
    }

    public void translate(int dx, int dy) {
        this.mat20 += (double)dx;
        this.mat21 += (double)dy;
    }

    public void translate(Point t) {
        this.translate(t.x, t.x);
    }

    public Point trans(Point p) {
        return geom.point(Math.round((double)p.x * this.mat00 + (double)p.y * this.mat10 + this.mat20), Math.round((double)p.x * this.mat01 + (double)p.y * this.mat11 + this.mat21));
    }

    public int transform_x(int x) {
        return (int)Math.round((double)x * this.mat00 + this.mat20);
    }

    public int transform_y(int y) {
        return (int)Math.round((double)y * this.mat11 + this.mat21);
    }

    public Segment transform(Segment s) {
        return new Segment(Math.round((double)s.x0 * this.mat00 + (double)s.y0 * this.mat10 + this.mat20), Math.round((double)s.x0 * this.mat01 + (double)s.y0 * this.mat11 + this.mat21), Math.round((double)s.x1 * this.mat00 + (double)s.y1 * this.mat10 + this.mat20), Math.round((double)s.x1 * this.mat01 + (double)s.y1 * this.mat11 + this.mat21), (long)s.pm);
    }

    public Point inv(Point s) {
        double d = this.mat00 * this.mat11 - this.mat01 * this.mat10;
        double a0 = ((double)s.x - this.mat20) / d;
        double b0 = ((double)s.y - this.mat21) / d;
        return new Point((int)Math.round(a0 * this.mat11 - b0 * this.mat10), (int)Math.round(b0 * this.mat00 - a0 * this.mat01));
    }

    public Point inv(Dimension d) {
        return this.inv(new Point(d.width, d.height));
    }

    public Segment inv(Segment s) {
        double d = this.mat00 * this.mat11 - this.mat01 * this.mat10;
        double a0 = ((double)s.x0 - this.mat20) / d;
        double b0 = ((double)s.y0 - this.mat21) / d;
        double a1 = ((double)s.x1 - this.mat20) / d;
        double b1 = ((double)s.y1 - this.mat21) / d;
        return new Segment(Math.round(a0 * this.mat11 - b0 * this.mat10), Math.round(b0 * this.mat00 - a0 * this.mat01), Math.round(a1 * this.mat11 - b1 * this.mat10), Math.round(b1 * this.mat00 - a1 * this.mat01), (long)s.pm);
    }
}

