/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Scrollbar;

public class TextCanvas
extends Canvas {
    String[] s;
    Scrollbar sb;
    Segment origin;
    int selstart;
    int selend;
    int offset;
    int len;
    FontMetrics fm;
    Label stat;

    TextCanvas(Scrollbar sb, String s, Segment o, Label l) {
        String[] t = new String[]{s, "", ""};
        this.Init(sb, t, o, l);
    }

    TextCanvas(Scrollbar sb, String[] s, Segment o, Label l) {
        this.Init(sb, s, o, l);
    }

    void Init(Scrollbar sb, String[] s, Segment o, Label l) {
        this.sb = sb;
        this.s = s;
        this.origin = o;
        this.stat = l;
        this.selend = 0;
        this.selstart = 0;
        this.resize(400, 40);
    }

    public void setText(String[] s) {
        int l = s[0].length();
        Log.warn("canv set-> " + l);
        this.s = s;
        this.sb.setValues(0, l, 0, l - 1);
        this.sbChanged();
    }

    public void select(int start, int end) {
        Log.warn("canv select-> " + start + " " + end);
        this.selstart = start;
        this.selend = end;
        this.repaint();
    }

    public void center() {
        if (this.selstart != this.selend) {
            int m;
            int v = this.sb.getVisible();
            int n = this.selstart - (v > (m = this.sb.getMaximum()) ? 10 : v / 2);
            Log.warn("canv center-> " + n);
            this.log_sb(this.sb);
            this.sb.setValue(n);
            this.log_sb(this.sb);
            this.sbChanged();
        } else {
            Log.warn("canv not center-> " + this.selstart);
        }
    }

    private void log_sb(Scrollbar sb) {
        Log.warn("sb-> val=" + sb.getValue() + " li=" + sb.getLineIncrement() + " pi=" + sb.getPageIncrement() + " min=" + sb.getMinimum() + " max=" + sb.getMaximum() + " vis=" + sb.getVisible());
    }

    public void paint(Graphics g) {
        this.fm = g.getFontMetrics();
        int w = this.size().width;
        int h = this.size().height;
        int v = this.sb.getValue();
        int sw = this.fm.stringWidth(this.s[0]);
        int sl = this.s[0].length() - 1;
        int vl = sw < w ? sl + 1 : Math.round((float)sl * ((float)w / (float)sw));
        this.sb.setValues(v, vl, 0, sl);
        this.sb.setPageIncrement(vl / 2);
        this.sb.setLineIncrement(1);
        Log.err("paint: sb-> w=" + w + " sw=" + sw + " v=" + v + " sl=" + sl + " vl=" + vl);
        this.log_sb(this.sb);
        g.setColor(Color.lightGray.brighter());
        g.fill3DRect(0, 0, w, h, false);
        g.clipRect(0, 0, w - 2, h - 2);
        g.setColor(this.getForeground());
        this.paint_row(g, 0, 0, v, vl);
        this.paint_row(g, 2, 1, v, vl);
        this.paint_row(g, 1, 2, v, vl);
    }

    public void paint_row(Graphics g, int srow, int drow, int v, int vl) {
        int rh = this.fm.getAscent() + 2;
        this.offset = Math.min(this.s[srow].length(), v);
        int end = Math.min(this.s[srow].length(), this.offset + vl + 1);
        String t = this.s[srow].substring(this.offset, end);
        if (this.offset <= this.selstart && this.selstart <= end) {
            g.setColor(Color.red);
            g.fillRect(this.fm.stringWidth(this.s[srow].substring(this.offset, this.selstart)), drow * rh, this.fm.stringWidth(this.s[srow].substring(this.selstart, this.selend)), (drow + 1) * rh);
            g.setColor(Color.black);
        }
        g.drawString(t, 0, (drow + 1) * rh);
    }

    public void sbChanged() {
        this.repaint();
    }

    public void set_origin(Segment o) {
        this.origin = o;
    }

    public boolean mouseMove(Event e, int x, int y) {
        if (this.fm != null) {
            int n = this.offset + x / this.fm.charWidth('M') + this.origin.x0;
            this.stat.setText(Integer.toString(n));
        }
        return true;
    }
}

