/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Rectangle;

public final class Segment {
    int x0;
    int y0;
    int x1;
    int y1;
    int pm;

    Segment(Segment s) {
        this.x0 = s.x0;
        this.y0 = s.y0;
        this.x1 = s.x1;
        this.y1 = s.y1;
        this.pm = s.pm;
    }

    public Segment(String x0, String y0, String x1, String y1, String pm) {
        this.x0 = geom.atoi(x0);
        this.y0 = geom.atoi(y0);
        this.x1 = geom.atoi(x1);
        this.y1 = geom.atoi(y1);
        this.pm = geom.atoi(pm);
    }

    public Segment(String x0, String y0, String x1, String y1) {
        this(x0, y0, x1, y1, "0");
    }

    public Segment(Integer x0, Integer y0, Integer x1, Integer y1, Integer pm) {
        this((int)x0, (int)y0, (int)x1, (int)y1, (int)pm);
    }

    public Segment(Integer x0, Integer y0, Integer x1, Integer y1) {
        this(x0, y0, x1, y1, new Integer(0));
    }

    public Segment(Long x0, Long y0, Long x1, Long y1) {
        this(x0.intValue(), y0.intValue(), x1.intValue(), y1.intValue());
    }

    public Segment(int x0, int y0, int x1, int y1) {
        this(x0, y0, x1, y1, 0);
    }

    public Segment(int x0, int y0, int x1, int y1, int pm) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.pm = pm;
    }

    public Segment(long x0, long y0, long x1, long y1, long pm) {
        this.x0 = (int)x0;
        this.y0 = (int)y0;
        this.x1 = (int)x1;
        this.y1 = (int)y1;
        this.pm = (int)pm;
    }

    public Segment(long x0, long y0, long x1, long y1) {
        this((int)x0, (int)y0, (int)x1, (int)y1, 0);
    }

    public String toString() {
        return String.valueOf(this.x0) + " " + this.y0 + " " + this.x1 + " " + this.y1 + " " + this.pm;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public Point intersection(Point p) {
        int m = (this.y1 - this.y0) / (this.x1 - this.x0);
        int x = (m * m * this.x0 + p.x + m * p.y - m * this.y0) / (m * m + 1);
        int y = m * (x - this.x0) + this.y0;
        if (m != 1) {
            Log.err("assert(m==1): m = " + m);
        }
        y = Math.abs(this.y0 - this.x0 + p.x + p.y) / 2;
        x = Math.abs(this.x0 - this.y0 + p.y + p.x) / 2;
        return new Point(x, y);
    }

    public Point intercept(Point p) {
        Point q = this.intersection(p);
        if (p.x < this.x0) {
            return new Point(this.x0, this.y0);
        }
        if (p.x > this.x1) {
            return new Point(this.x1, this.y1);
        }
        return q;
    }

    public int distance(Point p) {
        long b;
        long a;
        Point q = this.intercept(p);
        if (q.x < this.x0) {
            a = q.x - this.x0;
            b = q.y - this.y0;
        } else if (q.x > this.x1) {
            a = q.x - this.x1;
            b = q.y - this.y1;
        } else {
            a = q.x - p.x;
            b = q.y - p.y;
        }
        return (int)Math.round(Math.sqrt(a * a + b * b) * 10.0);
    }
}

