/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;

final class PM_Canvas
extends Canvas {
    PM pm;
    Transformer w2s;
    Point mouse_p0;
    Point mouse_p1;
    Point mark;
    Rectangle world;
    int doing;
    boolean filter = false;
    LruHashtable fmt_cache = new LruHashtable(10, 1.0f);
    Color seg_color;
    Color mark_color;
    Color l1_color;
    Color alu_color;
    Color exon_color;
    Color fg_color;
    Color bg_color;
    Color sel_color;
    static final int NOTHING = 0;
    static final int ZOOM = 1;
    static final int MARK = 2;
    static final int REFINE = 3;
    static final int TAG_HEIGHT = 10;
    static final int TAG_TOP = 50;
    static final int TAG_BOTTOM = 40;

    PM_Canvas(PM pm) {
        this.pm = pm;
        this.reset_w2s();
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.doing = 0;
        this.pick_colors();
        this.setBackground(this.bg_color);
        this.setForeground(this.fg_color);
        this.notbusy();
    }

    void pick_colors() {
        this.fg_color = Color.black;
        this.bg_color = Color.white;
        this.mark_color = Color.red;
        this.seg_color = this.fg_color;
        this.alu_color = this.l1_color = this.fg_color;
        this.sel_color = this.bg_color;
        this.exon_color = Color.red;
    }

    public void busy(String s) {
    }

    public void notbusy() {
    }

    void reset_w2s() {
        if (this.pm == null || this.pm.pmf == null) {
            this.world = null;
            this.w2s = Transformer.IDENTITY;
        } else {
            Rectangle r = this.pm.pmf.getBounds();
            this.zoomtowrld(r);
        }
    }

    public boolean set_filter(boolean gnu) {
        boolean old = this.filter;
        this.filter = gnu;
        this.repaint();
        return old;
    }

    void set_w2s() {
        Dimension size = this.size();
        this.w2s = this.world == null ? Transformer.IDENTITY : new Transformer(geom.fliprect(this.world), geom.rectangle(size));
        Log.warn("world " + this.world);
        Log.warn("pm " + this.pm.pmf.getBounds());
        Log.warn("scr " + size);
    }

    public void paint(Graphics g) {
        if (this.pm == null || this.pm.pmf == null || this.pm.features == null) {
            return;
        }
        this.set_w2s();
        g.setColor(this.fg_color);
        g.setPaintMode();
        Enumeration e = this.pm.pmf.elements();
        while (e != null && e.hasMoreElements()) {
            Alignment a = (Alignment)e.nextElement();
            Enumeration ae = a.elements();
            while (ae != null && ae.hasMoreElements()) {
                this.drawSegment(g, (Segment)ae.nextElement());
            }
        }
        e = this.pm.features.elements();
        while (e != null && e.hasMoreElements()) {
            Feature t = (Feature)e.nextElement();
            this.drawTag(g, t);
        }
        this.paint_mark(g);
    }

    private void paint_mark(Graphics g) {
        Log.warn("mark " + this.mark);
        if (this.mark != null) {
            Point q = this.w2s.trans(this.mark);
            g.setColor(this.mark_color);
            g.drawOval(q.x - 3, q.y - 3, 6, 6);
        }
    }

    boolean preclip(int x0, int x1) {
        return x0 >= 0 && x1 >= 0 && x0 < this.size().width;
    }

    void drawSegment(Graphics g, Segment s) {
        s = new Segment(s);
        s.y1 = s.pm;
        s = this.w2s.transform(s);
        g.drawLine(s.x0, s.y1, s.x1, s.y1);
    }

    void drawTag(Graphics g, Feature t) {
        Segment r = this.feature_segment(t);
        if (t.row != 0) {
            return;
        }
        switch (t.kind) {
            case 10: {
                this.drawExon(g, r);
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                this.drawL1(g, r);
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                this.drawALU(g, r);
                break;
            }
        }
    }

    void drawExon(Graphics g, Segment r) {
        g.setColor(this.exon_color);
        this.fill_normalized_rect(g, new Point(r.x0, r.y0), new Point(r.x1, r.y1));
    }

    Polygon makeTriangle(Graphics g, Segment r) {
        Polygon p = new Polygon();
        p.addPoint(r.x0, r.y0);
        p.addPoint(r.x0, r.y1);
        p.addPoint(r.x1, (r.y1 + r.y0) / 2);
        p.addPoint(r.x0, r.y0);
        return p;
    }

    void drawL1(Graphics g, Segment r) {
        Polygon p = this.makeTriangle(g, r);
        g.setColor(this.l1_color);
        g.drawPolygon(p);
    }

    void drawALU(Graphics g, Segment r) {
        Polygon p = this.makeTriangle(g, r);
        g.setColor(this.alu_color);
        g.fillPolygon(p);
    }

    public boolean mouseMove(Event evt, int x, int y) {
        Point wxy = this.w2s.inv(new Point(x, y));
        this.pm.show_mouse(wxy.x, wxy.y);
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.mouse_p0 = new Point(x, y);
        this.mouse_p1 = new Point(x, y);
        this.doing = 2;
        Log.warn("mousedown " + this.w2s.inv(this.mouse_p0));
        return true;
    }

    private void xor_selection(Graphics g, Point p, Point q) {
        g.setXORMode(this.sel_color);
        this.fill_normalized_rect(g, new Point(p.x, 0), new Point(q.x, 9999));
        g.setPaintMode();
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        Point p = new Point(x, y);
        Point wxy = this.w2s.inv(p);
        this.pm.show_mouse(wxy.x, wxy.y);
        this.doing = 1;
        Graphics g = this.getGraphics();
        this.xor_selection(g, this.mouse_p0, this.mouse_p1);
        this.xor_selection(g, this.mouse_p0, p);
        this.mouse_p1 = p;
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        int did = this.doing;
        Graphics g = this.getGraphics();
        this.doing = 0;
        Log.warn("mouseup " + this.mouse_p0 + " x " + this.mouse_p1);
        switch (did) {
            case 1: {
                this.xor_selection(g, this.mouse_p0, this.mouse_p1);
                Log.warn("zoom " + this.mouse_p0 + " x " + this.mouse_p1);
                boolean ok = this.zoom(this.mouse_p0, this.mouse_p1);
                this.pm.global_interval(this.world.x, this.world.width);
                if (ok) break;
            }
            case 2: {
                Point mouse = this.w2s.inv(new Point(x, y));
                Log.err("selection at " + mouse);
                this.pm.global_interval(this.world.x, this.world.width);
                this.pm.global_selection(this.find_mark(mouse));
                break;
            }
        }
        this.repaint();
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        return true;
    }

    void zoomtowrld(Rectangle p) {
        Log.warn("zoom " + p);
        p.y = 40;
        p.height = 60;
        this.world = p;
        this.set_w2s();
    }

    boolean zoom(Point mouse_p0, Point mouse_p1) {
        Point p0 = geom.point(mouse_p0);
        Point p1 = geom.point(mouse_p1);
        geom.normalize_points(p0, p1);
        if (this.tooclose(p0, p1)) {
            return false;
        }
        p0.x = geom.clamp(0, p0.x, this.size().width);
        p1.x = geom.clamp(0, p1.x, this.size().width);
        p0 = this.w2s.inv(p0);
        p1 = this.w2s.inv(p1);
        p0.y = 0;
        p1.y = 100;
        this.zoomtowrld(geom.rectangle(p0, p1));
        this.repaint();
        return true;
    }

    void unzoom() {
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.reset_w2s();
        this.repaint();
    }

    boolean tooclose(Point p, Point q) {
        Dimension d = geom.diff(p, q);
        return Math.abs(d.width) < 20;
    }

    void fill_normalized_rect(Graphics g, Point p0, Point p1) {
        Point q0 = geom.point(p0);
        Point q1 = geom.point(p1);
        geom.normalize_points(q0, q1);
        g.fillRect(q0.x, q0.y, q1.x - q0.x, q1.y - q0.y);
    }

    Segment feature_segment(Feature t) {
        Segment s = this.w2s.transform(new Segment(t.start, 40, t.end, 50));
        if (t.dir == -1) {
            int x = s.x0;
            s.x0 = s.x1;
            s.x1 = x;
        }
        return s;
    }

    int find_mark(Point p) {
        this.busy("pm: scanning alignment");
        AlignmentInfo ai = this.pm.pmf.closest_pm(p.x);
        Feature f = this.pm.features.closest(0, p.x);
        Segment s = ai.segment;
        int x = geom.clamp(s.x0, p.x, s.x1);
        ai.point = new Point(x, s.pm);
        this.set_mark(ai);
        this.pm.show_msg(String.valueOf(this.ppseg(s)) + "; " + this.ppfeat(f) + "\n");
        Log.err("pm: " + x + "; " + f);
        this.notbusy();
        return x;
    }

    int set_mark(AlignmentInfo ai) {
        Log.err("ai " + ai.short_string());
        if (ai.number != -1) {
            int offset = ai.alignment.effective_offset(ai.point.x);
            this.mark = ai.point;
            this.set_text(ai.number, offset, offset + 1);
        }
        return ai.number;
    }

    void set_mark(int x, int y) {
        this.mark = new Point(x, y);
    }

    void indicate_mark(int x, int y) {
        this.set_mark(x, y);
        this.repaint();
    }

    String ppseg(Segment s) {
        return s == null ? "[]" : String.valueOf(s.pm) + "% [" + s.x0 + "," + s.x1 + "]";
    }

    String ppfeat(Feature f) {
        return f == null ? "" : f.asString();
    }

    void set_text(int nth, int start, int end) {
        Integer Nth = new Integer(nth);
        Log.warn("formatting " + nth + " (" + start + "," + end + ")");
        if (!this.fmt_cache.containsKey(Nth)) {
            Log.warn("caching " + Nth);
            this.fmt_cache.put(Nth, this.pm.pmf.format(nth));
        }
        this.pm.setTextView((String[])this.fmt_cache.get(Nth), this.pm.pmf.alignment((int)nth).endpoints);
        this.pm.selectText(start, end);
    }
}

