/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class PM
extends Applet {
    private Checkbox verbose;
    private Button quit;
    private Button reset;
    private Button undo;
    private Label status;
    private PM_Canvas pmview;
    private BLK_Canvas blkview;
    private ActiveTextArea textview;
    private TextArea selview;
    AlignmentFile pmf;
    Features features;
    private String[][] param_info = new String[][]{{"sess", "string", "session id"}, {"pmfile", "url", "alignment file name"}, {"seq0file", "url", "first sequence file name"}, {"seq1file", "url", "second sequence file name"}};

    public void init() {
        this.pmf = new AlignmentFile();
        this.verbose = new Checkbox("Debug", null, false);
        this.reset = new Button("Reset");
        this.status = new Label("xxxxxxxx,yyyyyyyy");
        Panel controls = new Panel();
        controls.setLayout(new FlowLayout(0));
        controls.add(this.reset);
        controls.add(this.verbose);
        controls.add(this.status);
        this.pmview = new PM_Canvas(this);
        this.blkview = new BLK_Canvas(this);
        this.textview = new ActiveTextArea("Local Alignment/Percent Match", new Segment(0, 0, 0, 0), this.status);
        this.textview.setFont(new Font("Courier", 0, 12));
        this.textview.setEditable(false);
        this.selview = new TextArea("$Id: PM.java,v 2.4 1997/08/29 21:54:19 schwartz Exp schwartz $\n", 3, 80);
        this.selview.setFont(new Font("Courier", 0, 12));
        this.selview.setEditable(false);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 12;
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(controls, (GridBagConstraints)c.clone());
        this.add(controls);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.blkview, (GridBagConstraints)c.clone());
        this.add(this.blkview);
        c.fill = 1;
        c.weightx = 5.0;
        c.weighty = 5.0;
        gridbag.setConstraints(this.pmview, (GridBagConstraints)c.clone());
        this.add(this.pmview);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.textview, (GridBagConstraints)c.clone());
        this.add(this.textview);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.selview, (GridBagConstraints)c.clone());
        this.add(this.selview);
        this.validate();
        Log.warn("loading alignment");
        try {
            IO.set_sess(this.getParameter("sess"));
            this.loadAlign("pm");
            this.loadSeq(0, "seq0");
            this.loadSeq(1, "seq1");
            this.loadFeatures("tag");
        }
        catch (IOException e) {
            Log.err("loadFile failed: " + e);
        }
    }

    public String[][] getParameterInfo() {
        return this.param_info;
    }

    public boolean action(Event evt, Object arg) {
        if ("Quit".equals(arg)) {
            System.exit(0);
        } else if ("Reset".equals(arg)) {
            this.pmview.unzoom();
            this.blkview.unzoom();
        } else if (evt.target == this.verbose) {
            if (((Boolean)arg).booleanValue()) {
                Log.verbose();
            } else {
                Log.quiet();
            }
        }
        return true;
    }

    public void loadAlign(String s) throws IOException {
        String sf = String.valueOf(s) + "file";
        Log.err("loadAlign " + sf);
        String p = this.getParameter(sf);
        if (p != null && p != "") {
            this.loadURL(IO.sess_to_url(p));
        }
    }

    public void loadSeq(int n, String s) {
        String sf = String.valueOf(s) + "file";
        Log.err("loadSeq " + sf);
        String p = this.getParameter(sf);
        if (p != null && p != "") {
            Log.err("set_seq " + n + " " + p);
            this.pmf.set_sequence_url(n, this.getParameter(sf));
        }
    }

    public void loadFeatures(String s) throws IOException {
        String sf = String.valueOf(s) + "file";
        Log.err("loadFeatures " + sf);
        String p = this.getParameter(sf);
        if (p != null && p != "") {
            this.loadFeaturesURL(IO.sess_to_url(p));
        }
    }

    public void loadFeaturesURL(String s) throws IOException {
        if (s == null) {
            return;
        }
        Log.err("loading '" + s + "'");
        this.setText("Loading " + s);
        this.features = new Features(new URL(this.getDocumentBase(), s));
        this.setText("Loaded " + s);
    }

    public void loadURL(String s) throws IOException {
        if (s == null) {
            return;
        }
        Log.err("loading '" + s + "'");
        this.setText("Loading '" + s + "'");
        this.pmf = new AlignmentFile(new URL(this.getDocumentBase(), s));
        this.setText("Loaded '" + s + "'");
        this.pmview.unzoom();
        this.blkview.unzoom();
        this.validate();
    }

    public void show_mouse(int x, int y) {
        this.status.setText(String.valueOf(x) + " " + y + "%");
    }

    public void show_msg(String s) {
        this.selview.insertText(s, 0);
        this.selview.select(0, 0);
    }

    public void setText(String s) {
        this.showStatus(s);
    }

    LA LAb_Applet() {
        Enumeration<Applet> e = this.getAppletContext().getApplets();
        while (e.hasMoreElements()) {
            String name;
            Applet a = e.nextElement();
            if (a == null || (name = a.getParameter("name")) == null || !name.equals("LA:b")) continue;
            return (LA)a;
        }
        return null;
    }

    void global_selection(int x) {
        LA a = this.LAb_Applet();
        if (a != null && x > -1) {
            Log.warn("pm: select: " + x);
            a.make_selection(x);
        }
        this.blkview.indicate_mark(x);
    }

    void global_interval(int x, int w) {
        LA a = this.LAb_Applet();
        if (a != null && x > -1) {
            Log.warn("pm: interval: " + x + " " + w);
            a.indicate_interval(x, w);
        }
        this.indicate_interval(x, w);
    }

    void indicate_interval(int x, int w) {
        this.blkview.indicate_interval(x, w);
    }

    void snert() {
        Enumeration<Applet> e = this.getAppletContext().getApplets();
        while (e.hasMoreElements()) {
            Applet a = e.nextElement();
            if (a == null) continue;
            String name = a.getParameter("name");
            Log.err("snert: " + name);
        }
    }

    Applet siblingApplet(String s) {
        Enumeration<Applet> e = this.getAppletContext().getApplets();
        while (e.hasMoreElements()) {
            String name;
            Applet a = e.nextElement();
            if (a == null || (name = a.getParameter("name")) == null || !name.startsWith(s)) continue;
            return a;
        }
        return null;
    }

    public void setTextView(String[] s) {
        this.textview.setText(s);
    }

    public void setTextView(String[] s, Segment o) {
        this.textview.setText(s);
        this.textview.setOrigin(o);
    }

    public void selectText(int a, int b) {
        this.textview.select(a, b);
    }
}

