/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

class LA_Canvas
extends Canvas {
    LA lax;
    Transformer w2s;
    Point mouse_p0;
    Point mouse_p1;
    Point mark;
    Rectangle world;
    int doing;
    boolean filter = false;
    Frame frame;
    Point interval;
    static final int NOTHING = 0;
    static final int ZOOM = 1;
    static final int MARK = 2;
    static final int REFINE = 3;

    LA_Canvas(LA lax) {
        this.lax = lax;
        this.reset_w2s();
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.doing = 0;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.frame = this.findframe();
        this.interval = null;
        this.notbusy();
    }

    Frame findframe() {
        Container p;
        while ((p = this.getParent()) != null && p.getClass().getName() != "java.awt.Frame") {
        }
        return (Frame)p;
    }

    public void busy(String s) {
        this.lax.setText("Wait..." + s);
    }

    public void notbusy() {
        this.lax.setText("");
    }

    void reset_w2s() {
        if (this.lax == null || this.lax.af == null) {
            this.world = null;
            this.w2s = Transformer.IDENTITY;
        } else {
            this.zoomtowrld(this.lax.af.getBounds());
        }
    }

    public boolean set_filter(boolean gnu) {
        boolean old = this.filter;
        this.filter = gnu;
        this.repaint();
        return old;
    }

    void set_w2s() {
        this.w2s = this.world == null ? Transformer.IDENTITY : new Transformer(geom.fliprect(this.world), geom.rectangle(this.size()));
        Log.warn("world " + this.world);
        Log.warn("lax " + this.lax.af.getBounds());
        Log.warn("scr " + this.size());
    }

    public void paint(Graphics g) {
        if (this.lax == null || this.lax.af == null) {
            return;
        }
        this.set_w2s();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.size().width - 1, this.size().height - 1);
        g.draw3DRect(0, 0, this.size().width - 1, this.size().height - 1, true);
        g.setColor(Color.black);
        Enumeration ev = this.lax.af.alignments.elements();
        while (ev.hasMoreElements()) {
            Alignment a = (Alignment)ev.nextElement();
            if (this.filter && a.filter > 0) continue;
            Enumeration sv = a.aligned_segments.elements();
            while (sv.hasMoreElements()) {
                Segment s = (Segment)sv.nextElement();
                this.drawSegment(g, this.w2s.transform(s));
            }
        }
        this.paintMark(g);
        this.paint_interval(g);
    }

    private void paintMark(Graphics g) {
        Log.warn("mark " + this.mark);
        if (this.mark != null) {
            Point q = this.w2s.trans(this.mark);
            g.drawOval(q.x - 5, q.y - 5, 10, 10);
        }
    }

    private void paint_interval(Graphics g) {
        Log.warn("interval " + this.interval);
        if (this.interval != null) {
            g.setXORMode(Color.white);
            g.fillRect(this.w2s.transform_x(this.interval.x), 0, this.w2s.transform_x(this.interval.y), this.size().height);
            g.setPaintMode();
        }
    }

    public void indicate_interval(int x, int w) {
        if (this.interval == null) {
            this.interval = new Point(x, w);
        } else {
            this.interval.move(x, w);
        }
        this.repaint();
    }

    void drawSegment(Graphics g, Segment s) {
        int x0 = s.x0;
        int y0 = s.y0;
        int x1 = s.x1;
        int y1 = s.y1;
        g.drawLine(x0, y0, x1, y1);
    }

    void draw_normalized_rect(Graphics g, Point p0, Point p1) {
        Point q0 = geom.point(p0);
        Point q1 = geom.point(p1);
        geom.normalize_points(q0, q1);
        g.drawRect(q0.x, q0.y, q1.x - q0.x, q1.y - q0.y);
    }

    public boolean mouseMove(Event evt, int x, int y) {
        Point wxy = this.w2s.inv(new Point(x, y));
        this.lax.show_mouse(wxy.x, wxy.y);
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.mouse_p0 = new Point(x, y);
        this.mouse_p1 = new Point(x, y);
        this.doing = 2;
        Log.warn("mousedown " + this.w2s.inv(this.mouse_p0));
        return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        Point p = new Point(x, y);
        Point wxy = this.w2s.inv(p);
        this.lax.show_mouse(wxy.x, wxy.y);
        this.doing = 1;
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        this.draw_normalized_rect(g, this.mouse_p0, this.mouse_p1);
        this.draw_normalized_rect(g, this.mouse_p0, p);
        g.setPaintMode();
        this.mouse_p1 = p;
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        int did = this.doing;
        Graphics g = this.getGraphics();
        this.doing = 0;
        Log.warn("mouseup " + this.mouse_p0 + " x " + this.mouse_p1);
        switch (did) {
            case 1: {
                g.setXORMode(Color.white);
                this.draw_normalized_rect(g, this.mouse_p0, this.mouse_p1);
                g.setPaintMode();
                Log.warn("zoom " + this.mouse_p0 + " x " + this.mouse_p1);
                if (this.zoom(this.mouse_p0, this.mouse_p1)) break;
            }
            case 2: {
                this.busy("scanning alignment");
                this.find_mark(this.w2s.inv(new Point(x, y)));
                this.paintMark(g);
                this.notbusy();
                break;
            }
        }
        this.repaint();
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        return true;
    }

    public void set_mark_nth(int nth) {
        Alignment a = this.lax.af.alignment(nth);
        this.mark = new Point(a.endpoints.x0, a.endpoints.y0);
        this.set_text(nth, 0, 0);
    }

    int find_mark(int x) {
        return this.set_mark(this.lax.af.interval(x));
    }

    int find_mark(Point mouse) {
        return this.set_mark(this.lax.af.closest(mouse));
    }

    int set_mark(AlignmentInfo ai) {
        Log.err("ai " + ai);
        if (ai.number != -1) {
            int offset = ai.point.x - ai.alignment.endpoints.x0;
            this.mark = ai.point;
            this.set_text(ai.number, offset, offset + 1);
        }
        return ai.number;
    }

    void set_text(int nth, int start, int end) {
        this.lax.setTextView(this.lax.af.format(nth));
        this.lax.selectText(start, end);
    }

    void zoomtowrld(Rectangle r) {
        Log.warn("zoom " + r);
        this.world = r;
        this.set_w2s();
    }

    boolean zoom(Point mouse_p0, Point mouse_p1) {
        if (this.tooclose(mouse_p0, mouse_p1)) {
            Log.warn("tooclose " + mouse_p0 + " " + mouse_p1);
            return false;
        }
        Point p0 = this.w2s.inv(mouse_p0);
        Point p1 = this.w2s.inv(mouse_p1);
        geom.normalize_points(p0, p1);
        this.zoomtowrld(geom.rectangle(p0, p1));
        this.repaint();
        return true;
    }

    void unzoom() {
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.interval = null;
        this.reset_w2s();
        this.repaint();
    }

    boolean tooclose(Point p, Point q) {
        Dimension d = geom.diff(p, q);
        return Math.abs(d.width) < 10 || Math.abs(d.height) < 10;
    }

    Rectangle boundingbox() {
        return this.world;
    }
}

