/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class LA
extends Applet {
    private Checkbox verbose;
    private Button quit;
    private Button reset;
    private Button undo;
    private Button sim;
    private Button blast;
    private Button pip;
    private Checkbox primary;
    private Checkbox secondary;
    private Checkbox filter;
    private LA_Canvas canvas;
    private Label status;
    private ActiveTextArea textview;
    AlignmentFile af;
    private String[][] param_info = new String[][]{{"file", "url", "alignment file name"}, {"alignfile", "url", "alignment file name"}, {"aligndata", "string", "laj format alignment"}, {"seq0file", "url", "first sequence file name"}, {"seq0data", "url", "first sequence contents"}, {"seq1file", "url", "second sequence file name"}, {"seq1data", "url", "second sequence contents"}};

    public void init() {
        this.af = new AlignmentFile();
        this.filter = new Checkbox("Filter", null, false);
        this.verbose = new Checkbox("Debug", null, false);
        this.reset = new Button("Reset");
        this.sim = new Button("Sim");
        this.blast = new Button("Dblast");
        this.pip = new Button("Pip");
        this.status = new Label("xxxxxxxx,yyyyyyyy");
        Panel controls = new Panel();
        controls.setLayout(new FlowLayout(0));
        controls.add(this.reset);
        controls.add(this.filter);
        controls.add(this.blast);
        controls.add(this.sim);
        controls.add(this.pip);
        controls.add(this.verbose);
        controls.add(this.status);
        this.canvas = new LA_Canvas(this);
        this.textview = new ActiveTextArea("$Id: LA.java,v 2.4 1997/08/29 21:54:19 schwartz Exp schwartz $", new Segment(0, 0, 0, 0), this.status);
        this.textview.setFont(new Font("Courier", 0, 12));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 12;
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(controls, (GridBagConstraints)c.clone());
        this.add(controls);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.canvas, (GridBagConstraints)c.clone());
        this.add(this.canvas);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag.setConstraints(this.textview, (GridBagConstraints)c.clone());
        this.add(this.textview);
        this.validate();
        String sess = this.getParameter("sess");
        if (sess == null) {
            this.disable_cmds();
        } else {
            IO.set_sess(sess);
        }
        this.canvas.busy("loading alignment");
        try {
            this.loadAlign("align");
            this.loadSeq(0, "seq0");
            this.loadSeq(1, "seq1");
        }
        catch (IOException e) {
            Log.err("loadFile failed: " + e);
        }
        this.canvas.notbusy();
        this.validate();
    }

    private void enable_cmds() {
    }

    private void disable_cmds() {
    }

    public String[][] getParameterInfo() {
        return this.param_info;
    }

    public boolean action(Event evt, Object arg) {
        if ("Quit".equals(arg)) {
            System.exit(0);
        } else if ("Reset".equals(arg)) {
            this.canvas.unzoom();
        } else if ("Sim".equals(arg)) {
            this.show_align_document("sim");
        } else if ("Dblast".equals(arg)) {
            this.show_align_document("Dblast");
        } else if ("Pip".equals(arg)) {
            this.show_align_document("pip");
        } else if (evt.target == this.verbose) {
            if (((Boolean)arg).booleanValue()) {
                Log.verbose();
            } else {
                Log.quiet();
            }
        } else if (evt.target == this.filter) {
            this.canvas.set_filter((Boolean)arg);
        } else {
            "GetURL".equals(arg);
        }
        return true;
    }

    public void loadAlign(String s) throws IOException {
        String sf = String.valueOf(s) + "file";
        Log.err("loadAlign '" + sf + "'");
        String p = this.getParameter(sf);
        if (p != null && p != "") {
            this.loadURL(IO.sess_to_url(p));
        }
    }

    public void loadSeq(int n, String s) {
        String sf = String.valueOf(s) + "file";
        Log.err("loadSeq " + sf);
        String p = this.getParameter(sf);
        if (p != null && p != "") {
            p = IO.sess_to_url(p);
            Log.err("set_seq " + n + " " + p);
            this.af.set_sequence_url(n, p);
        }
    }

    public void loadFile(String f) throws IOException {
        if (f == null) {
            return;
        }
        this.canvas.busy("loading" + f);
        this.setText("Loading " + f);
        this.af = new AlignmentFile(f);
        this.setText("Loaded " + f);
        this.canvas.unzoom();
        this.canvas.notbusy();
    }

    public void loadURL(String s) throws IOException {
        if (s == null) {
            return;
        }
        Log.err("loading '" + s + "'");
        this.canvas.busy("loading " + s);
        URL url = new URL(this.getDocumentBase(), s);
        this.setText("Loading " + s);
        this.af = new AlignmentFile(url);
        this.setText("Loaded " + s);
        this.canvas.unzoom();
        this.canvas.notbusy();
        this.validate();
    }

    public void loadString(String s) throws IOException {
        DataInputStream is = new DataInputStream(new StringBufferInputStream(s));
        this.af = new AlignmentFile(is);
        this.canvas.unzoom();
    }

    public synchronized void make_selection(int x) {
        this.canvas.find_mark(x);
    }

    public synchronized void indicate_interval(int x, int w) {
        this.canvas.indicate_interval(x, w);
    }

    public void show_mouse(int x, int y) {
        this.status.setText(String.valueOf(x) + "," + y);
    }

    public void setText(String s) {
        this.showStatus(s);
    }

    public void setTextView(String[] s) {
        this.textview.setText(s);
    }

    public void selectText(int a, int b) {
        this.textview.select(a, b);
    }

    public void show_align_document(String kind) {
        String url;
        String sess = this.getParameter("sess");
        String s0 = this.getParameter("seq0file");
        String s1 = this.getParameter("seq1file");
        String rmask0 = this.getParameter("rmask0file");
        String rmask1 = this.getParameter("rmask1file");
        String exons = this.getParameter("exonsfile");
        Rectangle r = this.canvas.boundingbox();
        Integer x0 = new Integer(r.x);
        Integer x1 = new Integer(r.x + r.width);
        Integer y0 = new Integer(r.y);
        Integer y1 = new Integer(r.y + r.height);
        if (s0 == null || s1 == null) {
            Log.err("One or both sequence files are missing");
            return;
        }
        if ("sim".equals(kind) || "Dblast".equals(kind)) {
            url = "/cgi-bin/cgi-echo/html?" + URLEncoder.encode(this.blast_body(s0, s1, x0, x1, y0, y1, kind, sess));
        } else if ("pip".equals(kind)) {
            url = "/cgi-bin/cgi-pip/?" + this.pip_body(s0, s1, x0, x1, y0, y1, rmask0, rmask1, exons, sess);
        } else {
            Log.err("unknown kind: " + kind);
            return;
        }
        try {
            this.getAppletContext().showDocument(new URL("http", this.getDocumentBase().getHost(), url), "_top");
        }
        catch (MalformedURLException e) {
            Log.err("bad url: " + e);
        }
    }

    private String blast_body(String s0, String s1, Integer x0, Integer x1, Integer y0, Integer y1, String kind, String sess) {
        return "<head><title>" + kind + " Launcher" + "</title></head>\n" + "<body><h1>" + kind + " Launcher" + "</h1>\n" + "<form method=get action=/cgi-bin/cgi-batch-align>\n" + "Output style: " + "<input name=output type=radio value=ps checked>PostScript\n" + "<input name=output type=radio value=ascii>Text\n" + "<input name=seq0   type=hidden value=" + s0 + ">\n" + "<input name=seq1   type=hidden value=" + s1 + ">\n" + "<input name=x0     type=hidden value=" + x0 + ">\n" + "<input name=x1     type=hidden value=" + x1 + ">\n" + "<input name=y0     type=hidden value=" + y0 + ">\n" + "<input name=y1     type=hidden value=" + y1 + ">\n" + "<input name=prog   type=hidden value=" + kind + ">\n" + "<input name=sess   type=hidden value=" + sess + ">\n" + "<br>\n" + "<input name=Submit type=submit>\n" + "</form></body></html>";
    }

    private String UE(String u) {
        return u == null ? "" : URLEncoder.encode(u);
    }

    private String UE(Integer i) {
        return i == null ? "" : URLEncoder.encode(i.toString());
    }

    private String pip_body(String s0, String s1, Integer x0, Integer x1, Integer y0, Integer y1, String r0, String r1, String ex, String ss) {
        return "sess=" + this.UE(ss) + "&" + "seq0=" + this.UE(s0) + "&" + "seq1=" + this.UE(s1) + "&" + "x0=" + this.UE(x0) + "&" + "x1=" + this.UE(x1) + "&" + "y0=" + this.UE(y0) + "&" + "y1=" + this.UE(y1) + "&" + "exons=" + this.UE(ex) + "&" + "rmask0=" + this.UE(r0) + "&" + "rmask1=" + this.UE(r1) + "&";
    }
}

