/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public final class Features {
    public Vector features = new Vector();

    public Features() {
    }

    public Features(URL url) throws MalformedURLException, IOException {
        this.fromURL(url);
    }

    public void fromStream(DataInputStream is) throws IOException {
        String line;
        int row = 0;
        while ((line = is.readLine()) != null) {
            if ((line = line.trim()) == "" || line.startsWith("/") || line.startsWith("%")) continue;
            row = this.process(line, row);
        }
    }

    int process(String line, int row) {
        String[] F = this.split_str(line);
        int a = geom.atoi(this.fld(F, 0));
        int b = geom.atoi(this.fld(F, 1));
        if (this.fis(F, 1, "setrow")) {
            row = a;
        }
        if (this.fis(F, -1, "exon")) {
            this.add(row, a, b, "", 0, 10);
        } else if (this.fis(F, -1, "l1")) {
            this.add(row, a, b, "", this.dir(F[2]), 12);
        } else if (this.fis(F, -1, "alu")) {
            this.add(row, a, b, "", this.dir(F[2]), 11);
        } else if (this.fis(F, -1, "ltr")) {
            this.add(row, a, b, "", this.dir(F[2]), 14);
        } else if (this.fis(F, -1, "sine")) {
            this.add(row, a, b, "", this.dir(F[2]), 15);
        } else if (this.fis(F, -1, "line1")) {
            this.add(row, a, b, "", this.dir(F[2]), 16);
        } else if (this.fis(F, -1, "line2")) {
            this.add(row, a, b, "", this.dir(F[2]), 17);
        } else if (this.fis(F, -1, "b1")) {
            this.add(row, a, b, "", this.dir(F[2]), 18);
        } else if (this.fis(F, -1, "b2")) {
            this.add(row, a, b, "", this.dir(F[2]), 19);
        } else if (this.fis(F, -1, "xon")) {
            this.add(row, a, b, this.fcat(F, 2, -2), 0, 10);
        } else if (this.fis(F, -1, "thinarrow")) {
            this.add(row, a, b, this.fcat(F, 2, -3), this.dir(this.fld(F, -2)), 13);
        }
        return row;
    }

    public void fromURL(URL url) throws MalformedURLException, IOException {
        this.fromStream(new DataInputStream(url.openStream()));
    }

    public void removeAll() {
        this.features.removeAllElements();
    }

    void add(int row, int x0, int x1, String s, int dir, int kind) {
        Feature f = new Feature(row, x0, x1, s, dir, kind);
        this.features.addElement(f);
    }

    public Enumeration elements() {
        return this.features.elements();
    }

    int dir(String s) {
        if (s.equalsIgnoreCase("right")) {
            return 1;
        }
        if (s.equalsIgnoreCase("left")) {
            return -1;
        }
        return 0;
    }

    int fwrap(String[] F, int n) {
        return n < 0 ? F.length + n : n;
    }

    String fld(String[] F, int n) {
        return (n = this.fwrap(F, n)) >= 0 && n < F.length ? F[n] : "";
    }

    boolean fis(String[] F, int n, String s) {
        return this.fld(F, n).equalsIgnoreCase(s);
    }

    String fcat(String[] F, int n, int m) {
        StringBuffer s = new StringBuffer("");
        m = this.fwrap(F, m);
        int i = n;
        while (i <= m) {
            s.append(F[i]).append(" ");
            ++i;
        }
        return s.toString();
    }

    String[] split_str(String s) {
        return Utils.splitStr(s);
    }

    Feature closest(int x) {
        return this.closest(0, x);
    }

    Feature closest(int row, int x) {
        int best = Integer.MAX_VALUE;
        Feature g = null;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Feature f = (Feature)e.nextElement();
            if (f.row != row) continue;
            if (f.start <= x && x <= f.end) {
                return f;
            }
            int d = f.start > x ? f.start - x : x - f.end;
            if (d >= best) continue;
            best = d;
            g = f;
        }
        return g;
    }
}

