/*
 * Decompiled with CFR 0.152.
 */
public class Feature {
    public static final int NONE = 0;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int EXON = 10;
    public static final int ALU = 11;
    public static final int L1 = 12;
    public static final int GENE = 13;
    public static final int LTR = 14;
    public static final int SINE = 15;
    public static final int LINE1 = 16;
    public static final int LINE2 = 17;
    public static final int B1 = 18;
    public static final int B2 = 19;
    public int row;
    public int start;
    public int end;
    public int dir;
    public int kind;
    public String label;

    Feature() {
        this.row = 9;
        this.end = 0;
        this.start = 0;
        this.dir = 0;
        this.kind = 10;
        this.label = null;
    }

    Feature(int row, int start, int end, String label, int dir, int kind) {
        this.row = row;
        this.start = start;
        this.end = end;
        this.label = label;
        this.dir = dir;
        this.kind = kind;
    }

    String asString() {
        return String.valueOf(this.start) + " " + this.end + " " + "\"" + this.label + "\" " + this.strdir(this.dir) + " " + this.strkind(this.kind);
    }

    String strdir(int dir) {
        switch (dir) {
            case -1: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return "";
    }

    String strkind(int kind) {
        switch (kind) {
            case 10: {
                return "EXON";
            }
            case 11: {
                return "ALU";
            }
            case 12: {
                return "L1";
            }
            case 13: {
                return "GENE";
            }
            case 14: {
                return "LTR";
            }
            case 15: {
                return "SINE";
            }
            case 16: {
                return "LINE1";
            }
            case 18: {
                return "B1";
            }
            case 19: {
                return "B2";
            }
        }
        return "?";
    }
}

