/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

final class BLK_Canvas
extends Canvas {
    PM pm;
    Transformer w2s;
    Point mouse_p0;
    Point mouse_p1;
    Point mark;
    Rectangle world;
    int doing;
    Point interval;
    static final int NOTHING = 0;
    static final int ZOOM = 1;
    static final int MARK = 2;
    static final int REFINE = 3;
    static final int FEATURE = 33;
    static final int SEGMENT = 66;
    static final Color SEGMENT_COLOR = Color.black;
    static final Color FEATURE_COLOR = Color.red;
    static final Color MARK_COLOR = Color.green;

    BLK_Canvas(PM pm) {
        this.pm = pm;
        this.reset_w2s();
        this.interval = null;
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.doing = 0;
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.notbusy();
    }

    public void busy(String s) {
    }

    public void notbusy() {
    }

    void reset_w2s() {
        if (this.pm == null || this.pm.pmf == null) {
            this.world = null;
            this.w2s = Transformer.IDENTITY;
        } else {
            Rectangle r = this.pm.pmf.getBounds();
            this.zoomtowrld(r);
        }
    }

    void set_w2s() {
        Dimension size = this.size();
        this.w2s = this.world == null ? Transformer.IDENTITY : new Transformer(geom.fliprect(this.world), geom.rectangle(size));
        Log.warn("world " + this.world);
        Log.warn("pm " + this.pm.pmf.getBounds());
        Log.warn("scr " + size);
    }

    public void paint(Graphics g) {
        if (this.pm == null || this.pm.pmf == null || this.pm.features == null) {
            return;
        }
        this.set_w2s();
        g.setColor(Color.black);
        g.setPaintMode();
        Enumeration e = this.pm.pmf.elements();
        while (e != null && e.hasMoreElements()) {
            this.drawSegment(g, ((Alignment)e.nextElement()).endpoints);
        }
        e = this.pm.features.elements();
        while (e != null && e.hasMoreElements()) {
            this.drawTag(g, (Feature)e.nextElement());
        }
        this.paint_interval(g);
        this.paint_mark(g);
    }

    private void paint_mark(Graphics g) {
        Log.warn("mark " + this.mark);
        if (this.mark != null) {
            Point q = this.w2s.trans(this.mark);
            g.setColor(MARK_COLOR);
            g.drawOval(q.x - 3, q.y - 3, 6, 6);
        }
    }

    void drawSegment(Graphics g, Segment s) {
        s = this.w2s.transform(new Segment(s.x0, 66, s.x1, 66));
        g.setColor(SEGMENT_COLOR);
        g.fillRect(s.x0, s.y1 - 2, s.x1 - s.x0, 4);
    }

    void drawTag(Graphics g, Feature t) {
        if (t.row != 1) {
            return;
        }
        Segment r = this.feature_segment(t);
        g.setColor(FEATURE_COLOR);
        g.fillRect(r.x0, r.y1 - 2, r.x1 - r.x0, 4);
        g.fillOval(r.x1 - 3, r.y1 - 3, 6, 6);
    }

    public boolean mouseMove(Event evt, int x, int y) {
        Point wxy = this.w2s.inv(new Point(x, y));
        this.pm.show_mouse(wxy.x, wxy.y);
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.mouse_p0 = new Point(x, y);
        this.mouse_p1 = new Point(x, y);
        this.doing = 2;
        Log.warn("mousedown " + this.w2s.inv(this.mouse_p0));
        return true;
    }

    private void paint_interval(Graphics g) {
        Log.warn("interval " + this.interval);
        if (this.interval != null && this.interval.x != this.world.x && this.interval.y != this.world.x + this.world.width) {
            g.setXORMode(Color.white);
            g.fillRect(this.w2s.transform_x(this.interval.x), 0, this.w2s.transform_x(this.interval.y), this.size().height);
            g.setPaintMode();
        }
    }

    public void indicate_interval(int x, int w) {
        if (this.interval == null) {
            this.interval = new Point(x, w);
        } else {
            this.interval.move(x, w);
        }
        this.repaint();
    }

    private void xor_selection(Graphics g, Point p, Point q) {
        g.setXORMode(Color.blue);
        this.fill_normalized_rect(g, new Point(p.x, 0), new Point(q.x, 9999));
        g.setPaintMode();
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        Point p = new Point(x, y);
        Point wxy = this.w2s.inv(p);
        this.pm.show_mouse(wxy.x, wxy.y);
        this.doing = 1;
        Graphics g = this.getGraphics();
        this.xor_selection(g, this.mouse_p0, this.mouse_p1);
        this.xor_selection(g, this.mouse_p0, p);
        this.mouse_p1 = p;
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        int did = this.doing;
        Graphics g = this.getGraphics();
        this.doing = 0;
        Log.warn("mouseup " + this.mouse_p0 + " x " + this.mouse_p1);
        switch (did) {
            case 2: {
                Point mouse = this.w2s.inv(new Point(x, y));
                this.pm.global_selection(this.find_mark(mouse));
                break;
            }
        }
        this.repaint();
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        return true;
    }

    void zoomtowrld(Rectangle p) {
        Log.warn("zoom " + p);
        p.y = 0;
        p.height = 100;
        this.world = p;
        this.set_w2s();
    }

    void zoom(Point mouse_p0, Point mouse_p1) {
        Point p0 = geom.point(mouse_p0);
        Point p1 = geom.point(mouse_p1);
        geom.normalize_points(p0, p1);
        if (this.tooclose(p0, p1)) {
            return;
        }
        p0.x = geom.clamp(0, p0.x, this.size().width);
        p1.x = geom.clamp(0, p1.x, this.size().width);
        p0 = this.w2s.inv(p0);
        p1 = this.w2s.inv(p1);
        p0.y = 0;
        p1.y = 100;
        this.zoomtowrld(geom.rectangle(p0, p1));
        this.repaint();
    }

    void unzoom() {
        this.interval = null;
        this.mouse_p1 = null;
        this.mouse_p0 = null;
        this.reset_w2s();
        this.repaint();
    }

    boolean tooclose(Point p, Point q) {
        Dimension d = geom.diff(p, q);
        return Math.abs(d.width) < 20;
    }

    void fill_normalized_rect(Graphics g, Point p0, Point p1) {
        Point q0 = geom.point(p0);
        Point q1 = geom.point(p1);
        geom.normalize_points(q0, q1);
        g.fillRect(q0.x, q0.y, q1.x - q0.x, q1.y - q0.y);
    }

    Segment feature_segment(Feature t) {
        Segment s = this.w2s.transform(new Segment(t.start, 0, t.end, 33));
        if (t.dir == -1) {
            int x = s.x0;
            s.x0 = s.x1;
            s.x1 = x;
        }
        return s;
    }

    int find_mark(Point p) {
        this.busy("blk: scanning alignment");
        Segment s = this.pm.pmf.closest_blk(p.x);
        Feature f = this.pm.features.closest(1, p.x);
        int x = geom.clamp(s.x0, p.x, s.x1);
        this.pm.show_msg(String.valueOf(this.ppseg(s)) + "; " + this.ppfeat(f) + "\n");
        Log.err("blk: " + x + "; " + f);
        this.notbusy();
        return x;
    }

    void set_mark(int x) {
        this.mark = new Point(x, 66);
    }

    void indicate_mark(int x) {
        this.set_mark(x);
        this.repaint();
    }

    String ppseg(Segment s) {
        return s == null ? "[]" : "    [" + s.x0 + "," + s.x1 + "]";
    }

    String ppfeat(Feature f) {
        return f == null ? "" : f.asString();
    }
}

