/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class AlignmentFile {
    static Integer zero = new Integer(0);
    String description;
    String generated;
    String[] header;
    SequenceRef[] sequence;
    AlignmentVector alignments;
    transient String[] dna;
    transient URL source_url;

    public AlignmentFile() {
        this.Init();
    }

    public AlignmentFile(DataInputStream in) throws IOException {
        this.Init();
        this.fromStream(in);
    }

    public AlignmentFile(String filename) throws IOException {
        this.Init();
        this.fromStream(new DataInputStream(new BufferedInputStream(new FileInputStream(filename))));
    }

    public AlignmentFile(URL url) throws IOException {
        this.Init();
        this.source_url = url;
        this.fromStream(new DataInputStream(new BufferedInputStream(url.openStream())));
    }

    void Init() {
        this.header = new String[2];
        this.sequence = new SequenceRef[2];
        this.dna = new String[2];
        this.alignments = new AlignmentVector();
        this.description = "";
        this.generated = "";
        this.header[0] = "";
        this.header[1] = "";
    }

    public int size() {
        return this.alignments.size();
    }

    public String toString() {
        return "d {\n " + this.description + "\n}\n" + "g {\n " + this.generated + "\n}\n" + "h {\n \"" + this.header[0] + "\"\n \"" + this.header[1] + "\"\n}\n" + "s {\n " + this.sequence[0] + "\n " + this.sequence[1] + "\n}\n" + this.alignments.asString();
    }

    public String description() {
        return this.description;
    }

    public void fromStream(DataInputStream in) throws IOException {
        if (!in.readLine().startsWith("#:la")) {
            throw new IOException("The input stream is not an lax file");
        }
        this.addFromStream(in);
    }

    public void fromURL(URL url) throws MalformedURLException, IOException {
        this.fromStream(new DataInputStream(url.openStream()));
    }

    void eatClosebrace(DataInputStream in) throws IOException {
        if (!in.readLine().startsWith("}")) {
            throw new IOException("expected '}'");
        }
    }

    void dFromStream(DataInputStream in) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while (!(line = in.readLine()).startsWith("}")) {
            buf.append(" ").append(line.trim()).append("\n");
        }
        this.description = buf.toString().trim();
    }

    void sFromStream(DataInputStream in) throws IOException {
        this.sequence[0] = new SequenceRef(in.readLine());
        this.sequence[1] = new SequenceRef(in.readLine());
        this.eatClosebrace(in);
    }

    void hFromStream(DataInputStream in) throws IOException {
        this.header[0] = in.readLine();
        this.header[1] = in.readLine();
        this.eatClosebrace(in);
    }

    void aFromStream(DataInputStream in) throws IOException {
        String line;
        Integer x0 = zero;
        Integer y0 = zero;
        Integer x1 = zero;
        Integer y1 = zero;
        Alignment a = new Alignment();
        while ((line = in.readLine()) != null && !line.startsWith("}")) {
            StringTokenizer st = new StringTokenizer(line);
            String k = st.nextToken();
            if (k.startsWith("s")) {
                a.score = new Integer(st.nextToken());
                continue;
            }
            if (k.startsWith("f")) {
                a.filter = new Integer(st.nextToken());
                continue;
            }
            if (k.startsWith("b")) {
                x0 = new Integer(st.nextToken());
                y0 = new Integer(st.nextToken());
                a.endpoints = new Segment(x0, y0, x1, y1);
                continue;
            }
            if (k.startsWith("e")) {
                x1 = new Integer(st.nextToken());
                y1 = new Integer(st.nextToken());
                a.endpoints = new Segment(x0, y0, x1, y1);
                continue;
            }
            if (!k.startsWith("l")) continue;
            Segment s = st.countTokens() == 4 ? new Segment(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken()) : new Segment(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken());
            a.aligned_segments.addElement(s);
        }
        this.alignments.addElement(a);
    }

    public void addFromStream(DataInputStream in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.startsWith("a {")) {
                this.aFromStream(in);
                continue;
            }
            if (line.trim().startsWith("#")) continue;
            if (line.startsWith("d {")) {
                this.dFromStream(in);
                continue;
            }
            if (line.startsWith("s {")) {
                this.sFromStream(in);
                continue;
            }
            if (line.startsWith("h {")) {
                this.hFromStream(in);
                continue;
            }
            throw new IOException("lax: unexpected line: " + line);
        }
    }

    public Rectangle getBounds() {
        Log.warn("s0 = " + this.sequence[0] + " s1 = " + this.sequence[1]);
        return this.sequence[0] == null || this.sequence[1] == null ? new Rectangle(0, 0, 0, 0) : geom.rectangle(geom.point(this.sequence[0].start, this.sequence[1].start), geom.point(this.sequence[0].end, this.sequence[1].end));
    }

    public Rectangle tightbounds() {
        Rectangle b = new Rectangle();
        Enumeration e = this.alignments.elements();
        if (e.hasMoreElements()) {
            b = ((Alignment)e.nextElement()).endpoints.toRectangle();
        }
        while (e.hasMoreElements()) {
            b.add(((Alignment)e.nextElement()).endpoints.toRectangle());
        }
        return b;
    }

    public Enumeration elements() {
        return this.alignments.elements();
    }

    public AlignmentInfo closest(Point p) {
        Enumeration e = this.alignments.elements();
        Alignment ca = null;
        int cn = -1;
        int best = Integer.MAX_VALUE;
        int n = 0;
        while (e.hasMoreElements()) {
            Alignment a = (Alignment)e.nextElement();
            int d = a.distance(p);
            if (d < best) {
                ca = a;
                cn = n;
                best = d;
                Log.warn("closest #" + cn + " " + best + " " + ca.intercept(p));
            }
            ++n;
        }
        return new AlignmentInfo(cn, ca.intercept(p), ca, null);
    }

    public Segment closest_blk(int x) {
        int par = Integer.MAX_VALUE;
        Segment g = null;
        Enumeration e = this.alignments.elements();
        while (e.hasMoreElements()) {
            int d;
            Segment f = ((Alignment)e.nextElement()).endpoints;
            if (f.x0 <= x && x <= f.x1) {
                return f;
            }
            int n = d = f.x0 > x ? f.x0 - x : x - f.x1;
            if (d >= par) continue;
            par = d;
            g = f;
        }
        return g;
    }

    public AlignmentInfo closest_pm(int x) {
        int par = Integer.MAX_VALUE;
        Segment g = null;
        int cn = -1;
        Alignment ca = null;
        Enumeration e = this.alignments.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            Alignment a = (Alignment)e.nextElement();
            Enumeration ae = a.elements();
            while (ae.hasMoreElements()) {
                int d;
                Segment f = (Segment)ae.nextElement();
                if (f.x0 <= x && x <= f.x1) {
                    return new AlignmentInfo(n, new Point(x, f.pm), a, f);
                }
                int n2 = d = f.x0 > x ? f.x0 - x : x - f.x1;
                if (d >= par) continue;
                par = d;
                g = f;
                cn = n;
                ca = a;
            }
            ++n;
        }
        Point p = g == null ? new Point(0, 0) : new Point(geom.clamp(g.x0, x, g.x1), g.pm);
        return new AlignmentInfo(cn, p, ca, g);
    }

    public AlignmentInfo interval(int x) {
        Alignment a = null;
        int best = Integer.MAX_VALUE;
        Segment s = null;
        int nth_align = -1;
        Enumeration e = this.alignments.elements();
        while (e.hasMoreElements()) {
            ++nth_align;
            a = (Alignment)e.nextElement();
            s = a.interval(x);
            if (s != null) break;
        }
        Point p = s == null ? new Point(0, 0) : new Point(x, s.y0 + (x - s.x0));
        return new AlignmentInfo(nth_align, p, a, null);
    }

    public String sequence_name(int n) {
        return this.sequence[n].toString();
    }

    public void set_sequence_url(int n, String f) {
        if (this.sequence[n] == null) {
            this.sequence[n] = new SequenceRef(f, 0, -1);
        } else {
            this.sequence[n].file = f;
        }
        this.dna[n] = null;
    }

    public void set_sequence(int n, String f, int s, int e, String d) {
        this.dna[n] = d;
        if (f != null) {
            this.sequence[n] = new SequenceRef(f, s, e);
        }
    }

    public String sequence(int n) {
        int BASE = 0;
        if (this.dna[n] != null) {
            Log.warn("cached " + this.dna[n].length() + " for " + n);
            return this.dna[n];
        }
        try {
            InputStream is;
            Log.warn("sequence: reading " + this.sequence[n].file);
            try {
                is = new URL(this.source_url, this.sequence[n].file).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                is = new FileInputStream(this.sequence[n].file);
            }
            DNAInputStream ds = new DNAInputStream(new BufferedInputStream(is));
            int start = this.sequence[n].start;
            int end = this.sequence[n].end;
            int len = end - start + 1;
            if (len > 0) {
                byte[] b = new byte[len + BASE];
                ds.skip(start - 1);
                ds.read(b, BASE, len);
                this.dna[n] = new String(b, 0);
                Log.warn("Read " + len + " starting at " + start + " for #" + n);
            } else {
                String s;
                this.dna[n] = s = ds.readall();
                this.sequence[n].start = new Integer(1);
                this.sequence[n].end = new Integer(s.length());
                Log.warn("Read " + s.length() + " for #" + n);
            }
        }
        catch (IOException e) {
            Log.err("loading sequence #" + n + ": " + e);
            this.dna[n] = "";
        }
        return this.dna[n];
    }

    public Alignment alignment(int n) {
        return (Alignment)this.alignments.elementAt(n);
    }

    public String format_and_join(int n) {
        String[] b = Str.align(this.sequence(0), this.sequence(1), this.alignment(n));
        StringBuffer s = new StringBuffer(3 * b[0].length());
        s.append(b[0]).append("\n");
        s.append(b[2]).append("\n");
        s.append(b[1]);
        Log.warn("fmt width = " + b[0].length());
        if (b[0].length() != b[1].length()) {
            Log.err("fmt: b0 != b1 length");
        }
        return s.toString();
    }

    public String[] format(int n) {
        String[] b = Str.align(this.sequence(0), this.sequence(1), this.alignment(n));
        Log.warn("fmt width = " + b[0].length());
        if (b[0].length() != b[1].length()) {
            Log.err("fmt: b0 != b1 length");
        }
        return b;
    }

    public String format(int n, int w) {
        String[] b = Str.align(this.sequence(0), this.sequence(1), this.alignment(n));
        StringBuffer s = new StringBuffer();
        int x = this.alignment((int)n).endpoints.x0;
        int y = this.alignment((int)n).endpoints.y0;
        int k = 1;
        int i = 0;
        while (i < b[2].length()) {
            k = Math.min(w, b[2].length() - i);
            s.append(b[0].substring(i, i + k)).append("\n");
            s.append(b[2].substring(i, i + k)).append("\n");
            s.append(b[1].substring(i, i + k)).append("\n");
            s.append("\n");
            i += k;
        }
        return s.toString();
    }
}

