/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.Enumeration;

public class Alignment {
    Integer filter = zero;
    Integer score = zero;
    Segment endpoints = new Segment(zero, zero, zero, zero);
    SegmentVector aligned_segments = new SegmentVector();
    static Integer zero = new Integer(0);

    public String toString() {
        return " s " + this.score + "\n" + " b " + this.endpoints.x0 + " " + this.endpoints.y0 + "\n" + " e " + this.endpoints.x1 + " " + this.endpoints.y1 + "\n" + " f " + this.filter + "\n" + this.aligned_segments.asString();
    }

    public Enumeration elements() {
        return this.aligned_segments.elements();
    }

    public int distance(Point p) {
        Enumeration e = this.aligned_segments.elements();
        int best = Integer.MAX_VALUE;
        while (e.hasMoreElements()) {
            int t = ((Segment)e.nextElement()).distance(p);
            if (t < 0) {
                System.err.println("alignment:d(" + p + ")=" + t);
            }
            if (t >= best) continue;
            best = t;
        }
        return best;
    }

    public Point intercept(Point p) {
        Enumeration e = this.aligned_segments.elements();
        int dist = Integer.MAX_VALUE;
        Segment best = null;
        while (e.hasMoreElements()) {
            Segment s = (Segment)e.nextElement();
            int t = s.distance(p);
            if (t >= dist) continue;
            dist = t;
            best = s;
        }
        return best == null ? new Point(0, 0) : best.intercept(p);
    }

    public Segment interval(int x) {
        Enumeration e = this.aligned_segments.elements();
        while (e.hasMoreElements()) {
            Segment s = (Segment)e.nextElement();
            if (s.x0 > x || x > s.x1) continue;
            return s;
        }
        return null;
    }

    public int preceding_insertions(int x) {
        int n = 0;
        int last = this.endpoints.y0 - 1;
        Enumeration e = this.aligned_segments.elements();
        while (e.hasMoreElements()) {
            Segment s = (Segment)e.nextElement();
            if (x < s.x0) {
                return n;
            }
            n += s.y0 - (last + 1);
            last = s.y1;
            if (s.x0 > x || x > s.x1) continue;
            return n;
        }
        return 0;
    }

    public int effective_offset(int x) {
        int p = this.preceding_insertions(x);
        int e = x - this.endpoints.x0 + p;
        Log.warn("effective: " + x + " " + this.endpoints.x0 + " " + p + ": " + e);
        return e;
    }

    public int relative_offset(int x, int start) {
        return this.effective_offset(x) - this.effective_offset(start);
    }
}

