/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajGui;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.awt.Rectangle;
import java.util.Vector;

public class ZoomTracker {
    static final String rcsid = "$Revision: 1.3 $$Date: 2007/03/30 20:14:46 $";
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int DOWN = 2;
    static final int UP = 3;
    Maj maj;
    MajState state;
    Rectangle bounds;
    private Vector zoomStack;
    private int zoomIndex;

    public ZoomTracker(Maj maj, MajState majState) {
        this.maj = maj;
        this.state = majState;
        Range range = maj.bf.getBounds(majState.refseq);
        Range range2 = majState.dotplot ? maj.bf.getBounds(majState.seq2) : new Range(0, 0);
        this.bounds = Util.makeRectangle(range, range2);
        if (this.bounds == null) {
            Log.fatalBug("ZoomTracker.ZoomTracker(): Null bounds.");
        }
        this.zoomStack = new Vector();
        this.zoomIndex = -1;
    }

    Rectangle getZoom() {
        return this.zoomIndex < 0 ? null : (Rectangle)this.zoomStack.get(this.zoomIndex);
    }

    void unzoom() {
        this.setZoom(this.bounds);
    }

    void slideZoom(int n) {
        Rectangle rectangle = this.getZoom();
        if (rectangle != null) {
            switch (n) {
                case 0: {
                    int n2 = Math.max(this.bounds.x, rectangle.x - rectangle.width / 2);
                    this.setZoom(new Rectangle(n2, rectangle.y, rectangle.width, rectangle.height));
                    break;
                }
                case 1: {
                    int n3 = Math.min(this.bounds.x + this.bounds.width, rectangle.x + rectangle.width + rectangle.width / 2);
                    this.setZoom(new Rectangle(n3 - rectangle.width, rectangle.y, rectangle.width, rectangle.height));
                    break;
                }
                case 2: {
                    int n4 = Math.max(this.bounds.y, rectangle.y - rectangle.height / 2);
                    this.setZoom(new Rectangle(rectangle.x, n4, rectangle.width, rectangle.height));
                    break;
                }
                case 3: {
                    int n5 = Math.min(this.bounds.y + this.bounds.height, rectangle.y + rectangle.height + rectangle.height / 2);
                    this.setZoom(new Rectangle(rectangle.x, n5 - rectangle.height, rectangle.width, rectangle.height));
                    break;
                }
                default: {
                    Log.fatalBug("ZoomTracker.slideZoom(): Invalid direction.");
                }
            }
        }
    }

    void setZoom(Rectangle rectangle) {
        int n = this.zoomStack.size() - 1;
        while (n > this.zoomIndex) {
            this.zoomStack.remove(n);
            --n;
        }
        if (this.zoomStack.size() != this.zoomIndex + 1) {
            Log.fatalBug("ZoomTracker.setZoom(): Incorrect stack size.");
        }
        if (rectangle == null) {
            Log.fatalBug("ZoomTracker.setZoom(): Null argument.");
        }
        if (!rectangle.equals(this.getZoom())) {
            ++this.zoomIndex;
            this.zoomStack.add(this.zoomIndex, rectangle);
        }
        this.state.showZinfo();
        this.enableZoomControls();
    }

    void backZoom() {
        if (this.zoomIndex > 0) {
            --this.zoomIndex;
        }
        this.state.showZinfo();
        this.enableZoomControls();
    }

    void forwardZoom() {
        if (this.zoomIndex < this.zoomStack.size() - 1) {
            ++this.zoomIndex;
        }
        this.state.showZinfo();
        this.enableZoomControls();
    }

    void enableZoomControls() {
        MajGui majGui = this.state.gui;
        if (majGui != null) {
            Rectangle rectangle = this.getZoom();
            boolean bl = this.bounds == null || rectangle == null;
            majGui.enableWidget("backzoom", this.zoomIndex > 0);
            majGui.enableWidget("forwardzoom", this.zoomIndex < this.zoomStack.size() - 1);
            majGui.enableWidget("unzoom", !bl && !rectangle.equals(this.bounds));
            majGui.enableWidget("left", !bl && rectangle.x > this.bounds.x);
            majGui.enableWidget("right", !bl && rectangle.x + rectangle.width < this.bounds.x + this.bounds.width);
            majGui.enableWidget("down", !bl && rectangle.y > this.bounds.y);
            majGui.enableWidget("up", !bl && rectangle.y + rectangle.height < this.bounds.y + this.bounds.height);
        }
    }

    boolean isValidZoom(int n, int n2, boolean bl, boolean bl2) {
        Range range;
        String string = null;
        Range range2 = range = bl ? new Range(this.bounds.x, this.bounds.x + this.bounds.width) : new Range(this.bounds.y, this.bounds.y + this.bounds.height);
        if (!range.contains(n) || !range.contains(n2)) {
            int n3 = this.maj.specs.getOffset(bl ? this.state.refseq : this.state.seq2);
            string = "Invalid zoom region: " + (bl ? "x" : "y") + "-endpoint is outside valid range [" + (range.start + n3) + "-" + (range.end + n3) + "].";
        } else if (n2 < n) {
            string = "Invalid zoom region: end can't be less than start.";
        } else if (n2 - n < 4) {
            string = "Invalid zoom region: start and end can't be closer than 4 bp.";
        }
        if (string != null) {
            if (bl2) {
                Log.showError(string);
            } else {
                Log.err(string);
            }
        }
        return string == null;
    }
}

