/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Transformer;
import edu.psu.bx.gmaj.Util;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ZoomPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final String rcsid = "$Revision: 1.21 $$Date: 2008/04/16 14:47:59 $";
    static final int NOTHING = 0;
    static final int CLICK = 1;
    static final int DRAG = 2;
    static final int CROSS = 3;
    static final int NONE = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final Point offscreen = new Point(-1, -1);
    Maj maj;
    MajState state;
    boolean novert;
    int bottom;
    int top;
    Transformer w2s;
    private boolean mouseEnabled;
    private Point p0;
    private Point p1;
    private Point cross;
    private int doing;
    private int button;

    ZoomPane(Maj maj, MajState majState, int n, int n2) {
        this.maj = maj;
        this.state = majState;
        this.novert = n2 >= n;
        this.bottom = n;
        this.top = n2;
        this.w2s = null;
        this.mouseEnabled = false;
        this.p0 = this.p1 = offscreen;
        this.cross = offscreen;
        this.doing = 0;
        this.button = 0;
        this.setBackground(Config.backgroundColor);
    }

    public void paintComponent(Graphics graphics) {
        this.state.gui.toolkit.sync();
        super.paintComponent(graphics);
        this.set_w2s();
        graphics.setPaintMode();
        this.paintContents(graphics);
        this.enableMouseEvents(this.state.zt.getZoom() != null);
    }

    private Rectangle morph(Rectangle rectangle) {
        return rectangle == null ? null : new Rectangle(rectangle.x, this.bottom, rectangle.width, this.top - this.bottom);
    }

    private void set_w2s() {
        Rectangle rectangle = this.novert ? this.morph(this.state.zt.getZoom()) : this.state.zt.getZoom();
        Rectangle rectangle2 = Util.subtractInsets(new Rectangle(this.getSize()), this.getInsets());
        this.w2s = rectangle == null ? null : new Transformer(Util.fliprect(rectangle), rectangle2);
    }

    private void enableMouseEvents(boolean bl) {
        if (bl && !this.mouseEnabled) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.mouseEnabled = true;
        } else if (!bl && this.mouseEnabled) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.moveZoomRect(offscreen, offscreen);
            this.moveCrosshairs(offscreen);
            this.mouseEnabled = false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            this.maj.global.lastMove = null;
            this.state.clearLoc();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            this.maj.global.lastMove = mouseEvent;
            Point point = this.w2s.inverse(mouseEvent.getPoint());
            this.showMouseLoc(point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.state.gui.toolkit.sync();
        Point point = mouseEvent.getPoint();
        int n = SwingUtilities.isLeftMouseButton(mouseEvent) ? 1 : (this.button = SwingUtilities.isRightMouseButton(mouseEvent) ? 2 : 0);
        if (this.button == 2 || mouseEvent.isShiftDown()) {
            this.doing = 3;
            this.moveZoomRect(offscreen, offscreen);
            this.moveCrosshairs(point);
        } else if (this.button == 1) {
            this.doing = 1;
            if (this.novert) {
                this.p0 = new Point(point.x, this.getHeight());
                this.p1 = new Point(point.x, 0);
            } else {
                this.p0 = this.p1 = point;
            }
            this.moveZoomRect(this.p0, this.p1);
            this.moveCrosshairs(offscreen);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.maj.global.lastMove = mouseEvent;
        Point point = mouseEvent.getPoint();
        Point point2 = this.w2s.inverse(point);
        this.showMouseLoc(point2);
        switch (this.doing) {
            case 1: {
                this.doing = 2;
            }
            case 2: {
                if (this.novert) {
                    point.move(point.x, 0);
                }
                this.moveZoomRect(this.p0, point);
                break;
            }
            case 3: {
                this.moveCrosshairs(point);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.button == 1 || SwingUtilities.isRightMouseButton(mouseEvent) && this.button == 2) {
            switch (this.doing) {
                case 1: {
                    this.moveZoomRect(offscreen, offscreen);
                    this.doClick(this.w2s.inverse(mouseEvent.getPoint()));
                    break;
                }
                case 2: {
                    Point point = this.p0;
                    Point point2 = this.p1;
                    this.moveZoomRect(offscreen, offscreen);
                    if (this.tooclose(point, point2, 3)) {
                        this.doClick(this.w2s.inverse(point));
                        break;
                    }
                    this.doZoom(point, point2);
                    break;
                }
                case 3: {
                    this.moveCrosshairs(offscreen);
                }
            }
            this.doing = 0;
            this.button = 0;
            this.state.gui.restoreFocus();
            this.state.gui.content.repaint();
        }
    }

    private void moveZoomRect(Point point, Point point2) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(Config.guideColor);
            graphics.setXORMode(Config.backgroundColor);
            this.drawNormalizedRect(graphics, this.p0, this.p1);
            this.drawNormalizedRect(graphics, point, point2);
            graphics.setPaintMode();
        }
        this.p0 = point;
        this.p1 = point2;
    }

    private void drawNormalizedRect(Graphics graphics, Point point, Point point2) {
        if (point.x != point2.x && point.y != point2.y) {
            Rectangle rectangle = Util.normalizedRectangle(point, point2);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void moveCrosshairs(Point point) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(Config.guideColor);
            graphics.setXORMode(Config.backgroundColor);
            graphics.drawLine(this.cross.x, 0, this.cross.x, n2);
            graphics.drawLine(0, this.cross.y, n, this.cross.y);
            graphics.drawLine(point.x, 0, point.x, n2);
            graphics.drawLine(0, point.y, n, point.y);
            graphics.setPaintMode();
        }
        this.cross = point;
    }

    private void doZoom(Point point, Point point2) {
        Point point3;
        Point point4 = this.w2s.inverse(point);
        if (this.tooclose(point4, point3 = this.w2s.inverse(point2), 4)) {
            Log.showError("Zoom region can't be smaller than 4 bp.");
            return;
        }
        if (this.novert) {
            Rectangle rectangle = this.state.zt.getZoom();
            point4.move(point4.x, rectangle.y);
            point3.move(point3.x, rectangle.y + rectangle.height);
        }
        this.state.zt.setZoom(Util.normalizedRectangle(point4, point3));
    }

    private boolean tooclose(Point point, Point point2, int n) {
        return Math.abs(point.x - point2.x) < n || !this.novert && Math.abs(point.y - point2.y) < n;
    }

    abstract void paintContents(Graphics var1);

    abstract void showMouseLoc(Point var1);

    abstract void doClick(Point var1);
}

