/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Chooser;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.ZoomTracker;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ZoomChooser
extends Chooser {
    static final String rcsid = "$Revision: 1.13 $$Date: 2007/12/05 19:25:36 $";
    private static final int textCols = 12;
    Maj maj;
    int refseq;
    boolean dotplot;
    int seq2;
    ZoomTracker zt;
    int offsetX;
    int offsetY;
    Range newzoomX;
    Range newzoomY;
    private JTextField xstartbox;
    private JTextField xendbox;
    private JTextField ystartbox;
    private JTextField yendbox;

    public ZoomChooser(JFrame jFrame, Maj maj, int n, boolean bl, int n2) {
        super(jFrame, "Set a New Zoom Region");
        this.maj = maj;
        this.refseq = n;
        this.dotplot = bl;
        this.seq2 = n2;
        this.zt = bl ? maj.dpstates[n][n2].zt : maj.states[n].zt;
        this.offsetX = maj.specs.getOffset(n);
        this.offsetY = bl ? maj.specs.getOffset(n2) : 0;
        Rectangle rectangle = this.zt.bounds;
        Rectangle rectangle2 = this.zt.getZoom();
        JPanel jPanel = this.content;
        String string = maj.bf.mafseqname(n);
        jPanel.add(this.widgetPanel("Reference sequence:", new MultiLineLabel(string, this)));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        String string2 = this.rangeString(new Range(rectangle.x, rectangle.x + rectangle.width), this.offsetX);
        jPanel.add(this.widgetPanel("Valid range:", new MultiLineLabel(string2, this)));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        String string3 = this.rangeString(new Range(rectangle2.x, rectangle2.x + rectangle2.width), this.offsetX);
        jPanel.add(this.widgetPanel("Current zoom:", new MultiLineLabel(string3, this)));
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.xstartbox = new JTextField("", 12);
        this.xendbox = new JTextField("", 12);
        jPanel.add(this.rangeInputPanel(this.xstartbox, this.xendbox));
        if (bl) {
            jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
            string = maj.bf.mafseqname(n2);
            jPanel.add(this.widgetPanel("Other sequence:", new MultiLineLabel(string, this)));
            jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            string2 = this.rangeString(new Range(rectangle.y, rectangle.y + rectangle.height), this.offsetY);
            jPanel.add(this.widgetPanel("Valid range:", new MultiLineLabel(string2, this)));
            jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            string3 = this.rangeString(new Range(rectangle2.y, rectangle2.y + rectangle2.height), this.offsetY);
            jPanel.add(this.widgetPanel("Current zoom:", new MultiLineLabel(string3, this)));
            jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
            this.ystartbox = new JTextField("", 12);
            this.yendbox = new JTextField("", 12);
            jPanel.add(this.rangeInputPanel(this.ystartbox, this.yendbox));
        }
        Util.adjustChildren(jPanel, 0.0f, 0.5f, 0, 0);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.xstartbox.requestFocus();
    }

    private String rangeString(Range range, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        return numberFormat.format(range.start + n) + " - " + numberFormat.format(range.end + n);
    }

    private JPanel rangeInputPanel(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Start:"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(jComponent);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(new JLabel("End:"));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(jComponent2);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected boolean validateInput() {
        int n;
        int n2;
        Rectangle rectangle = this.zt.getZoom();
        String string = Util.stripChar(',', this.xstartbox.getText().trim());
        String string2 = Util.stripChar(',', this.xendbox.getText().trim());
        try {
            n2 = string.equals("") ? rectangle.x : Integer.parseInt(string) - this.offsetX;
            n = string2.equals("") ? rectangle.x + rectangle.width : Integer.parseInt(string2) - this.offsetX;
        }
        catch (NumberFormatException numberFormatException) {
            Log.showError("Missing or invalid integer.");
            return false;
        }
        if (!this.zt.isValidZoom(n2, n, true, true)) {
            return false;
        }
        this.newzoomX = new Range(n2, n);
        if (this.dotplot) {
            int n3;
            int n4;
            String string3 = Util.stripChar(',', this.ystartbox.getText().trim());
            String string4 = Util.stripChar(',', this.yendbox.getText().trim());
            try {
                n4 = string3.equals("") ? rectangle.y : Integer.parseInt(string3) - this.offsetY;
                n3 = string4.equals("") ? rectangle.y + rectangle.height : Integer.parseInt(string4) - this.offsetY;
            }
            catch (NumberFormatException numberFormatException) {
                Log.showError("Missing or invalid integer.");
                return false;
            }
            if (!this.zt.isValidZoom(n4, n3, false, true)) {
                return false;
            }
            this.newzoomY = new Range(n4, n3);
        }
        return true;
    }
}

