/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class VisibilityPanel
extends JPanel {
    static final String rcsid = "$Revision: 1.3 $$Date: 2008/04/10 04:09:41 $";
    private static final Border panelborder = BorderFactory.createEmptyBorder(1, 10, 3, 0);
    private static final int gap1 = 20;
    private static final int gap2 = 5;
    Maj maj;
    MajState state;
    Vector mafboxes;
    JCheckBox tagbox;
    JLabel tagcount;
    private JPanel p;
    private JScrollPane sp;

    public VisibilityPanel(Maj maj, MajState majState) {
        Object object;
        Object object2;
        this.maj = maj;
        this.state = majState;
        this.mafboxes = new Vector();
        this.p = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 0));
        this.p.setBorder(panelborder);
        int n = 0;
        while (n < maj.nmaf) {
            object2 = new JCheckBox("", maj.global.showMafs.get(n));
            final int n2 = n;
            object = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    VisibilityPanel.this.maj.global.setShowMaf(n2, itemEvent.getStateChange() == 1);
                    VisibilityPanel.this.state.gui.restoreFocus();
                }
            };
            ((AbstractButton)object2).addItemListener((ItemListener)object);
            if (n < 10) {
                char c = Character.forDigit(n, 10);
                AbstractAction abstractAction = new AbstractAction((JCheckBox)object2){
                    private final /* synthetic */ JCheckBox val$b;
                    {
                        this.val$b = jCheckBox;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$b.doClick();
                    }
                };
                ((JComponent)object2).getInputMap(2).put(KeyStroke.getKeyStroke(c), "maf");
                ((JComponent)object2).getActionMap().put("maf", abstractAction);
            }
            JLabel jLabel = new JLabel(n + ": " + maj.bf.mafname(n));
            jLabel.setForeground(Config.getFileColor(n));
            this.mafboxes.addElement(object2);
            this.p.add(Box.createRigidArea(new Dimension(20, 0)));
            this.p.add((Component)object2);
            this.p.add(Box.createRigidArea(new Dimension(5, 0)));
            this.p.add(jLabel);
            ++n;
        }
        this.tagbox = new JCheckBox("", maj.global.showTagged);
        object2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                VisibilityPanel.this.maj.global.setShowTagged(itemEvent.getStateChange() == 1);
                VisibilityPanel.this.state.gui.restoreFocus();
            }
        };
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisibilityPanel.this.tagbox.doClick();
            }
        };
        this.tagbox.addItemListener((ItemListener)object2);
        this.tagbox.getInputMap(2).put(KeyStroke.getKeyStroke('T'), "tagged");
        this.tagbox.getActionMap().put("tagged", abstractAction);
        object = new JLabel("Tagged ");
        ((JComponent)object).setForeground(Config.tagLabelColor);
        this.tagcount = new JLabel(" ");
        this.tagcount.setForeground(Config.tagLabelColor);
        if (maj.global.tagcount != Util.countSetBits(maj.global.usertags)) {
            Log.fatalBug("VisibilityPanel.VisibilityPanel(): Inconsistent tag count.");
        }
        this.setTagCount(maj.global.tagcount);
        this.p.add(Box.createRigidArea(new Dimension(20, 0)));
        this.p.add(this.tagbox);
        this.p.add(Box.createRigidArea(new Dimension(5, 0)));
        this.p.add((Component)object);
        this.p.add(Box.createRigidArea(new Dimension(5, 0)));
        this.p.add(this.tagcount);
        this.p.add(Box.createRigidArea(new Dimension(20, 0)));
        this.p.add(Box.createHorizontalGlue());
        this.sp = new JScrollPane(this.p);
        this.sp.setVerticalScrollBarPolicy(21);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.sp);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JViewport jViewport = VisibilityPanel.this.sp.getViewport();
                    int n = 0;
                    while (n < 10) {
                        jViewport.setViewPosition(new Point(0, 0));
                        Point point = jViewport.getViewPosition();
                        if (point.x != 0 || point.y != 0) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    Log.warn("Can't scroll visibility checkboxes to start.");
                }
            }
        });
    }

    public void syncToState() {
        int n = 0;
        while (n < this.maj.nmaf) {
            JCheckBox jCheckBox = (JCheckBox)this.mafboxes.elementAt(n);
            jCheckBox.setSelected(this.maj.global.showMafs.get(n));
            ++n;
        }
        this.tagbox.setSelected(this.maj.global.showTagged);
        this.setTagCount(this.maj.global.tagcount);
    }

    private void setTagCount(int n) {
        this.tagcount.setText("( " + n + " )");
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(9999, this.getPreferredSize().height);
    }

    public Dimension getPreferredSize() {
        JViewport jViewport = this.sp.getViewport();
        Insets insets = this.getInsets();
        int n = this.p.getPreferredSize().width;
        int n2 = this.p.getPreferredSize().height;
        if (jViewport.getExtentSize().width < jViewport.getViewSize().width) {
            n2 += UIManager.getInt("ScrollBar.width");
        }
        if (insets != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        return new Dimension(n, n2);
    }
}

