/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BlockIndex;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.LinkbarList;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.Plot;
import edu.psu.bx.gmaj.UnderlayList;
import java.util.Vector;

public class View {
    static final String rcsid = "$Revision: 1.19 $$Date: 2007/12/05 19:25:36 $";
    Maj maj;
    int refseq;
    Plot[] plots;
    FeatureList exons;
    FeatureList repeats;
    LinkbarList links;
    UnderlayList[] stripes;
    UnderlayList[] stripes2;
    UnderlayList hilights;
    Vector correctness;
    Vector presentness;
    BlockIndex bi;
    private boolean active;

    public View(Maj maj, int n) {
        this.maj = maj;
        this.refseq = n;
        this.plots = new Plot[maj.nseq];
        this.stripes = new UnderlayList[maj.nseq];
        this.stripes2 = new UnderlayList[maj.nseq];
        this.correctness = maj.bf.scoreset(n, "correct");
        this.presentness = maj.bf.scoreset(n, "present");
        if (this.correctness == null) {
            this.correctness = new Vector();
        }
        if (this.presentness == null) {
            this.presentness = new Vector();
        }
        this.bi = null;
        this.active = false;
        String string = maj.bf.mafseqname(n);
        this.exons = (FeatureList)maj.closet.get(maj.specs.getExonSpec(n), 1, string);
        this.repeats = (FeatureList)maj.closet.get(maj.specs.getRepeatSpec(n), 2, string);
        this.links = (LinkbarList)maj.closet.get(maj.specs.getLinkSpec(n), 3, string);
        this.hilights = (UnderlayList)maj.closet.get(maj.specs.getHighlightSpec(n), 5, string);
    }

    public void activate() {
        if (this.active) {
            return;
        }
        int n = 0;
        while (n < this.maj.nseq) {
            if (n == this.refseq) {
                this.plots[n] = null;
                this.stripes[n] = null;
                this.stripes2[n] = null;
            } else {
                String string = this.maj.bf.mafseqname(this.refseq);
                String string2 = this.maj.bf.mafseqname(n);
                this.plots[n] = new Plot(this.maj.bf, this.refseq, n);
                this.stripes[n] = (UnderlayList)this.maj.closet.get(this.maj.specs.getUnderlaySpec(this.refseq, n), 4, string);
                this.stripes2[n] = (UnderlayList)this.maj.closet.get(this.maj.specs.getUnderlaySpec(n, this.refseq), 4, string2);
            }
            ++n;
        }
        this.maj.closet.clean();
        this.bi = new BlockIndex(this.maj.bf, this.refseq);
        this.active = true;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        int n = 0;
        while (n < this.maj.nseq) {
            this.plots[n] = null;
            this.stripes[n] = null;
            this.stripes2[n] = null;
            ++n;
        }
        this.bi = null;
        this.active = false;
    }
}

