/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.image.MemoryImageSource;
import java.util.BitSet;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

final class Util {
    static final String rcsid = "$Revision: 1.34 $$Date: 2008/06/20 21:46:51 $";

    Util() {
    }

    static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void repaint(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            if (bl) {
                jComponent.paintImmediately(jComponent.getBounds(null));
            } else {
                jComponent.repaint();
            }
        }
    }

    static int countSetBits(BitSet bitSet) {
        int n = 0;
        int n2 = 0;
        while (n2 < bitSet.length()) {
            if (bitSet.get(n2)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    static String drop(String string, int n) {
        return string.substring(n);
    }

    static String take(String string, int n) {
        return string.substring(0, n);
    }

    static String firstWord(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
    }

    static String toCap(String string) {
        return Character.toUpperCase(string.charAt(0)) + Util.drop(string, 1);
    }

    static String trimComment(String string) {
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '#' && !bl) break;
            if (c == '\"') {
                bl = !bl;
            }
            ++n;
        }
        return Util.take(string, n);
    }

    static String unquote(String string) throws BadInputException {
        if (string == null) {
            return null;
        }
        int n = (string = string.trim()).length();
        if (n > 1 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 1;
            while (n2 < n - 1) {
                char c = string.charAt(n2);
                if (c == '\"' && string.charAt(n2 - 1) != '\\') {
                    throw new BadInputException("Embedded quotes must be escaped:  " + string);
                }
                if (c != '\\' || string.charAt(n2 + 1) != '\"' || n2 == n - 2) {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string = stringBuffer.toString().trim();
        } else if (string.indexOf(34) >= 0) {
            Log.warn("Unquoted string contains quotes:  " + string);
        }
        return string;
    }

    static String stripChar(char c, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 != c) {
                stringBuffer.append(c2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String replaceTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\t') {
                Util.padBuffer(stringBuffer, 3);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String wrapLines(String string, int n, String string2) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + n2 / n + 1);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(string.charAt(n4));
            if (++n3 >= n && n4 < n2 - 1) {
                stringBuffer.append(string2);
                n3 = 0;
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    static String wrapAtWords(String var0, int var1_1, String var2_2) {
        var3_3 = "\n\r\f";
        var4_4 = " \t";
        var5_5 = "`~!@#$%^&*()-_=+\\|[]{};:'\",.<>/?";
        var6_6 = new StringTokenizer(var0, var3_3, true);
        var7_7 = new StringBuffer(var0.length());
        while (var6_6.hasMoreTokens()) {
            var8_8 = var6_6.nextToken();
            if (var3_3.indexOf(var8_8) < 0) ** GOTO lbl22
            var7_7.append(var8_8);
            continue;
lbl-1000:
            // 1 sources

            {
                var9_9 = Util.lastIndexOfAny(var8_8, var4_4, var1_1);
                if (var9_9 <= 0 || Util.take(var8_8, var9_9).trim().equals("")) {
                    var9_9 = Util.lastIndexOfAny(var8_8, var5_5, var1_1 - 1);
                }
                if (var9_9 <= 0 || Util.take(var8_8, var9_9).trim().equals("")) {
                    var9_9 = var1_1;
                }
                if (var9_9 < var1_1 && var5_5.indexOf(var8_8.charAt(var9_9)) >= 0) {
                    ++var9_9;
                }
                var7_7.append(Util.take(var8_8, var9_9) + var2_2);
                var8_8 = Util.drop(var8_8, var8_8.charAt(var9_9) == ' ' ? var9_9 + 1 : var9_9);
lbl22:
                // 2 sources

                ** while (var8_8.length() > var1_1)
            }
lbl23:
            // 1 sources

            var7_7.append(var8_8);
        }
        return var7_7.toString();
    }

    static String blank(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        Util.padBuffer(stringBuffer, n);
        return stringBuffer.toString();
    }

    static void padBuffer(StringBuffer stringBuffer, int n) {
        while (n-- > 0) {
            stringBuffer.append(' ');
        }
    }

    static boolean isInteger(String string) {
        return new StringTokenizer(string, "0123456789,").countTokens() == 0;
    }

    static boolean grokBoolean(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).equals("true") || string.equals("yes") || string.equals("on") || string.equals("t") || string.equals("y") || string.equals("1") || string.equals("+");
    }

    static Color makeColor(String string) throws BadInputException {
        String string2 = "A color specification must consist of 3 comma-separated\nintegers, each in the range 0-255 (e.g. \"0,0,255\").";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 3) {
            throw new BadInputException(string2);
        }
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (Util.clamp(0, n, 255) != n || Util.clamp(0, n2, 255) != n2 || Util.clamp(0, n3, 255) != n3) {
                throw new BadInputException(string2);
            }
            return new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException(string2);
        }
    }

    static String label(String string, int n) {
        String string2 = Util.blank(n - string.length());
        return string + string2;
    }

    static String label(int n, int n2) {
        String string = Integer.toString(n);
        String string2 = Util.blank(n2 - string.length());
        return string2 + string;
    }

    static int indexOfAny(String string, String string2, int n) {
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) >= 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int lastIndexOfAny(String string, String string2, int n) {
        int n2 = n;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) >= 0) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    static int countNonGap(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != '-') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    static int div(int n, int n2) {
        return (int)Math.floor((double)n / (double)n2);
    }

    static int pow(int n, int n2) {
        return (int)Math.pow(n, n2);
    }

    static int clamp(int n, int n2, int n3) {
        if (n <= n3) {
            if (n2 < n) {
                return n;
            }
            if (n2 > n3) {
                return n3;
            }
            return n2;
        }
        if (n2 > n) {
            return n;
        }
        if (n2 < n3) {
            return n3;
        }
        return n2;
    }

    static boolean overlaps(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        int n7 = Math.min(n3, n4);
        int n8 = Math.max(n3, n4);
        return n5 <= n8 && n6 >= n7;
    }

    static boolean inside(Point point, Rectangle rectangle) {
        return Util.clamp(rectangle.x, point.x, rectangle.x + rectangle.width) == point.x && Util.clamp(rectangle.y, point.y, rectangle.y + rectangle.height) == point.y;
    }

    static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return null;
        }
        if (rectangle.width < 0 || rectangle.height < 0 || rectangle2.width < 0 || rectangle2.height < 0) {
            Log.fatalBug("Util.intersect(): Rectangle has negative width or height.");
        }
        Range range = new Range(rectangle.x, rectangle.x + rectangle.width);
        range = range.intersect(new Range(rectangle2.x, rectangle2.x + rectangle2.width));
        Range range2 = new Range(rectangle.y, rectangle.y + rectangle.height);
        range2 = range2.intersect(new Range(rectangle2.y, rectangle2.y + rectangle2.height));
        return Util.makeRectangle(range, range2);
    }

    static Rectangle makeRectangle(Range range, Range range2) {
        if (range == null || range2 == null) {
            return null;
        }
        return new Rectangle(range.start, range2.start, range.end - range.start, range2.end - range2.start);
    }

    static Rectangle normalizedRectangle(Point point, Point point2) {
        int n = Math.min(point.x, point2.x);
        int n2 = Math.min(point.y, point2.y);
        int n3 = Math.abs(point.x - point2.x);
        int n4 = Math.abs(point.y - point2.y);
        return new Rectangle(n, n2, n3, n4);
    }

    static Rectangle fliprect(Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, -rectangle.height);
    }

    static Rectangle padRectangle(Rectangle rectangle, double d) {
        int n = (int)((double)rectangle.width * d);
        int n2 = (int)((double)rectangle.height * d);
        return new Rectangle(rectangle.x - n, rectangle.y - n2, rectangle.width + 2 * n, rectangle.height + 2 * n2);
    }

    static Rectangle subtractInsets(Rectangle rectangle, Insets insets) {
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    static Border marginBorder(Insets insets) {
        return BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    static Border paddedBorder(Insets insets, Insets insets2, Insets insets3, Color color) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (insets3 == null) {
            insets3 = new Insets(0, 0, 0, 0);
        }
        MatteBorder matteBorder = BorderFactory.createMatteBorder(insets2.top, insets2.left, insets2.bottom, insets2.right, color);
        return BorderFactory.createCompoundBorder(Util.marginBorder(insets), BorderFactory.createCompoundBorder(matteBorder, Util.marginBorder(insets3)));
    }

    static void adjustChildren(Container container, float f, float f2, int n, int n2) {
        Component[] componentArray = container.getComponents();
        int n3 = container.getComponentCount();
        Insets insets = new Insets(n, n2, n, n2);
        int n4 = 0;
        while (n4 < n3) {
            try {
                JComponent jComponent = (JComponent)componentArray[n4];
                jComponent.setAlignmentX(f);
                jComponent.setAlignmentY(f2);
                if (jComponent instanceof JButton) {
                    ((JButton)jComponent).setMargin(insets);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n4;
        }
    }

    static void printFontSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
        Graphics2D graphics2D = (Graphics2D)jComponent.getGraphics();
        String string = "[graphics is null => single-char info not available]";
        if (graphics2D != null) {
            LineMetrics lineMetrics = font.getLineMetrics("X", graphics2D.getFontRenderContext());
            string = "ascentX = " + lineMetrics.getAscent() + "; descentX = " + lineMetrics.getDescent();
        }
        Log.err("height = " + fontMetrics.getHeight() + "\n" + "ascent = " + fontMetrics.getAscent() + "; descent = " + fontMetrics.getDescent() + "; leading = " + fontMetrics.getLeading() + "\n" + "maxAscent = " + fontMetrics.getMaxAscent() + "; maxDescent = " + fontMetrics.getMaxDescent() + "\n" + "maxCharBounds = " + fontMetrics.getMaxCharBounds(graphics2D) + "\n" + string + "\n" + "insets = " + jComponent.getInsets() + "\n");
    }

    static ImageIcon makeCursorArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 13;
        int n4 = 13;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n, n, n, n, n2, n2, n2, n2, n2, n2, n, n, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "cursor arrow");
    }

    static ImageIcon makeMarkCircle(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 13;
        int n4 = 13;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n, n, n, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n, n, n, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "small circle");
    }

    static ImageIcon makeZoomBars(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 13;
        int n4 = 13;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "two vertical bars");
    }

    static ImageIcon makeMenuArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n, n, n, n, n, n, n, n2, n, n, n, n, n, n, n, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "menu opener");
    }

    static ImageIcon makeLeftArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "arrow pointing left");
    }

    static ImageIcon makeRightArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "arrow pointing right");
    }

    static ImageIcon makeDownArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n, n, n, n2, n, n, n, n2, n, n, n, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "arrow pointing down");
    }

    static ImageIcon makeUpArrow(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n, n, n, n2, n, n, n, n2, n, n, n, n2, n2, n2, n, n, n, n, n, n2, n2, n2, n2, n2, n, n, n, n2, n2, n2, n2, n2, n2, n2, n, n2, n2, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "arrow pointing up");
    }

    static ImageIcon makeDots(Toolkit toolkit, Color color) {
        int n = color.getRGB();
        int n2 = 0;
        int n3 = 9;
        int n4 = 9;
        int[] nArray = new int[]{n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2, n, n, n2, n2, n2, n2, n2, n2, n2};
        Image image = toolkit.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return new ImageIcon(image, "diagonal dots");
    }

    static String orgName(String string) {
        int n;
        if (string.endsWith("~")) {
            string = Util.take(string, string.length() - "~".length());
        }
        return (n = string.lastIndexOf(46)) < 0 ? string : Util.take(string, n);
    }

    static boolean isValidNt(char c) {
        return c == 'A' || c == 'C' || c == 'G' || c == 'T' || c == 'N' || c == 'X';
    }

    static boolean isTrueNt(char c) {
        return c == 'A' || c == 'C' || c == 'G' || c == 'T';
    }

    static String reverseComplement(String string) throws BadInputException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        int n = string.length() - 1;
        while (n >= 0) {
            char c;
            char c2 = string.charAt(n);
            switch (Character.toUpperCase(c2)) {
                case 'A': {
                    c = 'T';
                    break;
                }
                case 'C': {
                    c = 'G';
                    break;
                }
                case 'G': {
                    c = 'C';
                    break;
                }
                case 'T': {
                    c = 'A';
                    break;
                }
                case 'N': {
                    c = 'N';
                    break;
                }
                case 'X': {
                    c = 'X';
                    break;
                }
                default: {
                    throw new BadInputException("Unexpected character '" + c2 + "' in sequence.");
                }
            }
            if (Character.isLowerCase(c2)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
            --n;
        }
        return stringBuffer.toString();
    }

    static String dotify(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c;
            char c2 = stringBuffer.charAt(n);
            if (c2 != '-' && Util.isTrueNt(c = Character.toUpperCase(c2)) && c == Character.toUpperCase(string2.charAt(n))) {
                stringBuffer.setCharAt(n, '.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

