/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.DefaultExonColors;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.GenericAnnot;
import edu.psu.bx.gmaj.GenericAnnotList;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Underlay;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class UnderlayList
implements Copyable {
    static final String rcsid = "$Revision: 1.18 $$Date: 2007/11/15 18:42:54 $";
    String filename;
    Hashtable colors;
    Vector regions;

    public UnderlayList() {
        this.filename = "";
        this.colors = new Hashtable();
        this.regions = new Vector();
    }

    public UnderlayList(String string, Hashtable hashtable, Vector vector) {
        this.filename = string;
        this.colors = hashtable;
        this.regions = vector;
        vector.trimToSize();
    }

    public UnderlayList(GenericAnnotList genericAnnotList, int n) {
        this(genericAnnotList, n, new Range(0, 0));
    }

    public UnderlayList(GenericAnnotList genericAnnotList, int n, Range range) {
        this.filename = genericAnnotList.filename;
        this.colors = new Hashtable();
        this.regions = new Vector(genericAnnotList.regions.size());
        try {
            this.fromGeneric(genericAnnotList, n, range);
        }
        catch (BadInputException badInputException) {
            Log.showError("Error loading underlays from file \"" + this.filename + "\":" + "\n" + badInputException);
        }
        this.regions.trimToSize();
    }

    public UnderlayList(String string) {
        this(string, null);
    }

    public UnderlayList(String string, BufferedReader bufferedReader) {
        this(string, bufferedReader, new Range(0, 0));
    }

    public UnderlayList(String string, BufferedReader bufferedReader, Range range) {
        this.filename = string;
        this.colors = new Hashtable();
        this.regions = new Vector();
        try {
            if (bufferedReader != null) {
                this.fromReader(bufferedReader, range);
            } else if (string != null && !string.equals("")) {
                BufferedReader bufferedReader2 = IO.getReader(string);
                this.fromReader(bufferedReader2, range);
                bufferedReader2.close();
            }
        }
        catch (IOException iOException) {
            Log.showError("Error loading underlays from" + (bufferedReader != null ? " bundled" : "") + " file \"" + string + "\":" + "\n" + iOException);
        }
        this.regions.trimToSize();
    }

    private void fromGeneric(GenericAnnotList genericAnnotList, int n, Range range) throws BadInputException {
        if (n == 1) {
            FeatureList featureList = new FeatureList(genericAnnotList, n, range);
            this.colors = DefaultExonColors.getColors();
            Enumeration enumeration = featureList.regions.elements();
            while (enumeration.hasMoreElements()) {
                Feature feature = (Feature)enumeration.nextElement();
                Underlay underlay = new Underlay(feature);
                underlay.kind = DefaultExonColors.getKind(feature);
                this.regions.addElement(underlay);
            }
        } else if (n == 2) {
            FeatureList featureList = new FeatureList(genericAnnotList, n, range);
            Enumeration enumeration = featureList.regions.elements();
            while (enumeration.hasMoreElements()) {
                Feature feature = (Feature)enumeration.nextElement();
                Underlay underlay = new Underlay(feature);
                underlay.color = Config.defaultAnnotColor;
                this.regions.addElement(underlay);
            }
        } else {
            Enumeration enumeration = genericAnnotList.regions.elements();
            while (enumeration.hasMoreElements()) {
                int n2;
                GenericAnnot genericAnnot = (GenericAnnot)enumeration.nextElement();
                if (genericAnnot.kind == null) {
                    genericAnnot.kind = "";
                }
                if (genericAnnot.name == null) {
                    genericAnnot.name = "";
                }
                if (genericAnnot.gene == null) {
                    genericAnnot.gene = "";
                }
                if (genericAnnot.group == null || genericAnnot.group.equals("")) {
                    genericAnnot.group = genericAnnot.gene;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (!genericAnnot.kind.equals("") && !genericAnnot.name.startsWith(genericAnnot.kind)) {
                    stringBuffer.append(genericAnnot.kind + ":");
                }
                if (!genericAnnot.group.equals("") && !genericAnnot.name.startsWith(genericAnnot.group)) {
                    stringBuffer.append(genericAnnot.group + ":");
                }
                if (!genericAnnot.name.equals("")) {
                    stringBuffer.append(genericAnnot.name + ":");
                }
                if ((n2 = stringBuffer.length()) > 0) {
                    stringBuffer.deleteCharAt(n2 - 1);
                }
                if (genericAnnot.color == null) {
                    genericAnnot.color = Config.defaultAnnotColor;
                }
                int n3 = genericAnnot.score == Float.NaN ? Integer.MAX_VALUE : Math.round(genericAnnot.score);
                Underlay underlay = new Underlay(genericAnnot.kind, genericAnnot.start, genericAnnot.end, stringBuffer.toString(), n3, genericAnnot.color, 0, -1, -1, -1);
                if (range.start != 0 && !Util.overlaps(underlay.start, underlay.end, range.start, range.end)) continue;
                this.regions.addElement(underlay);
            }
        }
        Collections.sort(this.regions, new Comparator(){

            public int compare(Object object, Object object2) {
                Underlay underlay = (Underlay)object;
                Underlay underlay2 = (Underlay)object2;
                int n = underlay.end - underlay.start;
                int n2 = underlay2.end - underlay2.start;
                return n > n2 ? -1 : (n < n2 ? 1 : (underlay.start < underlay2.start ? -1 : (underlay.start > underlay2.start ? 1 : 0)));
            }
        });
    }

    private void fromReader(BufferedReader bufferedReader, Range range) throws IOException {
        String string;
        Vector<Object> vector = new Vector<Object>();
        while ((string = IO.getNonemptyLine(bufferedReader)) != null) {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() == 2) {
                object = stringTokenizer.nextToken();
                if (ColorTable.getColor((String)object) == null) {
                    throw new BadInputException("Invalid color \"" + (String)object + "\".");
                }
                this.colors.put(stringTokenizer.nextToken(), object);
                continue;
            }
            object = this.readUnderlay(stringTokenizer, string);
            if (range.start != 0 && !Util.overlaps(((Underlay)object).start, ((Underlay)object).end, range.start, range.end)) continue;
            if (this.getColor(((Underlay)object).kind).equals("Hatch")) {
                vector.addElement(object);
                continue;
            }
            this.regions.addElement(object);
        }
        this.regions.addAll(vector);
    }

    private Underlay readUnderlay(StringTokenizer stringTokenizer, String string) throws BadInputException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        try {
            string7 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
            String string8 = stringTokenizer.nextToken();
            if (string8.startsWith("(")) {
                string5 = string8;
                if (!string5.endsWith(")")) {
                    string5 = string5 + stringTokenizer.nextToken(")") + stringTokenizer.nextToken(" \t\n\r\f");
                }
                string4 = stringTokenizer.nextToken();
            } else {
                string5 = "";
                string4 = string8;
            }
            string3 = "";
            string2 = "";
            switch (stringTokenizer.countTokens()) {
                case 0: {
                    break;
                }
                case 1: {
                    string8 = stringTokenizer.nextToken();
                    if (Util.indexOfAny(string8, "0123456789", 0) >= 0) {
                        string3 = string8;
                        break;
                    }
                    string2 = string8;
                    break;
                }
                default: {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    break;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BadInputException("Not enough tokens:\n" + string);
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new BadInputException("Too many tokens:\n" + string);
        }
        if (!this.colors.containsKey(string4) && ColorTable.getColor(string4) == null) {
            throw new BadInputException("Underlay type \"" + string4 + "\" has not been defined yet.");
        }
        return new Underlay(string4, string7, string6, string5, string3, string2);
    }

    public String getColor(String string) {
        String string2 = (String)this.colors.get(string);
        if (string2 == null && ColorTable.getColor(string2 = string) == null) {
            string2 = null;
        }
        return string2;
    }

    public Vector findUnderlays(int n, int n2) {
        Vector<Underlay> vector = new Vector<Underlay>();
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Underlay underlay = (Underlay)enumeration.nextElement();
            if (underlay.start > n || n > underlay.end || n2 != 0 && underlay.half != 0 && underlay.half != n2) continue;
            vector.addElement(underlay);
        }
        return vector;
    }

    public Copyable copy() {
        Vector<Copyable> vector = new Vector<Copyable>(this.regions.size());
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Underlay underlay = (Underlay)enumeration.nextElement();
            vector.addElement(underlay.copy());
        }
        return new UnderlayList(this.filename, (Hashtable)this.colors.clone(), vector);
    }
}

