/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;

public class Underlay
implements Copyable {
    static final String rcsid = "$Revision: 1.10 $$Date: 2007/11/15 18:42:54 $";
    static final int BOTH = 0;
    static final int TOP = 1;
    static final int BOTTOM = -1;
    static final int NONE = -1;
    public String kind;
    public int start;
    public int end;
    public String label;
    public int score;
    public Color color;
    public int half;
    public int row;
    public int startcol;
    public int endcol;

    public Underlay(String string, int n, int n2, String string2, int n3, Color color, int n4, int n5, int n6, int n7) {
        this.kind = string;
        this.start = n;
        this.end = n2;
        this.label = string2;
        this.score = n3;
        this.color = color;
        this.half = n4;
        this.row = n5;
        this.startcol = n6;
        this.endcol = n7;
    }

    public Underlay(String string, String string2, String string3, String string4, String string5, String string6) throws BadInputException {
        this.kind = string;
        try {
            this.start = Integer.parseInt(string2);
            this.end = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Invalid endpoint: not an integer.");
        }
        if (this.end < this.start) {
            throw new BadInputException("Invalid endpoints: end < start.");
        }
        if ((string4 = string4.trim()).startsWith("(") && string4.endsWith(")")) {
            string4 = Util.drop(string4, 1);
            string4 = Util.take(string4, string4.length() - 1);
        }
        this.label = string4;
        try {
            this.score = string5.equals("") ? Integer.MAX_VALUE : Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Invalid underlay score: not an integer.");
        }
        this.color = null;
        this.half = 0;
        this.row = -1;
        if (!string6.equals("")) {
            if (string6.equals("+")) {
                this.half = 1;
            } else if (string6.equals("-")) {
                this.half = -1;
            } else {
                throw new BadInputException("\"" + string6 + "\" is not a valid half for underlays." + "\n" + "(Note that row specification for text highlights" + "\n" + "is not supported in " + Log.programName + ".)");
            }
        }
        this.startcol = -1;
        this.endcol = -1;
    }

    public Underlay(Underlay underlay) {
        this.kind = underlay.kind;
        this.start = underlay.start;
        this.end = underlay.end;
        this.label = underlay.label;
        this.score = underlay.score;
        this.color = underlay.color;
        this.half = underlay.half;
        this.row = underlay.row;
        this.startcol = underlay.startcol;
        this.endcol = underlay.endcol;
    }

    public Underlay(Feature feature) {
        this.kind = feature.kind;
        this.start = feature.start;
        this.end = feature.end;
        this.label = feature.label;
        this.score = Integer.MAX_VALUE;
        this.color = null;
        this.half = 0;
        this.row = -1;
        this.startcol = -1;
        this.endcol = -1;
    }

    public Copyable copy() {
        return new Underlay(this.kind, this.start, this.end, this.label, this.score, this.color, this.half, this.row, this.startcol, this.endcol);
    }
}

