/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.PlotSeg;
import java.awt.Point;
import java.awt.Rectangle;

final class Transformer {
    static final String rcsid = "$Revision: 1.7 $$Date: 2007/07/13 16:30:47 $";
    Rectangle w;
    Rectangle s;
    private double scaleX;
    private double scaleY;
    boolean steep;

    public Transformer(Rectangle rectangle, Rectangle rectangle2) {
        this.w = new Rectangle(rectangle);
        this.s = new Rectangle(rectangle2);
        this.scaleX = (double)this.s.width / (double)this.w.width;
        this.scaleY = (double)this.s.height / (double)this.w.height;
        this.steep = Math.abs(this.scaleY / this.scaleX) > 1.0;
    }

    public String toString() {
        return "world: " + this.w + ";" + "\n" + "screen: " + this.s;
    }

    public int transformX(int n) {
        return (int)Math.round((double)(n - this.w.x) * this.scaleX + (double)this.s.x);
    }

    public int transformY(int n) {
        return (int)Math.round((double)(n - this.w.y) * this.scaleY + (double)this.s.y);
    }

    public Point transform(Point point) {
        return new Point(this.transformX(point.x), this.transformY(point.y));
    }

    public PlotSeg transform(PlotSeg plotSeg) {
        return new PlotSeg(this.transformX(plotSeg.x0), this.transformX(plotSeg.x1), this.transformY(plotSeg.y0), this.transformY(plotSeg.y1), plotSeg.pm, false);
    }

    public int inverseX(int n) {
        return (int)Math.round((double)(n - this.s.x) / this.scaleX + (double)this.w.x);
    }

    public int inverseY(int n) {
        return (int)Math.round((double)(n - this.s.y) / this.scaleY + (double)this.w.y);
    }

    public Point inverse(Point point) {
        return new Point(this.inverseX(point.x), this.inverseY(point.y));
    }
}

