/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class TextPaneCaret
extends DefaultCaret {
    static final String rcsid = "$Revision: 1.13 $$Date: 2008/01/28 20:21:55 $";
    JTextArea txt;
    private Vector stags;
    private Vector mtags;

    public TextPaneCaret(JTextArea jTextArea) {
        this.txt = jTextArea;
        this.stags = this.initSelectionHighlight();
        this.mtags = new Vector();
        this.setBlinkRate(0);
    }

    void setHighlight(int n) {
        int n2 = this.txt.getLineCount();
        if (n2 <= 0) {
            return;
        }
        int n3 = this.txt.getText().length() / n2 + 1;
        Highlighter highlighter = this.txt.getHighlighter();
        if (highlighter == null) {
            return;
        }
        try {
            Object object;
            if (this.mtags.size() == 0) {
                object = this.getHighlightPainter(Config.markColor);
                this.mtags.addElement(highlighter.addHighlight(0, 1, (Highlighter.HighlightPainter)object));
                object = this.getHighlightPainter(Config.caretColor);
                int n4 = 0;
                while (n4 < this.txt.getRows()) {
                    int n5 = n4 * n3 + 0;
                    this.mtags.addElement(highlighter.addHighlight(n5, n5 + 1, (Highlighter.HighlightPainter)object));
                    ++n4;
                }
            }
            object = this.mtags.elements();
            highlighter.changeHighlight(object.nextElement(), n, n + 1);
            n %= n3;
            while (object.hasMoreElements()) {
                highlighter.changeHighlight(object.nextElement(), n, n + 1);
                n += n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.warn("Bad cursor position.");
        }
    }

    private Highlighter.HighlightPainter getHighlightPainter(Color color) {
        return new DefaultHighlighter.DefaultHighlightPainter(color);
    }

    public void setSelectionVisible(boolean bl) {
        super.setSelectionVisible(false);
    }

    private Vector initSelectionHighlight() {
        Vector<Object> vector = new Vector<Object>();
        Highlighter highlighter = this.txt.getHighlighter();
        Highlighter.HighlightPainter highlightPainter = this.getHighlightPainter(this.txt.getSelectionColor());
        try {
            int n = 0;
            while (n < this.txt.getRows()) {
                vector.addElement(highlighter.addHighlight(0, 0, highlightPainter));
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.fatalBug("TextPaneCaret.initSelectionHighlight(): BadLocationException.");
        }
        return vector;
    }

    private void showSelectionHighlight() {
        Highlighter highlighter = this.txt.getHighlighter();
        int n = this.txt.getLineCount();
        if (n <= 0) {
            this.hideSelectionHighlight();
            return;
        }
        int n2 = this.txt.getText().length() / n + 1;
        int n3 = this.getMark();
        int n4 = this.getDot();
        int n5 = n3 / n2 * n2 + n4 % n2;
        if (n4 <= n3 || n5 <= n3) {
            this.hideSelectionHighlight();
            return;
        }
        try {
            Enumeration enumeration = this.stags.elements();
            while (enumeration.hasMoreElements()) {
                if (n5 <= n4) {
                    highlighter.changeHighlight(enumeration.nextElement(), n3, n5);
                    n3 += n2;
                    n5 += n2;
                    continue;
                }
                highlighter.changeHighlight(enumeration.nextElement(), 0, 0);
            }
            if (n5 <= n4) {
                Log.fatalBug("TextPaneCaret.showSelectionHighlight(): Not enough tags.");
            }
        }
        catch (BadLocationException badLocationException) {
            Log.fatalBug("TextPaneCaret.showSelectionHighlight(): BadLocationException.");
        }
        this.txt.repaint();
    }

    private void hideSelectionHighlight() {
        Highlighter highlighter = this.txt.getHighlighter();
        try {
            Enumeration enumeration = this.stags.elements();
            while (enumeration.hasMoreElements()) {
                highlighter.changeHighlight(enumeration.nextElement(), 0, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.fatalBug("TextPaneCaret.hideSelectionHighlight(): BadLocationException.");
        }
        this.txt.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.txt.hasFocus()) {
            this.showSelectionHighlight();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.showSelectionHighlight();
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.hideSelectionHighlight();
    }
}

