/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BlockText;
import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.TextHeaderCaret;
import edu.psu.bx.gmaj.TextPaneCaret;
import edu.psu.bx.gmaj.Underlay;
import edu.psu.bx.gmaj.UnderlayList;
import edu.psu.bx.gmaj.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class TextPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    static final String rcsid = "$Revision: 1.31 $$Date: 2008/06/30 18:22:44 $";
    static final Insets bar = new Insets(0, 1, 0, 1);
    static final Insets gap = new Insets(0, 4, 0, 4);
    static final Border barBorder = Util.paddedBorder(gap, bar, gap, Config.thumbColor);
    static final Border nobarBorder = Util.paddedBorder(gap, bar, gap, Config.textBackgroundColor);
    static final int BOTH = 0;
    static final int HORIZ = 1;
    static final int VERT = 2;
    Maj maj;
    MajState state;
    BlockText textdata;
    private MultiLineLabel txt;
    private MultiLineLabel hdr;
    private int maxrows;
    private int nrows;
    private int ncols;
    private UnderlayList[] hilights;
    private Vector hilightTags;
    private final int charFudge;
    private boolean mouseEnabled;
    private JScrollPane sp;

    public TextPane(Maj maj, MajState majState) {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(Config.outputFont);
        this.maj = maj;
        this.state = majState;
        this.textdata = null;
        this.maxrows = majState.dotplot ? 2 : maj.global.countShownSeq();
        this.txt = new MultiLineLabel(this.maxrows, 80, Config.textBackgroundColor, Config.outputFont, false, true);
        this.txt.setCaret(new TextPaneCaret(this.txt));
        String string = " [No block selected -- please click on a plot.]";
        this.txt.setText((this.maxrows > 2 ? Util.blank(string.length()) + "\n" : "") + string);
        this.hdr = new MultiLineLabel(this.maxrows, maj.global.headerCols, Config.textBackgroundColor, Config.headerFont, true, false);
        this.hdr.setCaret(new TextHeaderCaret(this));
        this.nrows = 0;
        this.ncols = 0;
        this.hilights = null;
        this.hilightTags = new Vector();
        this.charFudge = fontMetrics.charWidth('G') / 2;
        this.mouseEnabled = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.hdr);
        jPanel.setBorder(Util.marginBorder(Config.headerPanelMargin));
        jPanel.setBackground(Config.textBackgroundColor);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.txt);
        jPanel2.setBorder(Util.marginBorder(Config.textPanelMargin));
        jPanel2.setBackground(Config.textBackgroundColor);
        this.sp = new JScrollPane(jPanel2);
        this.sp.setRowHeaderView(jPanel);
        this.sp.setHorizontalScrollBarPolicy(32);
        this.sp.setBackground(Config.textBackgroundColor);
        if (majState.dotplot) {
            this.sp.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.sp.setViewportBorder(nobarBorder);
        this.txt.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TextPane.this.sp.setViewportBorder(barBorder);
                TextPane.this.sp.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                TextPane.this.sp.setViewportBorder(nobarBorder);
                TextPane.this.sp.repaint();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
    }

    public void setText(BlockText blockText) {
        this.txt.setText("");
        this.hdr.setText("");
        this.nrows = 0;
        this.ncols = 0;
        this.enableMouseEvents(false);
        this.textdata = blockText;
        if (blockText == null) {
            return;
        }
        String[] stringArray = blockText.getVisibleRows();
        String[] stringArray2 = blockText.getVisibleHeaders();
        this.nrows = stringArray.length;
        if (this.nrows == 0) {
            return;
        }
        this.ncols = stringArray[0].length() + 1;
        if (this.ncols == 1) {
            return;
        }
        this.txt.setText(stringArray[0]);
        this.hdr.setText(stringArray2[0]);
        int n = 1;
        while (n < this.nrows) {
            this.txt.append("\n" + stringArray[n]);
            this.hdr.append("\n" + stringArray2[n]);
            ++n;
        }
        this.enableMouseEvents(true);
    }

    public void setHighlights(UnderlayList[] underlayListArray) {
        this.hilights = underlayListArray;
        this.showHighlights();
    }

    public void showHighlights() {
        Highlighter highlighter = this.txt.getHighlighter();
        if (highlighter == null || this.hilights == null) {
            return;
        }
        Enumeration enumeration = this.hilightTags.elements();
        while (enumeration.hasMoreElements()) {
            highlighter.removeHighlight(enumeration.nextElement());
        }
        this.hilightTags.removeAllElements();
        int n = 0;
        while (n < this.maj.nseq) {
            if (this.hilights[n] != null) {
                Vector vector = this.hilights[n].regions;
                ListIterator listIterator = ((AbstractList)vector).listIterator(vector.size());
                while (listIterator.hasPrevious()) {
                    Underlay underlay = (Underlay)listIterator.previous();
                    if (!this.maj.global.isVisible(underlay)) continue;
                    Highlighter.HighlightPainter highlightPainter = this.getHighlightPainter(this.hilights[n], underlay);
                    try {
                        int n2 = underlay.endcol - underlay.startcol;
                        int n3 = this.textdata.getDisplayIndex(underlay.row);
                        if (n3 < 0) continue;
                        int n4 = n3 * this.ncols + underlay.startcol;
                        this.hilightTags.addElement(highlighter.addHighlight(n4, n4 + n2 + 1, highlightPainter));
                    }
                    catch (BadLocationException badLocationException) {
                        Log.warn("Bad highlight position.");
                    }
                }
            }
            ++n;
        }
    }

    private Highlighter.HighlightPainter getHighlightPainter(UnderlayList underlayList, Underlay underlay) {
        Color color;
        String string = underlayList.getColor(underlay.kind);
        if (string != null && string.equals("Hatch")) {
            Log.showWarning("color_" + string, "Warning:\n\"" + string + "\" is not a valid color for text highlights.");
        }
        Color color2 = string != null ? ColorTable.getColor(string) : (color = underlay.color != null ? underlay.color : Config.defaultAnnotColor);
        if (color == null) {
            Log.fatalBug("TextPane.getHighlightPainter(): Invalid color \"" + string + "\".");
        }
        return new DefaultHighlighter.DefaultHighlightPainter(color);
    }

    public void setTextMark(MarkInfo markInfo) {
        this.setTextMark(markInfo, null);
    }

    private void setTextMark(MarkInfo markInfo, final Point point) {
        int n = this.textdata.getDisplayIndex(markInfo.row);
        int n2 = (n >= 0 ? n : this.maxrows) * this.ncols + markInfo.col;
        ((TextPaneCaret)this.txt.getCaret()).setHighlight(n2);
        final int n3 = n >= 0 ? n2 : markInfo.col;
        final int n4 = n >= 0 ? 0 : 1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (point != null) {
                    TextPane.this.doScroll(point);
                } else {
                    TextPane.this.scrollText(n3, n4);
                }
            }
        });
    }

    private void scrollText(int n, int n2) {
        try {
            Rectangle rectangle = this.txt.modelToView(n);
            if (rectangle != null) {
                rectangle.setSize(this.charFudge * 2, rectangle.height);
                this.scrollText(rectangle, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.warn("Can't scroll textview to position.");
        }
    }

    void scrollText(Rectangle rectangle, int n) {
        if (this.nrows == 0 || rectangle == null) {
            return;
        }
        JViewport jViewport = this.sp.getViewport();
        Rectangle rectangle2 = jViewport.getViewRect();
        int n2 = n != 2 && (rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) ? Math.max(rectangle.x - rectangle2.width / 2, 0) : rectangle2.x;
        int n3 = n != 1 && (rectangle.y < rectangle2.y || rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) ? Math.max(rectangle.y - rectangle2.height / 2, 0) : rectangle2.y;
        this.doScroll(new Point(n2, n3));
    }

    private void doScroll(Point point) {
        JViewport jViewport = this.sp.getViewport();
        int n = 0;
        while (n < 10) {
            jViewport.setViewPosition(point);
            if (jViewport.getViewPosition().equals(point)) break;
            ++n;
        }
    }

    public void syncToState() {
        if (this.textdata == null || this.state.getMark() == null) {
            return;
        }
        if (this.textdata.setVisible(this.maj, this.state)) {
            Point point = this.sp.getViewport().getViewPosition();
            this.setText(this.textdata);
            this.setTextMark(this.state.getMark(), point);
        }
        this.showHighlights();
    }

    private void enableMouseEvents(boolean bl) {
        if (bl && !this.mouseEnabled) {
            this.txt.addMouseListener(this);
            this.txt.addMouseMotionListener(this);
            this.mouseEnabled = true;
        } else if (!bl && this.mouseEnabled) {
            this.txt.removeMouseListener(this);
            this.txt.removeMouseMotionListener(this);
            this.mouseEnabled = false;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            this.maj.global.lastMove = null;
            this.state.clearLoc();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.mouseToRow(mouseEvent);
        int n2 = this.mouseToColumn(mouseEvent);
        this.state.setMark(n, n2);
        this.state.gui.restoreFocus();
        this.state.gui.content.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isControlDown()) {
            this.maj.global.lastMove = mouseEvent;
            int n = this.mouseToRow(mouseEvent);
            int n2 = this.mouseToColumn(mouseEvent);
            this.state.showTextLoc(n, n2, this.findHighlights(n, n2));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    private int mouseToRow(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.charFudge;
        int n2 = mouseEvent.getY();
        int n3 = this.txt.viewToModel(new Point(n, n2));
        return this.textdata.getFullIndex(n3 / this.ncols);
    }

    private int mouseToColumn(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.charFudge;
        int n2 = mouseEvent.getY();
        int n3 = this.txt.viewToModel(new Point(n, n2));
        int n4 = n3 % this.ncols;
        String string = this.txt.getText();
        int n5 = string.indexOf("\n");
        if (n5 < 0) {
            n5 = string.length();
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= n5) {
            n4 = n5 - 1;
        }
        return n4;
    }

    private Vector findHighlights(int n, int n2) {
        Vector<Underlay> vector = new Vector<Underlay>();
        int n3 = 0;
        while (n3 < this.maj.nseq) {
            if (this.hilights[n3] != null) {
                Enumeration enumeration = this.hilights[n3].regions.elements();
                while (enumeration.hasMoreElements()) {
                    Underlay underlay = (Underlay)enumeration.nextElement();
                    if (underlay.row != n) break;
                    if (underlay.startcol > n2 || n2 > underlay.endcol) continue;
                    vector.addElement(underlay);
                }
            }
            ++n3;
        }
        return vector;
    }
}

