/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;

public class SingleLineLabel
extends JTextField {
    static final String rcsid = "$Revision: 1.1 $$Date: 2007/10/24 18:31:40 $";
    static final Insets gap1 = new Insets(1, 2, 1, 2);
    static final Insets line = new Insets(1, 1, 1, 1);
    static final Insets gap2 = new Insets(0, 2, 0, 2);
    static final Border focusBorder = Util.paddedBorder(gap1, line, gap2, Config.thumbColor);
    static final Color defaultBackground = new JPanel().getBackground();
    boolean mouseHere = false;

    public SingleLineLabel(String string, FontUIResource fontUIResource, Container container) {
        super(string);
        Color color = container == null ? defaultBackground : container.getBackground();
        this.configure(color, fontUIResource);
        this.setAlignmentY(0.5f);
        this.adjustSize();
    }

    private void configure(Color color, FontUIResource fontUIResource) {
        this.setBackground(color);
        this.setForeground(Config.foregroundColor);
        this.setFont(fontUIResource);
        this.setEditable(false);
        final Border border = Util.paddedBorder(gap1, line, gap2, color);
        this.setBorder(border);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SingleLineLabel.this.setBorder(focusBorder);
                SingleLineLabel.this.getCaret().setSelectionVisible(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                SingleLineLabel.this.setBorder(border);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).getCaret().setSelectionVisible(false);
                    }
                });
            }

            static /* synthetic */ SingleLineLabel access$000(1 var0) {
                return var0.SingleLineLabel.this;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                SingleLineLabel.this.mouseHere = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$100(this.this$1).mouseHere = false;
                    }
                });
            }

            static /* synthetic */ SingleLineLabel access$100(4 var0) {
                return var0.SingleLineLabel.this;
            }
        });
    }

    private void adjustSize() {
        Insets insets = this.getInsets();
        int n = ((Component)this).getFontMetrics(this.getFont()).getHeight() + insets.top + insets.bottom;
        this.setMinimumSize(new Dimension(0, n));
        this.setMaximumSize(new Dimension(9999, n));
    }

    public Dimension getPreferredSize() {
        int n = super.getPreferredSize().width + 1;
        return new Dimension(n, this.getMaximumSize().height);
    }

    public boolean isFocusTraversable() {
        return this.mouseHere || this.hasFocus();
    }
}

