/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Log;
import java.util.NoSuchElementException;

public class SimpleTokenizer {
    static final String rcsid = "$Revision: 1.1 $$Date: 2007/07/04 14:48:18 $";
    String line;
    char delim;
    boolean skipEmpty;
    boolean useQuotes;
    String filename;
    private int start;

    public SimpleTokenizer(String string, char c, boolean bl, boolean bl2, String string2) {
        if (c == '\"' && bl2) {
            Log.fatalBug("SimpleTokenizer.SimpleTokenizer(): Delimiter can't be '\"' with useQuotes.");
        }
        this.line = string;
        this.delim = c;
        this.skipEmpty = bl;
        this.useQuotes = bl2;
        this.filename = string2;
        this.start = 0;
    }

    public String nextToken() throws NoSuchElementException, BadInputException {
        String string = this.getToken();
        if (string == null) {
            throw new NoSuchElementException();
        }
        return string;
    }

    public String getToken() throws BadInputException {
        if (this.line == null || this.line.equals("") || this.start > this.line.length()) {
            return null;
        }
        boolean bl = false;
        int n = this.start;
        while (n < this.line.length()) {
            char c = this.line.charAt(n);
            if (this.useQuotes && c == '\"' && (n == 0 || this.line.charAt(n - 1) != '\\')) {
                bl = !bl;
            } else if (c == this.delim && !bl) break;
            ++n;
        }
        String string = this.line.substring(this.start, n);
        this.start = n + 1;
        if (this.useQuotes && string.endsWith("\\\"")) {
            Log.showWarning("escaped_quote", "Warning:\nOne or more tokens ends with an escaped quote; was this intentional?  E.g.\n\n" + (this.filename != null ? "[" + this.filename + "]" + "\n" : "") + this.line + "\n" + "\n" + "If not, insert a space between the backslash and quote." + "\n" + "(Note that this problem may not be detected in all cases.)");
        }
        if (bl) {
            throw new BadInputException("Unmatched '\"':  " + string);
        }
        return this.skipEmpty && string.equals("") ? this.getToken() : string;
    }

    public String allRemaining() throws BadInputException {
        if (this.line == null || this.line.equals("") || this.start > this.line.length()) {
            return null;
        }
        int n = this.line.length();
        String string = this.line.substring(this.start, n);
        this.start = n + 1;
        return this.skipEmpty && string.equals("") ? this.getToken() : string;
    }

    public boolean hasMoreTokens() throws BadInputException {
        int n = this.start;
        String string = this.getToken();
        this.start = n;
        return string != null;
    }
}

