/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.ZoomPane;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;

class RulerPane
extends ZoomPane {
    static final String rcsid = "$Revision: 1.10 $$Date: 2007/03/30 20:14:46 $";
    static final int rulerTop = 100;
    static final int[] gaps = new int[27];

    RulerPane(Maj maj, MajState majState) {
        super(maj, majState, 0, 100);
    }

    void paintContents(Graphics graphics) {
        this.paintTicks(graphics);
    }

    private void paintTicks(Graphics graphics) {
        int n;
        Rectangle rectangle = this.state.zt.getZoom();
        if (rectangle == null) {
            return;
        }
        int n2 = rectangle.x;
        int n3 = rectangle.x + rectangle.width;
        int n4 = this.maj.specs.getOffset(this.state.refseq);
        int n5 = 0;
        int n6 = 0;
        while (n6 < gaps.length) {
            int n7;
            n5 = gaps[n6];
            n = Util.div(n2 + n4, n5) * n5 - n4;
            if (n == n2) {
                n -= n5;
            }
            if ((n7 = (n3 - n) / n5) < 4) {
                n5 = gaps[n6 - 1];
                break;
            }
            ++n6;
        }
        graphics.setColor(Config.rulerColor);
        graphics.setFont(Config.tickFont);
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(Config.tickFont);
        int n8 = fontMetrics.charWidth('0') / 2 - 1;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        n = Util.div(n2 + n4, n5) * n5 - n4;
        if (n == n2) {
            n -= n5;
        }
        int n9 = n + n5;
        while (n9 <= n3) {
            String string = numberFormat.format(n9 + n4);
            int n10 = this.w2s.transformX(n9);
            int n11 = this.w2s.transformY(0);
            int n12 = this.w2s.transformY(100) + fontMetrics.getAscent();
            graphics.drawString(string, n10 - n8, n12);
            graphics.drawLine(n10, n11, n10, n12 + 2);
            n9 += n5;
        }
    }

    void showMouseLoc(Point point) {
        this.state.showRulerLoc(point.x);
    }

    void doClick(Point point) {
    }

    static {
        int n = 1;
        int n2 = 0;
        while (n2 < 9) {
            RulerPane.gaps[3 * n2 + 0] = 1 * n;
            RulerPane.gaps[3 * n2 + 1] = 2 * n;
            RulerPane.gaps[3 * n2 + 2] = 5 * n;
            n *= 10;
            ++n2;
        }
    }
}

