/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Util;

public class Range {
    static final String rcsid = "$Revision: 1.12 $$Date: 2008/06/11 01:59:42 $";
    int start;
    int end;

    public Range(int n, int n2) {
        if (n <= n2) {
            this.start = n;
            this.end = n2;
        } else {
            this.start = n2;
            this.end = n;
        }
    }

    public Range(Range range) {
        this.start = range.start;
        this.end = range.end;
    }

    public Range grow(Range range) {
        if (range != null) {
            this.start = Math.min(this.start, range.start);
            this.end = Math.max(this.end, range.end);
        }
        return this;
    }

    public Range intersect(Range range) {
        return range == null || !this.overlaps(range) ? null : new Range(Math.max(this.start, range.start), Math.min(this.end, range.end));
    }

    public Range pad(double d) {
        int n = (int)((double)(this.end - this.start) * d);
        return new Range(this.start - n, this.end + n);
    }

    public boolean contains(int n) {
        return this.start <= n && n <= this.end;
    }

    public boolean overlaps(Range range) {
        return range == null ? false : Util.overlaps(this.start, this.end, range.start, range.end);
    }

    public int length() {
        return this.end - this.start + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return this.start == range.start && this.end == range.end;
    }

    public String toString() {
        return "[" + this.start + ".." + this.end + "]";
    }
}

