/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Util;
import java.awt.Point;

public class PlotSeg {
    static final String rcsid = "$Revision: 1.13 $$Date: 2008/06/11 01:59:42 $";
    int x0;
    int x1;
    int y0;
    int y1;
    int pm;

    public PlotSeg(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, true);
    }

    public PlotSeg(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.x0 = n;
        this.x1 = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.pm = n5;
        if (bl && n4 != n3 && Math.abs(n2 - n) != Math.abs(n4 - n3)) {
            Log.fatalBug("PlotSeg.PlotSeg(): Segment length mismatch.");
        }
        if (n5 < 0 || n5 > 100) {
            Log.fatalBug("PlotSeg.PlotSeg(): Bad percent identity.");
        }
    }

    public PlotSeg(Point point, Point point2, int n) {
        this(point.x, point2.x, point.y, point2.y, n);
    }

    public Point closest(Point point, boolean bl) throws BadInputException {
        int n;
        int n2;
        if (bl) {
            return new Point(Util.clamp(this.x0, point.x, this.x1), this.pm);
        }
        int n3 = this.getSlope();
        if (n3 == 1) {
            n2 = (int)Math.floor((double)(this.x0 - this.y0 + point.x + point.y) / 2.0);
            n = (int)Math.floor((double)(-this.x0 + this.y0 + point.x + point.y) / 2.0);
        } else {
            n2 = (int)Math.floor((double)(this.x0 + this.y0 + point.x - point.y) / 2.0);
            n = (int)Math.ceil((double)(this.x0 + this.y0 - point.x + point.y) / 2.0);
        }
        int n4 = Util.clamp(this.x0, n2, this.x1);
        if (n4 == this.x0) {
            return new Point(this.x0, this.y0);
        }
        if (n4 == this.x1) {
            return new Point(this.x1, this.y1);
        }
        return new Point(n2, n);
    }

    public Point intervalX(int n) throws BadInputException {
        int n2 = this.getSlope();
        if (Util.clamp(this.x0, n, this.x1) == n) {
            return new Point(n, this.y0 + n2 * (n - this.x0));
        }
        return null;
    }

    public Point intervalY(int n) throws BadInputException {
        int n2 = this.getSlope();
        if (Util.clamp(this.y0, n, this.y1) == n) {
            return new Point(this.x0 + n2 * (n - this.y0), n);
        }
        return null;
    }

    public Point intersectEdge(Point point, Point point2) throws BadInputException {
        Point point3 = null;
        if (point.y == point2.y) {
            point3 = this.intervalY(point.y);
            if (point3 != null && Util.clamp(point.x, point3.x, point2.x) != point3.x) {
                point3 = null;
            }
        } else if (point.x == point2.x) {
            point3 = this.intervalX(point.x);
            if (point3 != null && Util.clamp(point.y, point3.y, point2.y) != point3.y) {
                point3 = null;
            }
        } else {
            Log.fatalBug("PlotSeg.intersectEdge(): Bad slope for edge.");
        }
        return point3;
    }

    public int getSlope() throws BadInputException {
        int n = this.y1 - this.y0;
        int n2 = this.x1 - this.x0;
        if (n == n2) {
            return 1;
        }
        if (n == -n2) {
            return -1;
        }
        throw new BadInputException("Segment " + this.toString() + " has bad slope.");
    }

    public String toString() {
        return "[" + this.x0 + " " + this.x1 + " " + this.y0 + " " + this.y1 + " " + this.pm + "]";
    }
}

