/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.Plot;
import edu.psu.bx.gmaj.PlotBlock;
import edu.psu.bx.gmaj.PlotSeg;
import edu.psu.bx.gmaj.Underlay;
import edu.psu.bx.gmaj.UnderlayList;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.ZoomPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

class PlotPane
extends ZoomPane {
    static final String rcsid = "$Revision: 1.28 $$Date: 2008/04/10 04:09:41 $";
    static final int DOTPLOT = 0;
    static final int PIP = 1;
    static final int pipBottom = 50;
    static final int pipTop = 100;
    BlockFile bf;
    int seq2;
    Plot plot;
    UnderlayList stripes;
    UnderlayList stripes2;
    boolean pip;

    PlotPane(Maj maj, MajState majState, int n, int n2) {
        super(maj, majState, n2 == 1 ? 50 : 0, n2 == 1 ? 100 : -1);
        this.bf = maj.bf;
        this.seq2 = n;
        this.plot = maj.views[majState.refseq].plots[n];
        this.stripes = maj.views[majState.refseq].stripes[n];
        this.stripes2 = maj.views[majState.refseq].stripes2[n];
        boolean bl = this.pip = n2 == 1;
        if (this.plot.getExtent() == null) {
            this.setBackground(Config.emptyBackgroundColor);
        }
        if (!this.pip) {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (1.access$000(this.this$1).state.gui != null) {
                                1.access$000(this.this$1).state.gui.setLoc("dotplot size: " + 1.access$000(this.this$1).getWidth() + "x" + 1.access$000(this.this$1).getHeight() + " px");
                            }
                        }
                    });
                }

                static /* synthetic */ PlotPane access$000(1 var0) {
                    return var0.PlotPane.this;
                }
            });
        }
    }

    void paintContents(Graphics graphics) {
        this.paintUnderlays(graphics);
        this.paintBandDividers(graphics);
        this.paintAlignments(graphics);
        this.paintMark(graphics);
    }

    private void paintUnderlays(Graphics graphics) {
        Object object;
        Rectangle rectangle = this.state.zt.getZoom();
        if (!this.pip && !this.maj.global.getShown("dotunderlay")) {
            return;
        }
        Enumeration enumeration = this.stripes.regions.elements();
        while (enumeration.hasMoreElements()) {
            object = (Underlay)enumeration.nextElement();
            if (!Util.overlaps(((Underlay)object).start, ((Underlay)object).end, rectangle.x, rectangle.x + rectangle.width) || !this.maj.global.isVisible((Underlay)object)) continue;
            if (this.pip) {
                this.paintUnderlay(graphics, (Underlay)object, 50, 100, true);
                continue;
            }
            this.paintUnderlay(graphics, (Underlay)object, rectangle.y, rectangle.y + rectangle.height, true);
        }
        if (!this.pip) {
            object = this.stripes2.regions.elements();
            while (object.hasMoreElements()) {
                Underlay underlay = (Underlay)object.nextElement();
                if (!Util.overlaps(underlay.start, underlay.end, rectangle.y, rectangle.y + rectangle.height) || !this.maj.global.isVisible(underlay)) continue;
                this.paintUnderlay(graphics, underlay, rectangle.x, rectangle.x + rectangle.width, false);
            }
        }
    }

    private void paintUnderlay(Graphics graphics, Underlay underlay, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Rectangle rectangle = this.state.zt.getZoom();
        if (bl) {
            n7 = this.w2s.transformX(Util.clamp(rectangle.x, underlay.start, rectangle.x + rectangle.width));
            n6 = this.w2s.transformX(Util.clamp(rectangle.x, underlay.end, rectangle.x + rectangle.width));
            n5 = (n + n2) / 2;
            n4 = this.w2s.transformY(this.pip && underlay.half == 1 ? n5 : n);
            n3 = this.w2s.transformY(this.pip && underlay.half == -1 ? n5 : n2);
        } else {
            n7 = this.w2s.transformX(n);
            n6 = this.w2s.transformX(n2);
            n4 = this.w2s.transformY(Util.clamp(rectangle.y, underlay.start, rectangle.y + rectangle.height));
            n3 = this.w2s.transformY(Util.clamp(rectangle.y, underlay.end, rectangle.y + rectangle.height));
        }
        n5 = n6 - n7;
        int n8 = n4 - n3;
        Rectangle rectangle2 = new Rectangle(n7, n3, n5 + 1, n8 + 1);
        String string = (bl ? this.stripes : this.stripes2).getColor(underlay.kind);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (string != null && string.equals("Hatch")) {
            graphics2D.setPaint(ColorTable.hatching);
        } else {
            Color color;
            Color color2 = string != null ? ColorTable.getColor(string) : (color = underlay.color != null ? underlay.color : Config.defaultAnnotColor);
            if (color == null) {
                Log.fatalBug("PlotPane.paintUnderlay(): Invalid color \"" + string + "\".");
            }
            graphics2D.setColor(color);
        }
        graphics2D.fill(rectangle2);
    }

    private void paintBandDividers(Graphics graphics) {
        if (!this.pip && this.state.map != null && this.state.zt.getZoom() != null) {
            Rectangle rectangle = this.state.zt.getZoom();
            Rectangle rectangle2 = this.state.zt.bounds;
            int n = this.w2s.transformX(Math.max(rectangle.x, rectangle2.x));
            int n2 = this.w2s.transformX(Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width));
            int[] nArray = this.state.map.getDividerLocations();
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = this.w2s.transformY(nArray[n3]);
                graphics.setColor(Config.dividerColor);
                graphics.drawLine(n, n4, n2, n4);
                ++n3;
            }
        }
    }

    private void paintAlignments(Graphics graphics) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Object object2 = null;
        if (this.plot == null) {
            return;
        }
        Vector vector2 = this.plot.blocks;
        ListIterator listIterator = ((AbstractList)vector2).listIterator(vector2.size());
        while (listIterator.hasPrevious()) {
            object = (PlotBlock)listIterator.previous();
            if (!this.maj.global.isVisible((PlotBlock)object)) continue;
            if (this.state.isMarked(((PlotBlock)object).blockno)) {
                object2 = object;
                continue;
            }
            if (this.maj.global.isTagged(((PlotBlock)object).blockno)) {
                vector.addElement(object);
                continue;
            }
            graphics.setColor(Config.getFileColor(this.bf.block((int)((PlotBlock)object).blockno).mafno));
            this.paintBlock(graphics, (PlotBlock)object);
        }
        if (Config.markMode.equals("xor")) {
            graphics.setXORMode(Config.backgroundColor);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            PlotBlock plotBlock = (PlotBlock)object.nextElement();
            graphics.setColor(Config.tagColor);
            this.paintBlock(graphics, plotBlock);
        }
        if (object2 != null) {
            graphics.setColor(this.maj.global.isTagged(((PlotBlock)object2).blockno) ? Config.tagMarkColor : Config.markColor);
            this.paintBlock(graphics, (PlotBlock)object2);
        }
        graphics.setPaintMode();
    }

    private void paintBlock(Graphics graphics, PlotBlock plotBlock) {
        int n;
        int n2 = n = this.pip ? Config.plotThickness : (int)Math.floor((double)Config.plotThickness * 1.414);
        if (this.bf.block((int)plotBlock.blockno).mafno > 0) {
            n *= 2;
        }
        int n3 = Util.div(n - 1, 2);
        Rectangle rectangle = this.state.zt.getZoom();
        Enumeration enumeration = plotBlock.segments.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            int n5;
            int n6;
            PlotSeg plotSeg;
            PlotSeg plotSeg2;
            PlotSeg plotSeg3 = (PlotSeg)enumeration.nextElement();
            if (this.pip && plotSeg3.pm < 50 || (plotSeg2 = this.clipSeg(plotSeg3, rectangle)) == null) continue;
            PlotSeg plotSeg4 = this.pip ? this.w2s.transform(this.morph(plotSeg2)) : (plotSeg = this.w2s.transform(this.state.map == null ? plotSeg2 : this.state.map.translate(null, plotSeg2)));
            if (this.pip || !this.w2s.steep) {
                n6 = plotSeg.y0 - n3;
                n5 = plotSeg.y1 - n3;
                n4 = 0;
                while (n4 < n) {
                    graphics.drawLine(plotSeg.x0, n6++, plotSeg.x1, n5++);
                    ++n4;
                }
                continue;
            }
            n6 = plotSeg.x0 - n3;
            n5 = plotSeg.x1 - n3;
            n4 = 0;
            while (n4 < n) {
                graphics.drawLine(n6++, plotSeg.y0, n5++, plotSeg.y1);
                ++n4;
            }
        }
    }

    private void paintMark(Graphics graphics) {
        Point point = this.getMarkPoint(this.state.getMark());
        if (point != null) {
            int n = Config.markRadius;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Config.markColor);
            if (Config.markMode.equals("xor")) {
                graphics2D.setXORMode(Config.backgroundColor);
            }
            int n2 = 0;
            while (n2 < Config.markThickness) {
                graphics2D.drawOval(point.x - n - n2, point.y - n - n2, n + n + 2 * n2, n + n + 2 * n2);
                ++n2;
            }
            graphics2D.setPaintMode();
        }
    }

    public Point getMarkPoint(MarkInfo markInfo) {
        Rectangle rectangle = this.state.zt.getZoom();
        Point point = null;
        if (markInfo != null && markInfo.refseq == this.state.refseq && markInfo.seq2 == this.seq2 && Util.overlaps(markInfo.point.x, markInfo.point.x, rectangle.x, rectangle.x + rectangle.width)) {
            point = this.pip ? this.w2s.transform(this.morph(markInfo.point, markInfo.segment)) : this.w2s.transform(this.state.map == null ? markInfo.point : this.state.map.translate(null, markInfo.point));
        }
        return point;
    }

    private PlotSeg morph(PlotSeg plotSeg) {
        return plotSeg == null ? null : new PlotSeg(plotSeg.x0, plotSeg.x1, plotSeg.pm, plotSeg.pm, plotSeg.pm);
    }

    private Point morph(Point point, PlotSeg plotSeg) {
        return point == null || plotSeg == null ? null : new Point(point.x, plotSeg.pm);
    }

    private PlotSeg clipSeg(PlotSeg plotSeg, Rectangle rectangle) {
        try {
            if (this.pip) {
                Point point = new Point(plotSeg.x0, plotSeg.y0);
                Point point2 = new Point(plotSeg.x1, plotSeg.y1);
                if (!Util.overlaps(point.x, point2.x, rectangle.x, rectangle.x + rectangle.width)) {
                    return null;
                }
                Point point3 = plotSeg.intervalX(rectangle.x);
                Point point4 = plotSeg.intervalX(rectangle.x + rectangle.width);
                if (point3 == null && point4 == null) {
                    return plotSeg;
                }
                if (point3 != null) {
                    if (point.x < point2.x) {
                        point = point3;
                    } else {
                        point2 = point3;
                    }
                }
                if (point4 != null) {
                    if (point.x < point2.x) {
                        point2 = point4;
                    } else {
                        point = point4;
                    }
                }
                return new PlotSeg(point, point2, plotSeg.pm);
            }
            if (this.state.map != null) {
                Log.fatalBug("PlotPane.clipSeg(): Multi-contig dotplots are not yet supported.");
            }
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            Point point5 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            Point point6 = new Point(rectangle.x, rectangle.y);
            Point point7 = new Point(rectangle.x + rectangle.width, rectangle.y);
            Point point8 = plotSeg.intersectEdge(point, point5);
            Point point9 = plotSeg.intersectEdge(point, point6);
            Point point10 = plotSeg.intersectEdge(point6, point7);
            Point point11 = plotSeg.intersectEdge(point5, point7);
            if (point8 != null) {
                if (point9 != null) {
                    return this.clip2(plotSeg, point8, point9, rectangle);
                }
                if (point10 != null) {
                    return this.clip2(plotSeg, point8, point10, rectangle);
                }
                if (point11 != null) {
                    return this.clip2(plotSeg, point8, point11, rectangle);
                }
                return this.clip1(plotSeg, point8, rectangle);
            }
            if (point9 != null) {
                if (point10 != null) {
                    return this.clip2(plotSeg, point9, point10, rectangle);
                }
                if (point11 != null) {
                    return this.clip2(plotSeg, point9, point11, rectangle);
                }
                return this.clip1(plotSeg, point9, rectangle);
            }
            if (point10 != null) {
                if (point11 != null) {
                    return this.clip2(plotSeg, point10, point11, rectangle);
                }
                return this.clip1(plotSeg, point10, rectangle);
            }
            if (point11 != null) {
                return this.clip1(plotSeg, point11, rectangle);
            }
            return this.clip0(plotSeg, rectangle);
        }
        catch (BadInputException badInputException) {
            Log.showError("Error clipping plot segment:\n" + badInputException);
            return plotSeg;
        }
    }

    private PlotSeg clip2(PlotSeg plotSeg, Point point, Point point2, Rectangle rectangle) {
        if (point.equals(point2)) {
            return this.clip1(plotSeg, point, rectangle);
        }
        Point point3 = new Point(plotSeg.x0, plotSeg.y0);
        return point3.distanceSq(point) < point3.distanceSq(point2) ? new PlotSeg(point, point2, plotSeg.pm) : new PlotSeg(point2, point, plotSeg.pm);
    }

    private PlotSeg clip1(PlotSeg plotSeg, Point point, Rectangle rectangle) {
        Point point2 = new Point(plotSeg.x0, plotSeg.y0);
        Point point3 = new Point(plotSeg.x1, plotSeg.y1);
        boolean bl = Util.inside(point2, rectangle);
        boolean bl2 = Util.inside(point3, rectangle);
        if (bl && bl2) {
            return plotSeg;
        }
        if (bl) {
            return new PlotSeg(point2, point, plotSeg.pm);
        }
        if (bl2) {
            return new PlotSeg(point, point3, plotSeg.pm);
        }
        return new PlotSeg(point, point, plotSeg.pm);
    }

    private PlotSeg clip0(PlotSeg plotSeg, Rectangle rectangle) {
        Point point = new Point(plotSeg.x0, plotSeg.y0);
        return Util.inside(point, rectangle) ? plotSeg : null;
    }

    void showMouseLoc(Point point) {
        if (this.pip) {
            int n = point.y >= 75 ? 1 : -1;
            this.state.showPipLoc(point, this.seq2, this.stripes.findUnderlays(point.x, n));
        } else if (this.maj.global.getShown("dotunderlay")) {
            int n = 0;
            this.state.showDotLoc(point, this.seq2, this.stripes.findUnderlays(point.x, n), this.stripes2.findUnderlays(point.y, n));
        } else {
            this.state.showDotLoc(point, this.seq2);
        }
    }

    void doClick(Point point) {
        this.state.setMark(point, this.seq2, this.pip);
    }
}

