/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Block;
import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.PlotBlock;
import edu.psu.bx.gmaj.PlotSeg;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public class Plot {
    static final String rcsid = "$Revision: 1.17 $$Date: 2008/06/11 01:59:42 $";
    Vector blocks = new Vector();
    Hashtable index;
    private Rectangle extent;

    public Plot(BlockFile blockFile, int n, int n2) {
        this.index = new Hashtable(Util.div(blockFile.blocks.size(), 10), 10.0f);
        ListIterator listIterator = ((AbstractList)blockFile.blocks).listIterator();
        while (listIterator.hasNext()) {
            Block block = (Block)listIterator.next();
            BlockRow blockRow = block.row(n);
            BlockRow blockRow2 = block.row(n2);
            if (blockRow == null || blockRow2 == null) continue;
            int n3 = listIterator.previousIndex();
            Vector vector = this.segsFromText(blockRow, blockRow2);
            PlotBlock plotBlock = new PlotBlock(n3, vector, this.avgIdentity(vector));
            this.blocks.addElement(plotBlock);
            this.index.put(new Integer(n3), plotBlock);
        }
        this.blocks.trimToSize();
        this.extent = this.findExtent();
    }

    private Vector segsFromText(BlockRow blockRow, BlockRow blockRow2) {
        Vector<PlotSeg> vector = new Vector<PlotSeg>();
        String string = blockRow.text;
        String string2 = blockRow2.text;
        int n = blockRow.start;
        int n2 = blockRow2.start;
        int n3 = -1;
        int n4 = -1;
        int n5 = blockRow.reverseComp ? -1 : 1;
        int n6 = blockRow2.reverseComp ? -1 : 1;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        int n9 = 0;
        while (n9 < string.length()) {
            char c;
            char c2 = string.charAt(n9);
            char c3 = string2.charAt(n9);
            if (c2 != '-' && c3 != '-') {
                if (!bl) {
                    n3 = n;
                    n4 = n2;
                    n7 = 0;
                    n8 = 0;
                    bl = true;
                }
                c = Character.toUpperCase(c2);
                char c4 = Character.toUpperCase(c3);
                if (Util.isTrueNt(c) && Util.isTrueNt(c4)) {
                    if (c == c4) {
                        ++n7;
                    }
                    ++n8;
                } else {
                    this.checkValid(c, c2);
                    this.checkValid(c4, c3);
                }
            } else if (bl) {
                c = Math.round((float)n7 * 100.0f / (float)n8);
                vector.addElement(new PlotSeg(n3, n - n5, n4, n2 - n6, c));
                bl = false;
            }
            if (c2 != '-') {
                n += n5;
            }
            if (c3 != '-') {
                n2 += n6;
            }
            ++n9;
        }
        if (bl) {
            int n10 = Math.round((float)n7 * 100.0f / (float)n8);
            vector.addElement(new PlotSeg(n3, n - n5, n4, n2 - n6, n10));
        }
        if (n != blockRow.end + n5 || n2 != blockRow2.end + n6) {
            Log.fatalBug("Plot.segsFromText(): Wrong end position.");
        }
        vector.trimToSize();
        return vector;
    }

    private void checkValid(char c, char c2) {
        if (!Util.isValidNt(c)) {
            Log.showWarning("bad_char_" + c2, "Warning:\nUnrecognized character '" + c2 + "' found in alignment.");
        }
    }

    private int avgIdentity(Vector vector) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlotSeg plotSeg = (PlotSeg)enumeration.nextElement();
            int n3 = Math.abs(plotSeg.x1 - plotSeg.x0) + 1;
            n2 += plotSeg.pm * n3;
            n += n3;
        }
        return (int)Math.round((double)n2 / (double)n);
    }

    private Rectangle findExtent() {
        Range range = null;
        Range range2 = null;
        Enumeration enumeration = this.blocks.elements();
        while (enumeration.hasMoreElements()) {
            PlotBlock plotBlock = (PlotBlock)enumeration.nextElement();
            Enumeration enumeration2 = plotBlock.segments.elements();
            while (enumeration2.hasMoreElements()) {
                PlotSeg plotSeg = (PlotSeg)enumeration2.nextElement();
                Range range3 = new Range(plotSeg.x0, plotSeg.x1);
                Range range4 = new Range(plotSeg.y0, plotSeg.y1);
                range = range == null ? range3 : range.grow(range3);
                Range range5 = range2 = range2 == null ? range4 : range2.grow(range4);
            }
        }
        return Util.makeRectangle(range, range2);
    }

    public PlotBlock block(int n) {
        return this.block(new Integer(n));
    }

    public PlotBlock block(Integer n) {
        return (PlotBlock)this.index.get(n);
    }

    public Rectangle getExtent() {
        return this.extent == null ? null : (Rectangle)this.extent.clone();
    }
}

