/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Chooser;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class PanelChooser
extends Chooser {
    static final String rcsid = "$Revision: 1.17 $$Date: 2008/05/23 21:57:52 $";
    private static final Border border1 = BorderFactory.createEmptyBorder(5, 15, 0, 15);
    private static final int gap1 = 10;
    private static final int gap2 = 2;
    private static final Insets mini = new Insets(0, 0, 2, 0);
    Maj maj;
    boolean posline;
    boolean markline;
    boolean vis;
    boolean ruler;
    boolean recon;
    boolean links;
    boolean exons;
    boolean repeats;
    boolean text;
    BitSet pips;
    boolean dotunderlay;
    private JCheckBox posbox;
    private JCheckBox markbox;
    private JCheckBox visbox;
    private JCheckBox rulerbox;
    private JCheckBox reconbox;
    private JCheckBox linkbox;
    private JCheckBox exonbox;
    private JCheckBox repeatbox;
    private JCheckBox textbox;
    private JCheckBox[] pipboxes;
    private JCheckBox dotunderlaybox;

    public PanelChooser(JFrame jFrame, Maj maj) {
        super(jFrame, "Panel Selection");
        this.maj = maj;
        this.pips = new BitSet();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(border1);
        jPanel.add(new JLabel("Plots* vs:"));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.pipboxes = new JCheckBox[maj.nseq];
        int n = maj.bf.seqno(maj.specs.getRefSeq());
        int n2 = 0;
        while (n2 < maj.nseq) {
            this.pipboxes[n2] = new JCheckBox("", maj.global.getShown(n2));
            this.addBox(jPanel2, this.pipboxes[n2], n2 + ": " + maj.bf.mafseqname(n2), n2 != n, 0);
            ++n2;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        JButton jButton = new JButton("all");
        jButton.setMargin(mini);
        jButton.setMaximumSize(new Dimension(jButton.getMaximumSize().width, ((Component)jButton).getFontMetrics(jButton.getFont()).getHeight()));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < PanelChooser.this.maj.nseq) {
                    if (PanelChooser.this.pipboxes[n].isEnabled()) {
                        PanelChooser.this.pipboxes[n].setSelected(true);
                    }
                    ++n;
                }
            }
        });
        JButton jButton2 = new JButton("none");
        jButton2.setMargin(mini);
        jButton2.setMaximumSize(new Dimension(jButton2.getMaximumSize().width, ((Component)jButton2).getFontMetrics(jButton2.getFont()).getHeight()));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < PanelChooser.this.maj.nseq) {
                    if (PanelChooser.this.pipboxes[n].isEnabled()) {
                        PanelChooser.this.pipboxes[n].setSelected(false);
                    }
                    ++n;
                }
            }
        });
        jPanel.add(this.widgetPanel(null, jButton, jButton2));
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        JLabel jLabel = new JLabel("*Also affects text alignment rows");
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        Util.adjustChildren(jPanel, 0.0f, 0.5f, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(border1);
        jPanel3.add(new JLabel("Other Panels:"));
        jPanel3.add(Box.createRigidArea(new Dimension(0, 10)));
        this.posbox = new JCheckBox("", maj.global.getShown("posline"));
        this.addBox(jPanel3, this.posbox, "Position line", true, 10);
        this.markbox = new JCheckBox("", maj.global.getShown("markline"));
        this.addBox(jPanel3, this.markbox, "Mark line", true, 10);
        this.visbox = new JCheckBox("", maj.global.getShown("vis"));
        this.addBox(jPanel3, this.visbox, "Visibility controls", true, 10);
        this.rulerbox = new JCheckBox("", maj.global.getShown("ruler"));
        this.addBox(jPanel3, this.rulerbox, "Ruler", true, 10);
        this.reconbox = new JCheckBox("", maj.global.getShown("recon"));
        this.addBox(jPanel3, this.reconbox, "Reconstruction scores", maj.bf.anyRecon(), 10);
        this.linkbox = new JCheckBox("", maj.global.getShown("links"));
        this.addBox(jPanel3, this.linkbox, "Link bars", maj.specs.anyLinks(), 10);
        this.exonbox = new JCheckBox("", maj.global.getShown("exons"));
        this.addBox(jPanel3, this.exonbox, "Exons", maj.specs.anyExons(), 10);
        this.repeatbox = new JCheckBox("", maj.global.getShown("repeats"));
        this.addBox(jPanel3, this.repeatbox, "Repeats, etc.", maj.specs.anyRepeats(), 10);
        this.textbox = new JCheckBox("", maj.global.getShown("text"));
        this.addBox(jPanel3, this.textbox, "Text alignment", true, 10);
        Util.adjustChildren(jPanel3, 0.0f, 0.5f, 0, 0);
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width + 30, jPanel3.getPreferredSize().height));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        Util.adjustChildren(jPanel4, 0.0f, 0.0f, 0, 0);
        this.content.setLayout(new BoxLayout(this.content, 1));
        this.content.add(jPanel4);
        this.dotunderlaybox = new JCheckBox("", maj.global.getShown("dotunderlay"));
        this.addBox(this.content, this.dotunderlaybox, "Dotplot underlays", maj.specs.anyUnderlays(), 0);
        Util.adjustChildren(this.content, 0.0f, 0.0f, 0, 0);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addBox(JPanel jPanel, JCheckBox jCheckBox, String string, boolean bl, int n) {
        JLabel jLabel = new JLabel(string);
        jCheckBox.setEnabled(bl);
        jLabel.setEnabled(bl);
        JPanel jPanel2 = this.widgetPanel("", jCheckBox, jLabel);
        jPanel.add(jPanel2);
        if (n > 0) {
            jPanel.add(Box.createRigidArea(new Dimension(0, n)));
        }
    }

    protected boolean validateInput() {
        this.posline = this.posbox.isSelected();
        this.markline = this.markbox.isSelected();
        this.vis = this.visbox.isSelected();
        this.ruler = this.rulerbox.isSelected();
        this.recon = this.reconbox.isSelected();
        this.links = this.linkbox.isSelected();
        this.exons = this.exonbox.isSelected();
        this.repeats = this.repeatbox.isSelected();
        this.text = this.textbox.isSelected();
        int n = 0;
        while (n < this.maj.nseq) {
            if (this.pipboxes[n].isSelected()) {
                this.pips.set(n);
            } else {
                this.pips.clear(n);
            }
            ++n;
        }
        this.dotunderlay = this.dotunderlaybox.isSelected();
        return true;
    }
}

