/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.BadLocationException;

public class MultiLineLabel
extends JTextArea {
    static final String rcsid = "$Revision: 1.15 $$Date: 2008/02/28 21:36:58 $";
    static final Insets line = new Insets(1, 1, 1, 1);
    static final Insets igap = new Insets(2, 2, 2, 2);
    static final Color defaultBackground = new JPanel().getBackground();
    boolean rectangularCopy;
    boolean mouseHere = false;

    public MultiLineLabel(String string, Container container) {
        this(string, container, null);
    }

    public MultiLineLabel(String string, Container container, Insets insets) {
        this(string, container, insets, false);
    }

    public MultiLineLabel(String string, Container container, Insets insets, boolean bl) {
        super(string);
        Color color = container == null ? defaultBackground : container.getBackground();
        this.configure(color, Config.menuFont, insets, bl, true);
        this.setAlignmentY(this.alignY());
        this.adjustSize(-1);
        this.rectangularCopy = false;
    }

    public MultiLineLabel(int n, int n2, Color color, FontUIResource fontUIResource, boolean bl, boolean bl2) {
        super("", n, n2);
        this.configure(color, fontUIResource, null, false, bl);
        this.setAlignmentY(0.5f);
        this.rectangularCopy = bl2;
    }

    private void configure(Color color, FontUIResource fontUIResource, Insets insets, boolean bl, final boolean bl2) {
        this.setBackground(color);
        this.setForeground(Config.foregroundColor);
        this.setFont(fontUIResource);
        this.setLineWrap(bl);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        if (insets == null) {
            insets = igap;
        }
        final Border border = Util.paddedBorder(insets, line, igap, Config.thumbColor);
        final Border border2 = Util.paddedBorder(insets, line, igap, color);
        this.setBorder(border2);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (bl2) {
                    MultiLineLabel.this.setBorder(border);
                }
                MultiLineLabel.this.getCaret().setSelectionVisible(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                MultiLineLabel.this.setBorder(border2);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).getCaret().setSelectionVisible(false);
                    }
                });
            }

            static /* synthetic */ MultiLineLabel access$000(1 var0) {
                return var0.MultiLineLabel.this;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                MultiLineLabel.this.mouseHere = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        4.access$100(this.this$1).mouseHere = false;
                    }
                });
            }

            static /* synthetic */ MultiLineLabel access$100(4 var0) {
                return var0.MultiLineLabel.this;
            }
        });
    }

    private float alignY() {
        Insets insets = this.getInsets();
        int n = ((Component)this).getFontMetrics(this.getFont()).getHeight();
        int n2 = n / 2 + insets.top;
        int n3 = n * this.getLineCount() + insets.top + insets.bottom;
        return (float)n2 / (float)n3;
    }

    void adjustSize(int n) {
        Insets insets = this.getInsets();
        int n2 = n < 0 ? 9999 : n + insets.left + insets.right;
        int n3 = ((Component)this).getFontMetrics(this.getFont()).getHeight() * this.getLineCount() + insets.top + insets.bottom;
        this.setMinimumSize(new Dimension(0, n3));
        this.setMaximumSize(new Dimension(n2, n3));
    }

    public boolean isFocusTraversable() {
        return this.mouseHere || this.hasFocus();
    }

    public String getSelectedText() {
        if (this.rectangularCopy) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getLineCount();
            if (n <= 0) {
                return null;
            }
            int n2 = this.getText().length() / n + 1;
            int n3 = this.getSelectionStart();
            int n4 = this.getSelectionEnd();
            int n5 = n3 / n2 * n2 + n4 % n2;
            if (n4 <= n3 || n5 <= n3) {
                return null;
            }
            try {
                while (n5 <= n4) {
                    stringBuffer.append(this.getText(n3, n5 - n3) + "\n");
                    n3 += n2;
                    n5 += n2;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.fatalBug("MultiLineLabel.getSelectedText(): BadLocationException.");
            }
            Log.warn("getSelectedText() returns:\n" + stringBuffer.toString());
            return stringBuffer.toString();
        }
        return super.getSelectedText();
    }
}

