/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Bar;
import edu.psu.bx.gmaj.Block;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.BlockText;
import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.DefaultExonColors;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.Linkbar;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajGui;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.Plot;
import edu.psu.bx.gmaj.PlotBlock;
import edu.psu.bx.gmaj.PlotSeg;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Underlay;
import edu.psu.bx.gmaj.UnderlayList;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.View;
import edu.psu.bx.gmaj.VirtualSequenceMap;
import edu.psu.bx.gmaj.ZoomTracker;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class MajState {
    static final String rcsid = "$Revision: 1.55 $$Date: 2008/06/30 18:22:44 $";
    static final NumberFormat nf = NumberFormat.getNumberInstance();
    Maj maj;
    int refseq;
    View view;
    MajGui gui;
    int[] offsets;
    boolean dotplot;
    int seq2;
    VirtualSequenceMap map;
    ZoomTracker zt;
    BlockText textdata;
    UnderlayList[] hilights;
    private MarkInfo _mark;
    Dimension frameSize;
    Point frameLocation;

    public MajState(Maj maj, int n) {
        this(maj, n, false, -1);
    }

    public MajState(Maj maj, int n, boolean bl, int n2) {
        if (maj.bf == null || maj.views[n] == null) {
            Log.fatalBug("MajState.MajState(): Must initialize maj.bf and maj.views[refseq]\nbefore instantiating MajState.");
        }
        this.maj = maj;
        this.refseq = n;
        this.view = maj.views[n];
        this.gui = null;
        this.offsets = maj.specs.getOffsets(maj.nseq);
        this.dotplot = bl;
        this.seq2 = n2;
        this.map = null;
        this.zt = new ZoomTracker(maj, this);
        this.zt.unzoom();
        this.textdata = null;
        this.hilights = null;
        this._mark = null;
        this.frameSize = null;
        this.frameLocation = null;
    }

    public Rectangle convertZoom(int n, int n2) {
        Range range;
        Object object;
        Rectangle rectangle = this.zt.getZoom();
        Object object2 = null;
        Object object3 = null;
        int n3 = 0;
        while (n3 < this.maj.bf.blocks.size()) {
            if (this.overlaps(n3, rectangle)) {
                object = this.maj.bf.block(n3);
                range = ((Block)object).getExtent(n);
                Object object4 = object3 = object3 == null ? range : ((Range)object3).grow(range);
                if (n2 >= 0) {
                    range = ((Block)object).getExtent(n2);
                    object2 = object2 == null ? range : ((Range)object2).grow(range);
                }
            }
            ++n3;
        }
        if (object3 != null) {
            object3 = ((Range)object3).pad(0.05).intersect(this.maj.bf.getBounds(n));
        }
        if (object2 != null) {
            object2 = ((Range)object2).pad(0.05).intersect(this.maj.bf.getBounds(n2));
        }
        object = new Range(rectangle.x, rectangle.x + rectangle.width);
        range = new Range(rectangle.y, rectangle.y + rectangle.height);
        Object object5 = n == this.refseq ? object : (object3 = this.dotplot && n == this.seq2 ? range : object3);
        object2 = n2 < 0 ? new Range(0, 0) : (n2 == this.refseq ? object : (this.dotplot && n2 == this.seq2 ? range : object2));
        return Util.makeRectangle((Range)object3, (Range)object2);
    }

    public MarkInfo getMark() {
        return this.maj.states[this.refseq]._mark;
    }

    public boolean isMarked(int n) {
        return this.getMark() != null && n == this.getMark().blockno;
    }

    public synchronized void setMark(Point point, int n, boolean bl) {
        MarkInfo markInfo = this.closest(point, n, bl);
        this.doSetMark(markInfo);
    }

    public synchronized void setMark(int n, int n2) {
        if (n == 0) {
            n = this.getMark().row;
        }
        n2 = this.moveOffGap(n2, this.textdata.rows[0], this.textdata.rows[n]);
        int[] nArray = this.textToCoords(n, n2);
        MarkInfo markInfo = this.findMarkPoint(this.getMark().blockno, nArray[0], nArray[1]);
        this.doSetMark(markInfo);
    }

    public synchronized void setMark(int n) {
        int n2;
        if (n < 0 || n >= this.maj.bf.blocks.size()) {
            Log.fatalBug("MajState.setMark(): Invalid block number \"" + n + "\".");
        }
        if (this.getMark() == null) {
            Log.fatalBug("MajState.setMark(): Previous mark is null.");
        }
        int n3 = this.getMark().seq2;
        BlockRow blockRow = this.maj.bf.block(n).row(this.refseq);
        BlockRow blockRow2 = this.maj.bf.block(n).row(n3);
        if (blockRow == null || blockRow2 == null) {
            Log.fatalBug("MajState.setMark(): Block row is null.");
        }
        if (Util.clamp(blockRow.start, n2 = this.getMark().point.x, blockRow.end) != n2) {
            Log.fatalBug("MajState.setMark(): Previous point lies outside block.");
        }
        int n4 = blockRow.coordToCol(n2);
        int n5 = blockRow2.colToCoord(n4 = this.moveOffGap(n4, blockRow.text, blockRow2.text));
        MarkInfo markInfo = this.findMarkPoint(n, n3, n5);
        if (markInfo == null) {
            Log.fatalBug("MajState.setMark(): Can't find new mark.");
        }
        this.doSetMark(markInfo);
    }

    public synchronized void setMark(MarkInfo markInfo) {
        int n;
        if (markInfo == null || markInfo.block.row(this.refseq) == null) {
            return;
        }
        int n2 = markInfo.blockno;
        int n3 = this.refseq == markInfo.seq2 ? markInfo.refseq : markInfo.seq2;
        BlockRow blockRow = markInfo.block.row(this.refseq);
        BlockRow blockRow2 = markInfo.block.row(n3);
        int n4 = blockRow2.colToCoord(n = this.moveOffGap(markInfo.col, blockRow.text, blockRow2.text));
        MarkInfo markInfo2 = this.findMarkPoint(n2, n3, n4);
        if (markInfo2 != null) {
            this.maj.states[this.refseq]._mark = markInfo2;
        }
    }

    public synchronized void refreshMark() {
        MarkInfo markInfo = this.getMark();
        if (markInfo != null) {
            this.doSetMark(markInfo);
            this.gui.scrollPips(markInfo);
        }
    }

    private void doSetMark(MarkInfo markInfo) {
        Object object;
        Object object2;
        if (markInfo == null) {
            return;
        }
        Range range = markInfo.refrow.getExtent();
        if (range.equals(this.maj.bf.getExtent(markInfo.refseq))) {
            object2 = this.maj.bf.blockname(markInfo.blockno);
            object = NumberFormat.getNumberInstance();
            String string = ((NumberFormat)object).format(range.length());
            String string2 = ((NumberFormat)object).format(markInfo.block.ncols);
            String string3 = "Block " + (String)object2 + " covers the entire aligning extent" + " of the reference sequence" + "\n" + "(" + string + " bp; " + string2 + " alignment columns)." + "  If it is too large," + "\n" + "selecting this block may be very slow due to loading" + " the alignment text." + "\n" + "\n" + "Continue anyway?";
            if (!Log.requestConfirm("big_block", string3)) {
                return;
            }
        }
        this.maj.setBusy(true);
        object2 = this.getMark();
        object = this.maj.states[this.refseq];
        ((MajState)object)._mark = markInfo;
        super.setText(markInfo, (MarkInfo)object2);
        ((MajState)object).showInfo(markInfo);
        ((MajState)object).gui.content.repaint();
        int n = 0;
        while (n < this.maj.nseq) {
            object = this.maj.dpstates[this.refseq][n];
            if (object != null) {
                super.setText(markInfo, (MarkInfo)object2);
                ((MajState)object).showInfo(markInfo);
                ((MajState)object).gui.content.repaint();
            }
            ++n;
        }
        this.maj.setBusy(false);
    }

    private MarkInfo closest(Point point, int n, boolean bl) {
        Point point2 = bl || this.map == null ? point : this.map.inverse(point);
        double d = Double.MAX_VALUE;
        MarkInfo markInfo = null;
        Plot plot = this.view.plots[n];
        Enumeration enumeration = plot.blocks.elements();
        while (enumeration.hasMoreElements()) {
            PlotBlock plotBlock = (PlotBlock)enumeration.nextElement();
            if (!this.maj.global.isVisible(plotBlock)) continue;
            Enumeration enumeration2 = plotBlock.segments.elements();
            while (enumeration2.hasMoreElements()) {
                PlotSeg plotSeg = (PlotSeg)enumeration2.nextElement();
                if (bl && plotSeg.pm < 50) continue;
                try {
                    Point point3 = plotSeg.closest(point2, bl);
                    double d2 = point3.distanceSq(point2);
                    if (!(d2 <= d)) continue;
                    d = d2;
                    markInfo = new MarkInfo(this.maj, this.refseq, n, plotBlock.blockno, plotSeg, point3);
                }
                catch (BadInputException badInputException) {
                    Log.showError("Can't compute distance:\n" + badInputException);
                }
            }
        }
        if (markInfo != null && bl) {
            try {
                markInfo.point = markInfo.segment.intervalX(markInfo.point.x);
            }
            catch (BadInputException badInputException) {
                Log.showError("Can't depipify:\n" + badInputException);
                return null;
            }
        }
        return markInfo;
    }

    private MarkInfo findMarkPoint(int n, int n2, int n3) {
        PlotBlock plotBlock = this.view.plots[n2].block(n);
        if (plotBlock == null) {
            Log.fatalBug("MajState.findMarkPoint(): Plotblock not found.");
        }
        Enumeration enumeration = plotBlock.segments.elements();
        while (enumeration.hasMoreElements()) {
            PlotSeg plotSeg = (PlotSeg)enumeration.nextElement();
            try {
                Point point = plotSeg.intervalY(n3);
                if (point == null) continue;
                return new MarkInfo(this.maj, this.refseq, n2, n, plotSeg, point);
            }
            catch (BadInputException badInputException) {
                Log.showError("Can't check interval:\n" + badInputException);
            }
        }
        Log.showWarning("No point with y=" + n3 + " found in sequence " + n2 + " of block " + n + ".");
        return null;
    }

    private void setText(MarkInfo markInfo, MarkInfo markInfo2) {
        boolean bl;
        boolean bl2 = bl = this.textdata == null || !markInfo.sameBlock(markInfo2) || this.refseq != markInfo2.refseq;
        if (bl) {
            this.textdata = markInfo.block.toText(this.refseq);
            this.hilights = this.makeHighlightList(markInfo.block);
        }
        if (this.textdata.setVisible(this.maj, this) || bl || !this.gui.isTextSet()) {
            this.gui.setText(this.textdata);
            this.gui.setTextMark(markInfo);
            this.gui.setHighlights(this.hilights);
        } else {
            this.gui.setTextMark(markInfo);
        }
    }

    private UnderlayList[] makeHighlightList(Block block) {
        UnderlayList[] underlayListArray = new UnderlayList[this.maj.nseq];
        int n = 0;
        while (n < this.maj.nseq) {
            UnderlayList underlayList = this.maj.views[n].hilights;
            FeatureList featureList = this.maj.views[n].exons;
            UnderlayList underlayList2 = new UnderlayList();
            BlockRow blockRow = block.row(n);
            if (blockRow != null) {
                Copyable copyable;
                Object object;
                Object object2;
                int n2 = block.rowOrder(n, this.refseq);
                if (underlayList.regions.size() > 0) {
                    underlayList2.colors = underlayList.colors;
                    object2 = underlayList.regions.elements();
                    while (object2.hasMoreElements()) {
                        object = (Underlay)object2.nextElement();
                        if (!Util.overlaps(((Underlay)object).start, ((Underlay)object).end, blockRow.start, blockRow.end)) continue;
                        copyable = new Underlay((Underlay)object);
                        ((Underlay)copyable).row = n2;
                        this.setHighlightCols((Underlay)copyable, blockRow);
                        underlayList2.regions.addElement(copyable);
                    }
                } else if (underlayList.filename == null || underlayList.filename.equals("")) {
                    underlayList2.colors = DefaultExonColors.getColors();
                    object2 = new Vector();
                    object = featureList.regions.elements();
                    while (object.hasMoreElements()) {
                        copyable = (Feature)object.nextElement();
                        if (!Util.overlaps(copyable.start, copyable.end, blockRow.start, blockRow.end)) continue;
                        Underlay underlay = new Underlay((Feature)copyable);
                        underlay.kind = DefaultExonColors.getKind(copyable);
                        underlay.row = n2;
                        this.setHighlightCols(underlay, blockRow);
                        if (copyable.kind.equals("Gene") || copyable.kind.equals("Exon")) {
                            underlayList2.regions.addElement(underlay);
                            continue;
                        }
                        if (!copyable.kind.equals("UTR")) continue;
                        ((Vector)object2).addElement(underlay);
                    }
                    underlayList2.regions.addAll(object2);
                }
                underlayListArray[n] = underlayList2;
            }
            ++n;
        }
        return underlayListArray;
    }

    private void setHighlightCols(Underlay underlay, BlockRow blockRow) {
        int n = Util.clamp(blockRow.start, underlay.start, blockRow.end);
        int n2 = Util.clamp(blockRow.start, underlay.end, blockRow.end);
        int n3 = blockRow.coordToCol(n);
        int n4 = blockRow.coordToCol(n2);
        underlay.startcol = Math.min(n3, n4);
        underlay.endcol = Math.max(n3, n4);
    }

    private int[] textToCoords(int n, int n2) {
        BlockRow blockRow = this.getMark().block.rowAt(n, this.refseq);
        if (!this.checkRow(blockRow.text, this.textdata.rows[n], n == 0 ? null : this.textdata.rows[0])) {
            Log.fatalBug("MajState.textToCoords(): Wrong row found.");
        }
        int n3 = blockRow.colToCoord(n2);
        return new int[]{blockRow.seqno, n3};
    }

    private boolean checkRow(String string, String string2, String string3) {
        if (string3 == null) {
            return string.equals(string2);
        }
        int n = string.length();
        if (n != string2.length()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 != (c = string2.charAt(n2)) && (c != '.' || Character.toUpperCase(c2) != Character.toUpperCase(string3.charAt(n2)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int moveOffGap(int n, String string, String string2) {
        int n2 = string.length() - 1;
        if (n2 != string2.length() - 1) {
            Log.fatalBug("MajState.moveOffGap(): Inconsistent row lengths.");
        }
        int n3 = n;
        while (n3 >= 0 && (string.charAt(n3) == '-' || string2.charAt(n3) == '-')) {
            --n3;
        }
        int n4 = n;
        while (n4 <= n2 && (string.charAt(n4) == '-' || string2.charAt(n4) == '-')) {
            ++n4;
        }
        if (n3 >= 0 && n4 <= n2) {
            return n4 - n < n - n3 ? n4 : n3;
        }
        if (n3 >= 0) {
            return n3;
        }
        if (n4 <= n2) {
            return n4;
        }
        return 0;
    }

    public void clearIndicators() {
        this.clearLoc();
        this.clearInfo();
        this.clearZinfo();
    }

    public void clearLoc() {
        this.gui.setLoc("");
    }

    public void showRulerLoc(int n) {
        this.gui.setLoc(Integer.toString(n + this.offsets[this.refseq]));
    }

    public void showBarLoc(int n, float f, Bar bar) {
        if (bar == null) {
            this.gui.setLoc("(" + (n + this.offsets[this.refseq]) + "," + nf.format(f) + ")");
        } else {
            this.gui.setLoc("(" + (n + this.offsets[this.refseq]) + "," + nf.format(f) + "): " + nf.format(bar.score));
        }
    }

    public void showLinkLoc(int n, Linkbar linkbar) {
        if (linkbar == null) {
            this.gui.setLoc(Integer.toString(n + this.offsets[this.refseq]));
        } else {
            this.gui.setLoc(n + this.offsets[this.refseq] + ": " + (linkbar.kind != null && !linkbar.kind.equals("") ? linkbar.kind + ":" : "") + linkbar.label);
        }
    }

    public void showFeatureLoc(int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n + this.offsets[this.refseq]));
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Feature feature = (Feature)enumeration.nextElement();
            if (feature.kind.equals("Gene")) continue;
            stringBuffer.append(bl ? ": " : ", ");
            stringBuffer.append(feature.label);
            stringBuffer.append(" " + (feature.start + this.offsets[this.refseq]) + "-" + (feature.end + this.offsets[this.refseq]));
            bl = false;
        }
        this.gui.setLoc(stringBuffer.toString());
    }

    public void showPipLoc(Point point, int n, Vector vector) {
        String string = this.getUnderlayLabels(vector, this.refseq);
        String string2 = string.equals("") ? "" : ": ";
        this.gui.setLoc("(" + (point.x + this.offsets[this.refseq]) + "," + point.y + "%)" + string2 + string + this.getBlockList(point.x, -1, n));
    }

    public void showDotLoc(Point point, int n) {
        this.showDotLoc(point, n, new Vector(), new Vector());
    }

    public void showDotLoc(Point point, int n, Vector vector, Vector vector2) {
        String string;
        Point point2 = this.map == null ? point : this.map.inverse(point);
        String string2 = string = this.map != null && this.map.getBandCount() > 1 ? this.getContigLabel(this.map.getContig(point)) + ": " : "";
        if (point2.y < 0) {
            this.gui.setLoc(Integer.toString(point2.x + this.offsets[this.refseq]));
        } else {
            String string3 = this.getUnderlayLabels(vector, this.refseq);
            String string4 = this.getUnderlayLabels(vector2, n);
            String string5 = string3.equals("") && string4.equals("") ? "" : ": ";
            String string6 = string3.equals("") || string4.equals("") ? "" : "; ";
            this.gui.setLoc(string + "(" + (point2.x + this.offsets[this.refseq]) + "," + (point2.y + this.offsets[n]) + ")" + string5 + string3 + string6 + string4 + this.getBlockList(point2.x, point2.y, n));
        }
    }

    public void showTextLoc(int n, int n2, Vector vector) {
        if (this.getMark() != null) {
            int[] nArray = this.textToCoords(n, n2);
            String string = this.getUnderlayLabels(vector, nArray[0]);
            String string2 = string.equals("") ? "" : ": ";
            this.gui.setLoc(n2 + "(" + (nArray[1] + this.offsets[nArray[0]]) + ")" + string2 + string);
        }
    }

    public void clearInfo() {
        this.gui.setInfo("", new Vector(), -1);
    }

    public void showInfo(MarkInfo markInfo) {
        int n;
        if (markInfo == null) {
            this.gui.setInfo("", new Vector(), -1);
            return;
        }
        boolean bl = !this.dotplot || this.seq2 == markInfo.seq2;
        int n2 = bl ? markInfo.seq2 : this.seq2;
        BlockRow blockRow = markInfo.block.row(n2);
        String string = blockRow == null ? "__" : Integer.toString(blockRow.start + this.offsets[n2]);
        String string2 = blockRow == null ? "__" : Integer.toString(blockRow.end + this.offsets[n2]);
        PlotBlock plotBlock = this.view.plots[n2].block(markInfo.blockno);
        int n3 = n = blockRow == null ? -1 : blockRow.colToCoord(markInfo.col);
        if (bl && n != markInfo.point.y) {
            Log.fatalBug("MajState.showInfo(): Mark coordinate mismatch.");
        }
        String string3 = blockRow == null ? "__" : Integer.toString(n + this.offsets[n2]);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.map != null && this.map.getBandCount() > 1) {
            stringBuffer.append("[contig hdr goes here]: ");
        }
        stringBuffer.append("block#" + markInfo.blockno);
        if (this.maj.nmaf > 1) {
            stringBuffer.append("=" + this.maj.bf.blockname(markInfo.blockno));
        }
        stringBuffer.append("=(" + (markInfo.refrow.start + this.offsets[this.refseq]) + "," + string + ")");
        stringBuffer.append("-(" + (markInfo.refrow.end + this.offsets[this.refseq]) + "," + string2 + ")");
        stringBuffer.append("@" + (plotBlock == null ? "__" : Integer.toString(plotBlock.pm)) + "%");
        stringBuffer.append("; mark=" + markInfo.col);
        stringBuffer.append("(" + (markInfo.point.x + this.offsets[this.refseq]) + "," + string3 + ")");
        if (bl) {
            this.gui.setInfo(stringBuffer.toString(), this.getBlocknos(markInfo.point.x, markInfo.seq2), markInfo.blockno);
        } else {
            this.gui.setInfo(stringBuffer.toString(), new Vector(), -1);
        }
    }

    public void clearZinfo() {
        this.gui.setZinfo("");
    }

    public void showZinfo() {
        Rectangle rectangle = this.zt.getZoom();
        if (rectangle != null && this.gui != null) {
            Range range = new Range(rectangle.x, rectangle.x + rectangle.width);
            int n = this.maj.specs.getOffset(this.refseq);
            if (this.dotplot) {
                Range range2 = new Range(rectangle.y, rectangle.y + rectangle.height);
                int n2 = this.maj.specs.getOffset(this.seq2);
                this.gui.setZinfo("(" + (range.start + n) + "," + (range2.start + n2) + ")-(" + (range.end + n) + "," + (range2.end + n2) + ")");
            } else {
                this.gui.setZinfo(range.start + n + "-" + (range.end + n));
            }
        }
    }

    private String getContigLabel(String string) {
        return string.startsWith(">") ? ">" + Util.firstWord(Util.drop(string, 1)) : Util.firstWord(string);
    }

    private String getUnderlayLabels(Vector vector, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Underlay underlay = (Underlay)enumeration.nextElement();
            if (!this.maj.global.isVisible(underlay)) continue;
            String string = underlay.label;
            if (string.equals("") || string.equals("()")) {
                if (enumeration.hasMoreElements()) continue;
                string = ColorTable.getColor(underlay.kind) == null ? underlay.kind : "";
            }
            stringBuffer.append(bl ? "" : ", ");
            stringBuffer.append(string + (string.equals("") ? "" : " "));
            stringBuffer.append(underlay.start + this.offsets[n] + "-" + (underlay.end + this.offsets[n]));
            if (underlay.score < Integer.MAX_VALUE) {
                stringBuffer.append("@" + underlay.score);
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    private String getBlockList(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getBlocknos(n, n3);
        int n4 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n5 = (Integer)enumeration.nextElement();
            if (n2 >= 0) continue;
            stringBuffer.append(n4 == 0 ? "" : ",");
            stringBuffer.append(Integer.toString(n5));
            ++n4;
        }
        if (n4 > 0) {
            stringBuffer.insert(0, "; " + (n4 == 1 ? "block=" : "blocks="));
        }
        return stringBuffer.toString();
    }

    private Vector getBlocknos(int n, int n2) {
        Vector<Integer> vector = new Vector<Integer>();
        Vector vector2 = this.view.bi.search(n);
        Collections.sort(vector2);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            PlotBlock plotBlock = this.view.plots[n2].block(n3);
            if (plotBlock == null || !this.maj.global.isVisible(plotBlock)) continue;
            vector.addElement(n3);
        }
        return vector;
    }

    private String loc(int n, int n2) {
        return Integer.toString(n2 >= 0 ? n + this.offsets[n2] : n);
    }

    private String loc(int n, int n2, int n3, int n4) {
        return "(" + this.loc(n, n2) + "," + this.loc(n3, n4) + ")";
    }

    private String loc(int n, int n2, int n3) {
        return "(" + this.loc(n, n2) + "," + n3 + "%)";
    }

    private String loc(int n, int n2, float f) {
        return "(" + this.loc(n, n2) + "," + nf.format(f) + ")";
    }

    public int seqForPip(int n) {
        return n < this.refseq ? n : n + 1;
    }

    public int pipForSeq(int n) {
        return n < this.refseq ? n : n - 1;
    }

    public boolean overlaps(int n, Rectangle rectangle) {
        BlockRow blockRow;
        if (n < 0 || n >= this.maj.bf.blocks.size() || rectangle == null) {
            return false;
        }
        Range range = new Range(rectangle.x, rectangle.x + rectangle.width);
        Range range2 = new Range(rectangle.y, rectangle.y + rectangle.height);
        Block block = this.maj.bf.block(n);
        BlockRow blockRow2 = block.row(this.refseq);
        if (blockRow2 == null || !blockRow2.getExtent().overlaps(range)) {
            return false;
        }
        return !this.dotplot || (blockRow = block.row(this.seq2)) != null && blockRow.getExtent().overlaps(range2);
    }

    public Dimension getFrameSize() {
        if (this.frameSize == null) {
            Dimension dimension = this.frameSize = this.dotplot ? Config.dotplotFrameSize : Config.multipipFrameSize;
        }
        if (this.frameSize == null) {
            Rectangle rectangle = this.gui.frame.getGraphicsConfiguration().getBounds();
            int n = rectangle.width;
            int n2 = (int)((double)rectangle.height * 0.9);
            int n3 = Math.min(this.gui.frame.getWidth() + 100, n);
            int n4 = Math.min(this.gui.frame.getHeight(), n2);
            this.frameSize = new Dimension(n3, n4);
        }
        return this.frameSize;
    }

    public void setFrameSize(Dimension dimension) {
        this.frameSize = dimension;
        if (this.dotplot) {
            Config.setDotplotFrameSize(dimension);
        } else if (this.maj.nseq > 2) {
            Config.setMultipipFrameSize(dimension);
        }
    }

    public Point getFrameLocation() {
        if (this.frameLocation == null) {
            int n;
            int n2;
            Rectangle rectangle = this.gui.frame.getGraphicsConfiguration().getBounds();
            Dimension dimension = this.getFrameSize();
            int n3 = Math.max(rectangle.width - dimension.width, 240);
            int n4 = Math.max(rectangle.height - dimension.height, 80);
            MajState majState = this.maj.states[this.refseq];
            if (this.dotplot && majState != null) {
                Dimension dimension2 = majState.getFrameSize();
                Point point = majState.getFrameLocation();
                n2 = (point.x + dimension2.width + 30 * this.seq2) % n3;
                n = (point.y + dimension2.height + 10 * this.seq2) % n4;
            } else {
                n2 = 60 * (this.refseq + 1) % n3;
                n = 20 * (this.refseq + 1) % n4;
            }
            this.frameLocation = new Point(rectangle.x + n2, rectangle.y + n);
        }
        return this.frameLocation;
    }

    public void setFrameLocation(Point point) {
        this.frameLocation = point;
    }

    public void setBusy(boolean bl) {
        if (this.gui != null) {
            this.gui.setBusy(bl);
        }
    }

    static {
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
    }
}

