/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Log;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MajSplitPane
extends JSplitPane {
    static final String rcsid = "$Revision: 1.1 $$Date: 2008/02/19 19:22:38 $";
    private boolean sticky;
    private BasicSplitPaneDivider div;
    private Border high;
    private Border low;
    private int delta;
    private Dimension oldmin1;
    private Dimension oldmin2;
    private int resetsPending;

    public MajSplitPane(int n, JComponent jComponent, JComponent jComponent2) {
        super(n, jComponent, jComponent2);
        this.setContinuousLayout(true);
        this.initSticky();
        this.oldmin2 = null;
        this.oldmin1 = null;
        this.resetsPending = 0;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        JComponent jComponent = (JComponent)this.getLeftComponent();
        JComponent jComponent2 = (JComponent)this.getRightComponent();
        Dimension dimension = jComponent == null ? new Dimension(0, 0) : jComponent.getMaximumSize();
        Dimension dimension2 = jComponent2 == null ? new Dimension(0, 0) : jComponent2.getMaximumSize();
        Insets insets = this.getInsets();
        long l = 0L;
        long l2 = 0L;
        if (this.getOrientation() == 1) {
            l = (long)dimension.width + (long)dimension2.width + 8L;
            l2 = Math.max(dimension.height, dimension2.height);
        } else {
            l = Math.max(dimension.width, dimension2.width);
            l2 = (long)dimension.height + (long)dimension2.height + 8L;
        }
        if (insets != null) {
            l += (long)(insets.left + insets.right);
            l2 += (long)(insets.top + insets.bottom);
        }
        l = Math.min(l, Integer.MAX_VALUE);
        l2 = Math.min(l2, Integer.MAX_VALUE);
        return new Dimension((int)l, (int)l2);
    }

    public void resetToPreferredSizes() {
        if (this.sticky) {
            this.revalidate();
            return;
        }
        final JComponent jComponent = (JComponent)this.getLeftComponent();
        final JComponent jComponent2 = (JComponent)this.getRightComponent();
        final Dimension dimension = this.runMinimumSizeForReset(jComponent);
        final Dimension dimension2 = this.runMinimumSizeForReset(jComponent2);
        if (dimension != null) {
            if (this.resetsPending == 0) {
                this.oldmin1 = jComponent.isMinimumSizeSet() ? jComponent.getMinimumSize() : null;
            }
            jComponent.setMinimumSize(dimension);
        }
        if (dimension2 != null) {
            if (this.resetsPending == 0) {
                this.oldmin2 = jComponent2.isMinimumSizeSet() ? jComponent2.getMinimumSize() : null;
            }
            jComponent2.setMinimumSize(dimension2);
        }
        ++this.resetsPending;
        super.resetToPreferredSizes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (--MajSplitPane.this.resetsPending == 0) {
                    if (dimension != null) {
                        jComponent.setMinimumSize(MajSplitPane.this.oldmin1);
                    }
                    if (dimension2 != null) {
                        jComponent2.setMinimumSize(MajSplitPane.this.oldmin2);
                    }
                }
            }
        });
    }

    private Dimension runMinimumSizeForReset(JComponent jComponent) {
        Dimension dimension = null;
        try {
            Method method;
            if (jComponent != null && (method = jComponent.getClass().getMethod("getMinimumSizeForReset", null)) != null) {
                dimension = (Dimension)method.invoke((Object)jComponent, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            Log.warn("MajSplitPane.runMinimumSizeForReset(): SecurityException\n" + securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("MajSplitPane.runMinimumSizeForReset(): InvocationTargetException in client\n" + invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            Log.warn("MajSplitPane.runMinimumSizeForReset():\n" + exception);
        }
        return dimension;
    }

    private void initSticky() {
        this.sticky = false;
        try {
            this.div = ((BasicSplitPaneUI)this.getUI()).getDivider();
            this.high = this.div.getBorder();
            this.low = BorderFactory.createLoweredBevelBorder();
            Insets insets = this.high.getBorderInsets(null);
            Insets insets2 = this.low.getBorderInsets(null);
            this.delta = this.getOrientation() == 1 ? insets2.left + insets2.right - insets.left - insets.right : insets2.top + insets2.bottom - insets.top - insets.bottom;
            this.div.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    MajSplitPane.this.stickyOn();
                }
            });
            this.div.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    MajSplitPane.this.stickyOff();
                }
            });
        }
        catch (ClassCastException classCastException) {
            Log.warn("MajSplitPane.initSticky(): Unexpected class for JSplitPane divider:\n" + classCastException);
            Log.showWarning("no_sticky", "Warning:\nDraggable panel dividers will not be \"sticky\" with\nyour Java version and/or settings.");
            this.div = null;
            this.low = null;
            this.high = null;
            this.delta = 0;
        }
    }

    private void stickyOn() {
        if (this.div != null && !this.sticky) {
            this.sticky = true;
            this.div.setBorder(this.low);
            this.div.setDividerSize(this.div.getDividerSize() + this.delta);
        }
    }

    private void stickyOff() {
        if (this.div != null && this.sticky) {
            this.sticky = false;
            this.div.setBorder(this.high);
            this.div.setDividerSize(this.div.getDividerSize() - this.delta);
            this.resetToPreferredSizes();
        }
    }
}

