/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajGui;
import edu.psu.bx.gmaj.PackageInfo;
import java.util.Enumeration;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class MajMain {
    static final String rcsid = "$Revision: 1.15 $$Date: 2008/05/06 18:22:32 $";

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals("-version")) {
                    System.err.println("\n" + PackageInfo.about());
                    System.err.flush();
                    System.exit(0);
                } else if (stringArray[n4].equals("-help")) {
                    Log.err(MajMain.usage());
                    System.exit(0);
                } else if (stringArray[n4].equals("-debug")) {
                    bl = true;
                } else if (stringArray[n4].equals("-test")) {
                    bl2 = true;
                } else if (stringArray[n4].equals("-plaf")) {
                    MajGui.setDefaults();
                    MajMain.printPlafInfo();
                    System.exit(0);
                } else if (stringArray[n4].equals("-urlpause")) {
                    if ((n3 = Integer.parseInt(stringArray[++n4])) < 0) {
                        throw new BadInputException("Invalid parameter: urlpause must be >= 0.");
                    }
                } else if (stringArray[n4].equals("-initzoom")) {
                    string3 = stringArray[++n4];
                    n = Integer.parseInt(stringArray[++n4]);
                    n2 = Integer.parseInt(stringArray[++n4]);
                    if (n <= 0 && n != -1 || n2 <= 0 && n2 != -1) {
                        throw new BadInputException("Invalid parameter: initzoom start/end must either be -1, or > 0.");
                    }
                } else if (stringArray[n4].equals("-bundle")) {
                    string2 = stringArray[++n4];
                } else if (string.equals("")) {
                    string = stringArray[n4];
                } else {
                    throw new BadInputException("Unrecognized option.\n\n" + MajMain.usage());
                }
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.err("Missing parameter: not enough tokens for option.\n\n" + MajMain.usage());
            System.exit(1);
        }
        catch (NumberFormatException numberFormatException) {
            Log.err("Invalid parameter: urlpause and initzoom start/end must be integers.");
            System.exit(1);
        }
        catch (BadInputException badInputException) {
            Log.err(badInputException.getMessage());
            System.exit(1);
        }
        Maj maj = new Maj(null, string, string2, string3, n, n2, null, n3, bl, bl2);
    }

    public static void printPlafInfo() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            System.out.println(lookAndFeelInfoArray[n].getName());
            ++n;
        }
        System.out.println();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        int[] nArray = (int[])uIDefaults.get("Menu.shortcutKeys");
        System.out.print("Menu.shortcutKeys = [");
        int n2 = 0;
        while (n2 < nArray.length) {
            System.out.print(" " + nArray[n2]);
            ++n2;
        }
        System.out.println(" ]");
        System.out.println("SHIFT_MASK = 1");
        System.out.println("CTRL_MASK = 2");
        System.out.println("META_MASK = 4");
        System.out.println("ALT_MASK = 8");
        System.out.println("ALT_GRAPH_MASK = 32");
        System.out.println();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            InputMap inputMap;
            String string = (String)enumeration.nextElement();
            if (string.indexOf("Text") < 0 || string.indexOf("InputMap") < 0 || (inputMap = (InputMap)uIDefaults.get(string)) == null) continue;
            KeyStroke[] keyStrokeArray = inputMap.keys();
            System.out.println(string + ": [");
            int n3 = 0;
            while (n3 < keyStrokeArray.length) {
                System.out.println("  " + keyStrokeArray[n3] + ": " + inputMap.get(keyStrokeArray[n3]));
                ++n3;
            }
            System.out.println("]");
        }
        System.out.println();
        System.out.println(uIDefaults.toString());
    }

    public static String usage() {
        String string = Log.programName.toLowerCase() + ".jar";
        return "Usage:\n   java -jar " + string + "\n" + "       [-version] [-help] [-debug] [-urlpause <millisec>]" + "\n" + "       [-initzoom <refseqname> <start> <end>]" + "\n" + "       [-bundle <zipfile>] [<paramfile>|<alignfile>]" + "\n" + "\n" + "The paramfile contains all of the datafile names and related" + "\n" + "parameters (see sample.gmaj for the proper format).  Or, if" + "\n" + "you don't want to show any annotations, you can provide the" + "\n" + "name of the alignment file directly.  Either type of file" + "\n" + "can be specified with an absolute or relative path, or with" + "\n" + "a URL.  For further details, please see the documentation." + "\n" + "\n" + "Example:  java -jar " + string + " region1.gmaj" + "\n";
    }
}

