/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BarPane;
import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.BlockSelector;
import edu.psu.bx.gmaj.BlockText;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Exporter;
import edu.psu.bx.gmaj.FeaturePane;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.LinkbarPane;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajSplitPane;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.PackageInfo;
import edu.psu.bx.gmaj.PanelChooser;
import edu.psu.bx.gmaj.PlotPane;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.RulerPane;
import edu.psu.bx.gmaj.SingleLineLabel;
import edu.psu.bx.gmaj.TextPane;
import edu.psu.bx.gmaj.UnderlayList;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.View;
import edu.psu.bx.gmaj.VisibilityPanel;
import edu.psu.bx.gmaj.ZoomChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MajGui {
    static final String rcsid = "$Revision: 1.74 $$Date: 2008/06/30 18:22:44 $";
    static final float TOP = 0.0f;
    static final float LEFT = 0.0f;
    static final float CENTER = 0.5f;
    static final int WHEN = 2;
    Maj maj;
    int refseq;
    View view;
    MajState state;
    boolean dotplot;
    int seq2;
    JFrame frame;
    JPanel content;
    int npips;
    int labelWidth;
    int dotbuttonWidth;
    Toolkit toolkit;
    private JMenuItem open;
    private JMenuItem export;
    private JMenuItem close;
    private JMenuItem quit;
    private JRadioButtonMenuItem small;
    private JRadioButtonMenuItem large;
    private JRadioButtonMenuItem red;
    private JRadioButtonMenuItem xor;
    private JMenuItem show;
    private JMenuItem[] views;
    private JMenuItem backzoom;
    private JMenuItem forwardzoom;
    private JMenuItem unzoom;
    private JMenuItem newzoom;
    private JMenuItem tag;
    private JMenuItem clear;
    private JMenuItem about;
    private JMenuItem manual;
    private JMenuItem keys;
    private JMenuItem seqsum;
    private JTextField ilimit;
    private JTextField ulimit;
    private SingleLineLabel loc;
    private SingleLineLabel info;
    private SingleLineLabel zinfo;
    private JButton left;
    private JButton right;
    private JButton down;
    private JButton up;
    private BlockSelector bselect;
    private VisibilityPanel vispanel;
    private RulerPane tickcanvas;
    private BarPane correctcanvas;
    private BarPane presentcanvas;
    private LinkbarPane linkcanvas;
    private FeaturePane exoncanvas;
    private FeaturePane repeatcanvas;
    private PlotPane[] pipcanvas;
    private JButton[] dotbuttons;
    private PlotPane dotcanvas;
    private TextPane textview;
    private MajSplitPane locpanel;
    private MajSplitPane infopanel;
    private MajSplitPane splitpanel;
    private JScrollPane scrollpanel;
    private JPanel glasspane;

    public MajGui(Maj maj, int n) {
        this(maj, n, false, -1);
    }

    public MajGui(Maj maj, int n, boolean bl, int n2) {
        if (maj.specs == null || maj.bf == null || maj.views[n] == null || (bl ? maj.dpstates[n][n2] : maj.states[n]) == null) {
            Log.fatalBug("MajGui.MajGui(): Must initialize the applicable specs, blockfile,\nview, and state before instantiating MajGui.");
        }
        this.maj = maj;
        this.refseq = n;
        this.dotplot = bl;
        this.seq2 = n2;
        this.view = maj.views[n];
        this.state = bl ? maj.dpstates[n][n2] : maj.states[n];
        this.npips = bl ? 1 : maj.nseq - 1;
        this.labelWidth = this.maxLabelWidth(maj.bf, Config.menuFont);
        this.dotbuttonWidth = 0;
        this.toolkit = new JPanel().getToolkit();
        this.state.gui = this;
        JMenuBar jMenuBar = this.makeMenuBar();
        this.locpanel = this.makeLocPanel();
        this.infopanel = this.makeInfoPanel();
        this.vispanel = new VisibilityPanel(maj, this.state);
        this.tickcanvas = new RulerPane(maj, this.state);
        this.correctcanvas = new BarPane(maj, this.state, this.view.correctness);
        this.presentcanvas = new BarPane(maj, this.state, this.view.presentness);
        this.linkcanvas = new LinkbarPane(maj, this.state, this.view.links);
        this.exoncanvas = new FeaturePane(maj, this.state, this.view.exons);
        this.repeatcanvas = new FeaturePane(maj, this.state, this.view.repeats);
        this.pipcanvas = new PlotPane[this.npips];
        int n3 = 0;
        while (n3 < this.npips) {
            int n4 = bl ? n2 : this.state.seqForPip(n3);
            this.pipcanvas[n3] = new PlotPane(maj, this.state, n4, 1);
            ++n3;
        }
        this.dotbuttons = this.makeDotButtons();
        this.dotcanvas = bl ? new PlotPane(maj, this.state, n2, 0) : null;
        this.textview = new TextPane(maj, this.state);
        this.state.zt.enableZoomControls();
        this.content = new JPanel();
        this.content.setLayout(new BoxLayout(this.content, 1));
        if (maj.global.getShown("posline")) {
            this.content.add(this.locpanel);
        }
        if (maj.global.getShown("markline")) {
            this.content.add(this.infopanel);
        }
        if (maj.global.getShown("vis")) {
            this.content.add(this.vispanel);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (maj.global.getShown("ruler")) {
            jPanel.add(this.makeZoomPanel(maj.bf.mafseqname(n) + ":", this.tickcanvas));
        }
        if (maj.global.getShown("recon") && this.view.correctness.size() > 0) {
            jPanel.add(this.makeZoomPanel("   correctness", this.correctcanvas));
        }
        if (maj.global.getShown("recon") && this.view.presentness.size() > 0) {
            jPanel.add(this.makeZoomPanel("   presentness", this.presentcanvas));
        }
        if (maj.global.getShown("links") && this.view.links.regions.size() > 0) {
            jPanel.add(this.makeZoomPanel("   links", this.linkcanvas));
        }
        if (maj.global.getShown("exons") && this.view.exons.regions.size() > 0) {
            jPanel.add(this.makeZoomPanel("   exons", this.exoncanvas));
        }
        if (maj.global.getShown("repeats") && this.view.repeats.regions.size() > 0) {
            jPanel.add(this.makeZoomPanel("   repeats+", this.repeatcanvas));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        int n5 = 0;
        while (n5 < this.npips) {
            int n6;
            int n7 = n6 = bl ? n2 : this.state.seqForPip(n5);
            if (maj.global.getShown(n6)) {
                jPanel2.add(this.makeZoomPanel("vs.\n" + maj.bf.mafseqname(n6), this.dotbuttons[n5], this.pipcanvas[n5]));
            }
            ++n5;
        }
        if (bl) {
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            jPanel3.add(this.makeZoomPanel("vs.\n" + maj.bf.mafseqname(n2), this.dotcanvas));
            if (maj.global.getShown("text")) {
                jPanel3.add(this.textview);
            }
            jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
            this.content.add(jPanel3);
        } else {
            this.scrollpanel = new JScrollPane(jPanel2);
            this.scrollpanel.setColumnHeaderView(jPanel);
            this.scrollpanel.setHorizontalScrollBarPolicy(31);
            if (maj.global.getShown("text")) {
                this.splitpanel = new MajSplitPane(0, this.scrollpanel, this.textview);
                this.splitpanel.setResizeWeight(0.7);
                this.content.add(this.splitpanel);
            } else {
                this.content.add(this.scrollpanel);
            }
        }
        Util.adjustChildren(this.content, 0.0f, 0.0f, 0, 0);
        this.ilimit.setMaximumSize(this.ilimit.getMinimumSize());
        this.ilimit.setPreferredSize(this.ilimit.getMinimumSize());
        this.ulimit.setMaximumSize(this.ulimit.getMinimumSize());
        this.ulimit.setPreferredSize(this.ulimit.getMinimumSize());
        this.setHeight(this.locpanel, this.locpanel.getPreferredSize().height);
        this.setHeight(this.tickcanvas, ((Component)this.tickcanvas).getFontMetrics(Config.tickFont).getHeight() * 2);
        this.setHeight(this.correctcanvas, 30);
        this.setHeight(this.presentcanvas, 30);
        Insets insets = Config.nobarZoomBorder.getBorderInsets(null);
        this.setHeight(this.linkcanvas, this.view.links.numRows * 6 + insets.top + insets.bottom);
        this.setHeight(this.exoncanvas, 25);
        this.setHeight(this.repeatcanvas, 25);
        int n8 = 0;
        while (n8 < this.npips) {
            this.setHeight(this.pipcanvas[n8], Config.pipHeight);
            ++n8;
        }
        if (bl) {
            this.dotcanvas.setPreferredSize(new Dimension(this.dotcanvas.getPreferredSize().width, Config.dotHeight));
        }
        this.setHeight(this.textview, this.textview.getPreferredSize().height);
        if (bl) {
            this.textview.setMinimumSize(new Dimension(this.textview.getMinimumSize().width, this.textview.getPreferredSize().height));
        }
        this.glasspane = new JPanel();
        this.glasspane.setOpaque(false);
        this.glasspane.addMouseListener(new MouseAdapter(){});
        this.glasspane.addMouseMotionListener(new MouseMotionAdapter(){});
        String string = maj.specs.getTitle();
        string = Log.programName + (string == null || string.equals("") ? "" : ": " + string) + ": " + maj.bf.mafseqname(n) + (bl ? " vs. " + maj.bf.mafseqname(n2) : "");
        this.frame = new JFrame(string);
        this.frame.setJMenuBar(jMenuBar);
        this.frame.setContentPane(this.content);
        this.frame.setGlassPane(this.glasspane);
        this.addFrameListeners();
        this.frame.pack();
        ((Component)this.frame).setSize(this.state.getFrameSize());
        ((Component)this.frame).setLocation(this.state.getFrameLocation());
        if (!bl && maj.nseq != 2 || bl && maj.global.getShown(n2)) {
            ((Component)this.frame).setVisible(true);
        }
        this.blockInput(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!MajGui.this.dotplot && MajGui.this.frame.isVisible()) {
                    MajGui.this.scrollPips(null);
                }
                MajGui.this.state.refreshMark();
            }
        });
    }

    static void setDefaults() {
        Object object;
        Object object2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            object2 = UIManager.getLookAndFeelDefaults();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Object object3 = ((UIDefaults)object2).get(string);
                if (object3 == null || !(object3 instanceof InputMap)) continue;
                hashtable.put(string, object3);
            }
        }
        try {
            System.setProperty("swing.metalTheme", "steel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            Log.showError("Can't find/use cross-platform look & feel.\nUsing the default look & feel.");
        }
        try {
            UIManager.put("Menu.font", Config.menuFont);
            UIManager.put("MenuItem.font", Config.menuFont);
            UIManager.put("RadioButtonMenuItem.font", Config.menuFont);
            UIManager.put("Label.font", Config.menuFont);
            UIManager.put("Button.font", Config.menuFont);
            UIManager.put("ToggleButton.font", Config.menuFont);
            UIManager.put("ComboBox.font", Config.menuFont);
            UIManager.put("TextField.font", Config.inputFont);
            UIManager.put("TextArea.font", Config.outputFont);
            UIManager.put("ScrollBar.width", new Integer(15));
            UIManager.put("SplitPane.dividerSize", new Integer(8));
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                UIManager.put(object, hashtable.get(object));
            }
        }
        catch (InternalError internalError) {
            if (internalError.getMessage().indexOf("Can't connect to X11 window server") >= 0) {
                Log.err("Warning: no X display => no custom fonts");
            }
            throw internalError;
        }
    }

    private int maxLabelWidth(BlockFile blockFile, Font font) {
        FontMetrics fontMetrics = ((Component)new JTextArea()).getFontMetrics(font);
        int n = Math.max(fontMetrics.stringWidth("   exons"), fontMetrics.stringWidth("   repeats+"));
        if (this.maj.global.getShown("recon") && this.view.correctness.size() > 0) {
            n = Math.max(n, fontMetrics.stringWidth("   correctness"));
        }
        if (this.maj.global.getShown("recon") && this.view.presentness.size() > 0) {
            n = Math.max(n, fontMetrics.stringWidth("   presentness"));
        }
        int n2 = 0;
        while (n2 < blockFile.seqrefs.size()) {
            if (!this.dotplot || n2 == this.refseq || n2 == this.seq2) {
                n = Math.max(n, fontMetrics.stringWidth(blockFile.mafseqname(n2) + ":"));
            }
            ++n2;
        }
        return n;
    }

    private JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        ImageIcon imageIcon = Util.makeMenuArrow(this.toolkit, Config.foregroundColor);
        JMenu jMenu = new JMenu("File");
        jMenu.setIcon(imageIcon);
        jMenu.setHorizontalTextPosition(2);
        JMenu jMenu2 = new JMenu("Options");
        jMenu2.setIcon(imageIcon);
        jMenu2.setHorizontalTextPosition(2);
        JMenu jMenu3 = new JMenu("Reference");
        jMenu3.setIcon(imageIcon);
        jMenu3.setHorizontalTextPosition(2);
        JMenu jMenu4 = new JMenu("Zoom");
        jMenu4.setIcon(imageIcon);
        jMenu4.setHorizontalTextPosition(2);
        JMenu jMenu5 = new JMenu("Tags");
        jMenu5.setIcon(imageIcon);
        jMenu5.setHorizontalTextPosition(2);
        JMenu jMenu6 = new JMenu("Help");
        jMenu6.setIcon(imageIcon);
        jMenu6.setHorizontalTextPosition(2);
        this.open = new JMenuItem("Open...");
        this.export = new JMenuItem("Export...");
        this.close = new JMenuItem("Close");
        this.quit = new JMenuItem("Exit");
        this.small = new JRadioButtonMenuItem("Small Fonts");
        this.large = new JRadioButtonMenuItem("Large Fonts");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.small);
        buttonGroup.add(this.large);
        if (Config.fontset.equals("large")) {
            this.large.setSelected(true);
        } else {
            this.small.setSelected(true);
        }
        this.red = new JRadioButtonMenuItem("Mark Always Red");
        this.xor = new JRadioButtonMenuItem("Mark Color Varies");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.red);
        buttonGroup2.add(this.xor);
        if (Config.markMode.equals("xor")) {
            this.xor.setSelected(true);
        } else {
            this.red.setSelected(true);
        }
        this.show = new JMenuItem("Show...");
        this.views = new JMenuItem[this.maj.nseq];
        int n = 0;
        while (n < this.maj.nseq) {
            this.views[n] = new JMenuItem(n + ": " + this.maj.bf.mafseqname(n));
            ++n;
        }
        this.views[this.refseq].setEnabled(false);
        this.backzoom = new JMenuItem("Back");
        this.forwardzoom = new JMenuItem("Forward");
        this.unzoom = new JMenuItem("Unzoom");
        this.newzoom = new JMenuItem("Set Zoom...");
        this.tag = new JMenuItem("Tag/Untag Block");
        this.clear = new JMenuItem("Clear All Tags");
        this.about = new JMenuItem("About");
        this.manual = new JMenuItem("Manual");
        this.keys = new JMenuItem("Keys");
        this.seqsum = new JMenuItem("Sequence Summary");
        JLabel jLabel = new JLabel("% Identity \u2265 ");
        JLabel jLabel2 = new JLabel("Underlays \u2265 ");
        jLabel.setForeground(Config.foregroundColor);
        jLabel2.setForeground(Config.foregroundColor);
        this.ilimit = new JTextField(Integer.toString(this.maj.global.ilimit), 4);
        this.ulimit = new JTextField(Integer.toString(this.maj.global.ulimit), 4);
        jMenuBar.setBorder(BorderFactory.createEmptyBorder(4, 6, 3, 3));
        jMenuBar.add(jMenu);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jMenu2);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jMenu3);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jMenu4);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jMenu5);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jMenu6);
        jMenuBar.add(Box.createRigidArea(new Dimension(20, 0)));
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jLabel);
        jMenuBar.add(this.ilimit);
        jMenuBar.add(Box.createRigidArea(new Dimension(10, 0)));
        jMenuBar.add(jLabel2);
        jMenuBar.add(this.ulimit);
        Util.adjustChildren(jMenuBar, 0.0f, 0.5f, 0, 0);
        if (this.maj.applet == null) {
            jMenu.add(this.open);
        }
        if (this.allowExport()) {
            jMenu.add(this.export);
        }
        jMenu.add(this.close);
        jMenu.add(this.quit);
        jMenu2.add(this.small);
        jMenu2.add(this.large);
        jMenu2.addSeparator();
        jMenu2.add(this.red);
        jMenu2.add(this.xor);
        jMenu2.addSeparator();
        jMenu2.add(this.show);
        if (this.maj.specs.getRefSeq().equals("any")) {
            int n2 = 0;
            while (n2 < this.maj.nseq) {
                jMenu3.add(this.views[n2]);
                ++n2;
            }
        } else {
            jMenu3.add(this.views[this.refseq]);
        }
        jMenu4.add(this.backzoom);
        jMenu4.add(this.forwardzoom);
        jMenu4.add(this.unzoom);
        jMenu4.add(this.newzoom);
        jMenu5.add(this.tag);
        jMenu5.add(this.clear);
        jMenu6.add(this.about);
        jMenu6.add(this.manual);
        jMenu6.add(this.keys);
        jMenu6.add(this.seqsum);
        this.addMenuBarListeners();
        return jMenuBar;
    }

    private boolean allowExport() {
        return this.maj.applet == null || this.maj.postUrl != null;
    }

    private MajSplitPane makeLocPanel() {
        ImageIcon imageIcon = Util.makeCursorArrow(this.toolkit, Config.foregroundColor);
        this.loc = new SingleLineLabel("(x,y)", Config.outputFont, null);
        JPanel jPanel = this.makeIconTextPanel(imageIcon, this.loc);
        ImageIcon imageIcon2 = Util.makeZoomBars(this.toolkit, Config.zoomBarColor);
        this.zinfo = new SingleLineLabel("start-end", Config.outputFont, null);
        this.state.showZinfo();
        this.left = this.makeArrowButton(Util.makeLeftArrow(this.toolkit, Config.foregroundColor), 0, 37, "left");
        this.right = this.makeArrowButton(Util.makeRightArrow(this.toolkit, Config.foregroundColor), 1, 39, "right");
        this.down = this.makeArrowButton(Util.makeDownArrow(this.toolkit, Config.foregroundColor), 2, 40, "down");
        this.up = this.makeArrowButton(Util.makeUpArrow(this.toolkit, Config.foregroundColor), 3, 38, "up");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.makeIconTextPanel(imageIcon2, this.zinfo));
        jPanel2.add(this.left);
        jPanel2.add(this.right);
        if (this.dotplot) {
            jPanel2.add(this.down);
            jPanel2.add(this.up);
        }
        MajSplitPane majSplitPane = new MajSplitPane(1, jPanel, jPanel2);
        majSplitPane.setResizeWeight(1.0);
        majSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return majSplitPane;
    }

    private JButton makeArrowButton(Icon icon, final int n, int n2, String string) {
        JButton jButton = new JButton(icon);
        jButton.setMargin(new Insets(jButton.getMargin().top, 0, jButton.getMargin().bottom, 0));
        jButton.setMaximumSize(new Dimension(jButton.getMinimumSize().width, 9999));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.state.zt.slideZoom(n);
                MajGui.this.restoreFocus();
                MajGui.this.content.repaint();
            }
        };
        jButton.addActionListener(abstractAction);
        jButton.getInputMap(2).put(KeyStroke.getKeyStroke(n2, 0), string);
        jButton.getActionMap().put(string, abstractAction);
        return jButton;
    }

    private MajSplitPane makeInfoPanel() {
        ImageIcon imageIcon = Util.makeMarkCircle(this.toolkit, Config.markColor);
        this.info = new SingleLineLabel(" ", Config.outputFont, null);
        JPanel jPanel = this.makeIconTextPanel(imageIcon, this.info);
        this.bselect = new BlockSelector(this.maj, this.state);
        this.bselect.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        MajSplitPane majSplitPane = new MajSplitPane(1, jPanel, this.bselect);
        majSplitPane.setResizeWeight(1.0);
        majSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return majSplitPane;
    }

    private JPanel makeIconTextPanel(Icon icon, SingleLineLabel singleLineLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel(icon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.add(singleLineLabel);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JButton[] makeDotButtons() {
        JButton[] jButtonArray = new JButton[this.npips];
        ImageIcon imageIcon = Util.makeDots(this.toolkit, Config.foregroundColor);
        int n = 0;
        while (n < this.npips) {
            if (this.dotplot) {
                jButtonArray[n] = null;
            } else {
                JButton jButton = new JButton(imageIcon);
                jButton.setMargin(new Insets(0, 0, 0, 0));
                if (n == 0) {
                    this.dotbuttonWidth = jButton.getMinimumSize().width;
                }
                int n2 = jButton.getMinimumSize().height;
                jButton.setPreferredSize(new Dimension(this.dotbuttonWidth, n2));
                jButton.setMaximumSize(new Dimension(this.dotbuttonWidth, n2));
                final int n3 = n;
                AbstractAction abstractAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MajGui.this.maj.displayDotplot(MajGui.this.refseq, MajGui.this.state.seqForPip(n3), MajGui.this.state);
                    }
                };
                jButton.addActionListener(abstractAction);
                jButton.getInputMap(2).put(KeyStroke.getKeyStroke('d'), "dotplot");
                jButton.getActionMap().put("dotplot", abstractAction);
                jButtonArray[n] = jButton;
            }
            ++n;
        }
        return jButtonArray;
    }

    private JPanel makeZoomPanel(String string, JPanel jPanel) {
        return this.makeZoomPanel(string, null, jPanel);
    }

    private JPanel makeZoomPanel(String string, JButton jButton, JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, jPanel);
        multiLineLabel.adjustSize(this.labelWidth);
        multiLineLabel.setPreferredSize(multiLineLabel.getMaximumSize());
        if (!this.isDotplot(jPanel)) {
            multiLineLabel.setAlignmentY(0.5f);
        }
        jPanel2.add(multiLineLabel);
        jPanel2.add(jButton != null ? jButton : Box.createRigidArea(new Dimension(this.dotbuttonWidth, 0)));
        jPanel.setBorder(jPanel instanceof PlotPane ? Config.barZoomBorder : Config.nobarZoomBorder);
        jPanel2.add(jPanel);
        Border border = BorderFactory.createRaisedBevelBorder();
        jPanel2.setBorder(border);
        jPanel2.setBackground(jPanel.getBackground());
        return jPanel2;
    }

    private boolean isDotplot(JPanel jPanel) {
        return jPanel instanceof PlotPane ? !((PlotPane)jPanel).pip : false;
    }

    private void setHeight(JComponent jComponent, int n) {
        jComponent.setMaximumSize(new Dimension(9999, n));
        jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, n));
    }

    private void addMenuBarListeners() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MajGui.this.maj.applet == null) {
                    MajGui.this.maj.loadNewData();
                }
            }
        };
        this.open.addActionListener(abstractAction);
        this.open.getInputMap(2).put(KeyStroke.getKeyStroke('o'), "open");
        this.open.getActionMap().put("open", abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Exporter(MajGui.this.maj, MajGui.this.state).doExport();
            }
        };
        this.export.addActionListener(abstractAction2);
        this.export.getInputMap(2).put(KeyStroke.getKeyStroke('e'), "export");
        this.export.getActionMap().put("export", abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MajGui.this.dotplot) {
                    MajGui.this.maj.closeDotplot(MajGui.this.refseq, MajGui.this.seq2);
                } else {
                    MajGui.this.maj.closeView(MajGui.this.refseq);
                }
            }
        };
        this.close.addActionListener(abstractAction3);
        this.close.getInputMap(2).put(KeyStroke.getKeyStroke('c'), "close");
        this.close.getActionMap().put("close", abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Log.exit(0);
                    }
                });
            }
        };
        this.quit.addActionListener(abstractAction4);
        this.quit.getInputMap(2).put(KeyStroke.getKeyStroke('q'), "quit");
        this.quit.getInputMap(2).put(KeyStroke.getKeyStroke('x'), "quit");
        this.quit.getActionMap().put("quit", abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setSmallFonts();
                MajGui.this.maj.rebuildAllGuis(MajGui.this);
            }
        };
        this.small.addActionListener(abstractAction5);
        this.small.getInputMap(2).put(KeyStroke.getKeyStroke('s'), "small");
        this.small.getActionMap().put("small", abstractAction5);
        AbstractAction abstractAction6 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setLargeFonts();
                MajGui.this.maj.rebuildAllGuis(MajGui.this);
            }
        };
        this.large.addActionListener(abstractAction6);
        this.large.getInputMap(2).put(KeyStroke.getKeyStroke('l'), "large");
        this.large.getActionMap().put("large", abstractAction6);
        AbstractAction abstractAction7 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setMarkMode("red");
                MajGui.this.maj.rebuildAllGuis(MajGui.this);
            }
        };
        this.red.addActionListener(abstractAction7);
        this.red.getInputMap(2).put(KeyStroke.getKeyStroke('r'), "red");
        this.red.getActionMap().put("red", abstractAction7);
        AbstractAction abstractAction8 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setMarkMode("xor");
                MajGui.this.maj.rebuildAllGuis(MajGui.this);
            }
        };
        this.xor.addActionListener(abstractAction8);
        this.xor.getInputMap(2).put(KeyStroke.getKeyStroke('v'), "xor");
        this.xor.getActionMap().put("xor", abstractAction8);
        AbstractAction abstractAction9 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelChooser panelChooser = new PanelChooser(MajGui.this.frame, MajGui.this.maj);
                if (panelChooser.showDialog()) {
                    MajGui.this.maj.global.setShown("posline", panelChooser.posline);
                    MajGui.this.maj.global.setShown("markline", panelChooser.markline);
                    MajGui.this.maj.global.setShown("vis", panelChooser.vis);
                    MajGui.this.maj.global.setShown("ruler", panelChooser.ruler);
                    MajGui.this.maj.global.setShown("recon", panelChooser.recon);
                    MajGui.this.maj.global.setShown("links", panelChooser.links);
                    MajGui.this.maj.global.setShown("exons", panelChooser.exons);
                    MajGui.this.maj.global.setShown("repeats", panelChooser.repeats);
                    MajGui.this.maj.global.setShown("text", panelChooser.text);
                    int n = 0;
                    while (n < MajGui.this.maj.nseq) {
                        MajGui.this.maj.global.setShown(n, panelChooser.pips.get(n));
                        ++n;
                    }
                    MajGui.this.maj.global.setShown("dotunderlay", panelChooser.dotunderlay);
                    MajGui.this.maj.rebuildAllGuis(MajGui.this);
                }
            }
        };
        this.show.addActionListener(abstractAction9);
        this.show.getInputMap(2).put(KeyStroke.getKeyStroke('w'), "show");
        this.show.getActionMap().put("show", abstractAction9);
        int n = 0;
        while (n < this.maj.nseq) {
            final int n2 = n++;
            this.views[n2].addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MajGui.this.maj.displayView(n2, MajGui.this.state, -1, -1);
                }
            });
        }
        AbstractAction abstractAction10 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.state.zt.backZoom();
                MajGui.this.content.repaint();
            }
        };
        this.backzoom.addActionListener(abstractAction10);
        this.backzoom.getInputMap(2).put(KeyStroke.getKeyStroke('b'), "backzoom");
        this.backzoom.getActionMap().put("backzoom", abstractAction10);
        AbstractAction abstractAction11 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.state.zt.forwardZoom();
                MajGui.this.content.repaint();
            }
        };
        this.forwardzoom.addActionListener(abstractAction11);
        this.forwardzoom.getInputMap(2).put(KeyStroke.getKeyStroke('f'), "forwardzoom");
        this.forwardzoom.getActionMap().put("forwardzoom", abstractAction11);
        AbstractAction abstractAction12 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.state.zt.unzoom();
                MajGui.this.content.repaint();
            }
        };
        this.unzoom.addActionListener(abstractAction12);
        this.unzoom.getInputMap(2).put(KeyStroke.getKeyStroke('u'), "unzoom");
        this.unzoom.getActionMap().put("unzoom", abstractAction12);
        AbstractAction abstractAction13 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomChooser zoomChooser = new ZoomChooser(MajGui.this.frame, MajGui.this.maj, MajGui.this.refseq, MajGui.this.dotplot, MajGui.this.seq2);
                if (zoomChooser.showDialog()) {
                    Range range = zoomChooser.newzoomX;
                    Range range2 = MajGui.this.dotplot ? zoomChooser.newzoomY : new Range(0, 0);
                    MajGui.this.state.zt.setZoom(Util.makeRectangle(range, range2));
                    MajGui.this.content.repaint();
                }
            }
        };
        this.newzoom.addActionListener(abstractAction13);
        this.newzoom.getInputMap(2).put(KeyStroke.getKeyStroke('z'), "newzoom");
        this.newzoom.getActionMap().put("newzoom", abstractAction13);
        AbstractAction abstractAction14 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MajGui.this.maj.global.tagcount;
                MajGui.this.maj.global.toggleTag(MajGui.this.state.getMark());
                if (!MajGui.this.maj.global.getShown("vis") && n == 0 && MajGui.this.maj.global.tagcount > 0) {
                    MajGui.this.maj.global.setShown("vis", true);
                    MajGui.this.maj.rebuildAllGuis(MajGui.this);
                }
            }
        };
        this.tag.addActionListener(abstractAction14);
        this.tag.getInputMap(2).put(KeyStroke.getKeyStroke('t'), "tag");
        this.tag.getActionMap().put("tag", abstractAction14);
        AbstractAction abstractAction15 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.maj.global.clearTags();
                if (MajGui.this.maj.global.getShown("vis") && MajGui.this.maj.nmaf < 2) {
                    MajGui.this.maj.global.setShown("vis", false);
                    if (MajGui.this.maj.nmaf == 1) {
                        MajGui.this.maj.global.setShowMaf(0, true);
                    }
                    MajGui.this.maj.global.setShowTagged(true);
                    MajGui.this.maj.rebuildAllGuis(MajGui.this);
                }
            }
        };
        this.clear.addActionListener(abstractAction15);
        this.clear.getInputMap(2).put(KeyStroke.getKeyStroke('\\'), "clear");
        this.clear.getActionMap().put("clear", abstractAction15);
        AbstractAction abstractAction16 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Log.showMessage(PackageInfo.about() + "\n" + "\n" + "[Your current Java:  " + System.getProperty("java.version") + "  from " + System.getProperty("java.vendor") + "]", "About " + Log.programName);
            }
        };
        this.about.addActionListener(abstractAction16);
        this.about.getInputMap(2).put(KeyStroke.getKeyStroke('a'), "about");
        this.about.getActionMap().put("about", abstractAction16);
        AbstractAction abstractAction17 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                IO.showURL(MajGui.this.maj, IO.getDocURL("docs/gmaj_help.html"), "manual");
            }
        };
        this.manual.addActionListener(abstractAction17);
        this.manual.getInputMap(2).put(KeyStroke.getKeyStroke('m'), "manual");
        this.manual.getActionMap().put("manual", abstractAction17);
        AbstractAction abstractAction18 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Log.showMessage((MajGui.this.maj.applet == null ? "o = Open\n" : "") + (MajGui.this.allowExport() ? "e = Export\n" : "") + "c = Close" + "\n" + "q,x = Exit" + "\n" + "s = Small Fonts" + "\n" + "l = Large Fonts" + "\n" + "r = Mark Always Red" + "\n" + "v = Mark Color Varies" + "\n" + "w = Show" + "\n" + "b = Back" + "\n" + "f = Forward" + "\n" + "u = Unzoom" + "\n" + "z = Set Zoom" + "\n" + "t = Tag/Untag Block" + "\n" + "\\ = Clear All Tags" + "\n" + "a = About" + "\n" + "m = Manual" + "\n" + "k = Keys" + "\n" + "i = % Identity threshold" + "\n" + "Shift-\u2191 = Raise % identity threshold" + "\n" + "Shift-\u2193 = Lower % identity threshold" + "\n" + "j = Underlay threshold" + "\n" + "Alt-\u2191 = Raise underlay threshold" + "\n" + "Alt-\u2193 = Lower underlay threshold" + "\n" + "\u2190 = Move left" + "\n" + "\u2192 = Move right" + "\n" + "\u2193 = Move down" + "\n" + "\u2191 = Move up" + "\n" + "n = Next block button" + "\n" + "0-9 = MAF checkboxes" + "\n" + "T = Tagged checkbox" + "\n" + "Ctrl = Freeze location status" + "\n" + "Esc = Cancel; Re-enable keyboard shortcuts", Log.programName + " Keyboard Shortcuts");
            }
        };
        this.keys.addActionListener(abstractAction18);
        this.keys.getInputMap(2).put(KeyStroke.getKeyStroke('k'), "keys");
        this.keys.getActionMap().put("keys", abstractAction18);
        AbstractAction abstractAction19 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Log.showMessage(MajGui.this.maj.bf.sequenceSummary(), "Sequence Summary");
            }
        };
        this.seqsum.addActionListener(abstractAction19);
        this.seqsum.getInputMap(2).put(KeyStroke.getKeyStroke('S'), "seqsum");
        this.seqsum.getActionMap().put("seqsum", abstractAction19);
        this.addLimitListeners(this.ilimit, 0, 'i', 1);
        this.addLimitListeners(this.ulimit, 1, 'j', 8);
    }

    private void addLimitListeners(final JTextField jTextField, final int n, char c, int n2) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                MajGui.this.maj.global.setLimit(n, string);
                MajGui.this.restoreFocus();
            }
        };
        jTextField.addActionListener(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 28 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        28.access$100(this.this$1).requestFocus();
                    }
                });
            }

            static /* synthetic */ JTextField access$100(28 var0) {
                return var0.jTextField;
            }
        };
        jTextField.getInputMap(2).put(KeyStroke.getKeyStroke(c), "focus");
        jTextField.getActionMap().put("focus", abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.maj.global.adjustLimit(n, 1);
                MajGui.this.restoreFocus();
            }
        };
        jTextField.getInputMap(2).put(KeyStroke.getKeyStroke(38, n2), "inc");
        jTextField.getActionMap().put("inc", abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.maj.global.adjustLimit(n, -1);
                MajGui.this.restoreFocus();
            }
        };
        jTextField.getInputMap(2).put(KeyStroke.getKeyStroke(40, n2), "dec");
        jTextField.getActionMap().put("dec", abstractAction4);
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                MajGui.this.syncToState();
            }
        });
    }

    private void addFrameListeners() {
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                Log.setCurrentInstance(MajGui.this.maj);
                Log.setCurrentGuiFrame(MajGui.this.frame);
                MajGui.this.restoreFocus();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 33 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MajGui.access$300(33.access$200(this.this$1), false);
                    }
                });
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                MajGui.this.blockInput(true);
            }

            public void windowClosing(WindowEvent windowEvent) {
                if (MajGui.this.dotplot) {
                    MajGui.this.maj.closeDotplot(MajGui.this.refseq, MajGui.this.seq2);
                } else {
                    MajGui.this.maj.closeView(MajGui.this.refseq);
                }
            }

            static /* synthetic */ MajGui access$200(33 var0) {
                return var0.MajGui.this;
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 35 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        35.access$400(this.this$1).state.setFrameSize(35.access$400(this.this$1).frame.getSize());
                    }
                });
            }

            public void componentMoved(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 35 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        35.access$400(this.this$1).state.setFrameLocation(35.access$400(this.this$1).frame.getLocation());
                    }
                });
            }

            static /* synthetic */ MajGui access$400(35 var0) {
                return var0.MajGui.this;
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MajGui.this.restoreFocus();
            }
        };
        JMenuBar jMenuBar = this.frame.getJMenuBar();
        jMenuBar.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "escape");
        jMenuBar.getActionMap().put("escape", abstractAction);
    }

    public boolean isTextSet() {
        return this.textview.textdata != null;
    }

    public void setText(BlockText blockText) {
        this.textview.setText(blockText);
    }

    public void setHighlights(UnderlayList[] underlayListArray) {
        this.textview.setHighlights(underlayListArray);
    }

    public void setTextMark(MarkInfo markInfo) {
        this.textview.setTextMark(markInfo);
    }

    public void setLoc(String string) {
        this.loc.setText(string);
    }

    public void setInfo(String string, Vector vector, int n) {
        this.info.setText(string);
        this.bselect.setButtons(vector, n);
        this.infopanel.resetToPreferredSizes();
    }

    public void setZinfo(String string) {
        this.zinfo.setText(string);
        if (this.locpanel != null) {
            this.locpanel.resetToPreferredSizes();
        }
    }

    public void syncToState() {
        this.ilimit.setText(Integer.toString(this.maj.global.ilimit));
        this.ulimit.setText(Integer.toString(this.maj.global.ulimit));
        this.vispanel.syncToState();
        this.textview.syncToState();
        this.state.showInfo(this.state.getMark());
        this.content.repaint();
    }

    public void scrollPips(MarkInfo markInfo) {
        if (this.dotplot) {
            return;
        }
        JViewport jViewport = this.scrollpanel.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        try {
            Point point;
            int n;
            int n2;
            int n3;
            if (markInfo == null) {
                n3 = 0;
                n2 = 0;
            } else {
                if (!this.maj.global.getShown(markInfo.seq2)) {
                    return;
                }
                n = this.state.pipForSeq(markInfo.seq2);
                Point point2 = SwingUtilities.convertPoint(this.pipcanvas[n], point = this.pipcanvas[n].getMarkPoint(markInfo), jViewport.getView());
                if (point2 == null) {
                    return;
                }
                n2 = rectangle.x;
                n3 = point2.y < rectangle.y || point2.y > rectangle.y + rectangle.height ? Math.max(point2.y - rectangle.height / 2, 0) : rectangle.y;
            }
            n = 0;
            while (n < 10) {
                jViewport.setViewPosition(new Point(n2, n3));
                point = jViewport.getViewPosition();
                if (point.x != n2 || point.y != n3) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Log.warn("Can't scroll pips to " + (markInfo == null ? "top" : "mark") + ".");
        }
    }

    public void enableWidget(String string, boolean bl) {
        JMenuItem jMenuItem;
        AbstractButton abstractButton = string.equals("backzoom") ? this.backzoom : (string.equals("forwardzoom") ? this.forwardzoom : (string.equals("unzoom") ? this.unzoom : (string.equals("tag") ? this.tag : (string.equals("clear") ? this.clear : (string.equals("left") ? this.left : (string.equals("right") ? this.right : (string.equals("down") ? this.down : (jMenuItem = string.equals("up") ? this.up : null))))))));
        if (jMenuItem != null) {
            ((JComponent)jMenuItem).setEnabled(bl);
        }
    }

    public void restoreFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MajGui.this.frame != null && MajGui.this.frame == Log.currentGuiFrame) {
                    MajGui.this.frame.getJMenuBar().requestFocus();
                }
            }
        });
    }

    private void blockInput(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MajGui.this.glasspane != null) {
                    MajGui.this.glasspane.setVisible(bl);
                }
            }
        });
    }

    public void setBusy(boolean bl) {
        if (bl) {
            if (this.frame != null) {
                this.frame.setCursor(Config.waitCursor);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MajGui.this.frame != null) {
                        MajGui.this.frame.setCursor(Config.arrowCursor);
                    }
                }
            });
        }
    }

    public void close() {
        ((Component)this.frame).setVisible(false);
        this.frame.dispose();
        this.frame = null;
    }
}

