/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.PackageInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class MajApplet
extends JApplet {
    static final String rcsid = "$Revision: 1.13 $$Date: 2008/05/06 18:22:32 $";
    private String specfile;
    private String bundlefile;
    private String buttonlabel = "Open " + Log.programName + " window";
    private boolean nobutton = false;
    private String refname = null;
    private int zstart = -1;
    private int zend = -1;
    private String posturl = null;
    private int urlpause = -1;
    private boolean debug = false;
    private boolean test = false;
    private JButton start;

    public void init() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setup();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        MajApplet.this.setup();
                    }
                });
            }
            catch (Exception exception) {
                Log.err("Setup did not complete.");
            }
        }
    }

    private void setup() {
        this.getParameters();
        if (this.nobutton) {
            this.start = null;
            this.openInstance();
        } else {
            this.start = new JButton(this.buttonlabel);
            this.start.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MajApplet.this.openInstance();
                }
            });
            this.getContentPane().add((Component)this.start, "Center");
        }
        this.validate();
    }

    private void openInstance() {
        if (this.start != null) {
            this.start.setEnabled(false);
        }
        Maj maj = new Maj(this, this.specfile, this.bundlefile, this.refname, this.zstart, this.zend, this.posturl, this.urlpause, this.debug, this.test);
    }

    void closeInstance() {
        if (this.start != null) {
            this.start.setEnabled(true);
        }
    }

    private void getParameters() {
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        this.specfile = IO.getFullUrl(this.getDocumentBase(), this.getParameter("paramfile"));
        this.bundlefile = IO.getFullUrl(this.getDocumentBase(), this.getParameter("bundle"));
        String string5 = this.getParameter("buttonlabel");
        if (string5 != null) {
            this.buttonlabel = string5;
        }
        if ((string4 = this.getParameter("nobutton")) != null) {
            if (string4.equals("true") || string4.equals("false")) {
                this.nobutton = Boolean.valueOf(string4);
            } else {
                Log.err("Invalid parameter: nobutton must be \"true\" or \"false\".");
            }
        }
        if ((string3 = this.getParameter("initzoom")) != null) {
            try {
                object = new StringTokenizer(string3);
                this.refname = ((StringTokenizer)object).nextToken();
                this.zstart = Integer.parseInt(((StringTokenizer)object).nextToken());
                this.zend = Integer.parseInt(((StringTokenizer)object).nextToken());
            }
            catch (NoSuchElementException noSuchElementException) {
                Log.err("Invalid parameter: not enough tokens for initzoom.");
                this.zend = -1;
                this.zstart = -1;
            }
            catch (NumberFormatException numberFormatException) {
                Log.err("Invalid parameter: initzoom start/end must be integers.");
                this.zend = -1;
                this.zstart = -1;
            }
            if (this.zstart <= 0 && this.zstart != -1 || this.zend <= 0 && this.zend != -1) {
                Log.err("Invalid parameter: initzoom start/end must either be -1, or > 0.");
                this.zend = -1;
                this.zstart = -1;
            }
        }
        this.posturl = IO.getFullUrl(this.getDocumentBase(), this.getParameter("posturl"));
        object = this.getParameter("urlpause");
        if (object != null) {
            try {
                this.urlpause = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                Log.err("Invalid parameter: urlpause must be an integer.");
            }
            if (this.urlpause < 0) {
                Log.err("Invalid parameter: urlpause must be >= 0.");
                this.urlpause = -1;
            }
        }
        if ((string2 = this.getParameter("debug")) != null) {
            if (string2.equals("true") || string2.equals("false")) {
                this.debug = Boolean.valueOf(string2);
            } else {
                Log.err("Invalid parameter: debug must be \"true\" or \"false\".");
            }
        }
        if ((string = this.getParameter("test")) != null) {
            if (string.equals("true") || string.equals("false")) {
                this.test = Boolean.valueOf(string);
            } else {
                Log.err("Invalid parameter: test must be \"true\" or \"false\".");
            }
        }
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"paramfile", "URL", "file with dataset parameters"}, {"bundle", "URL", "zip or jar containing data files"}, {"buttonlabel", "string", "label for start button"}, {"nobutton", "boolean", "no start button; launch immed."}, {"initzoom", "string int int", "initial display: refseq start end"}, {"posturl", "URL", "where to send exported alignments"}, {"urlpause", "int", "millisec pause before each fetch"}, {"debug", "boolean", "verbose mode"}};
        return stringArray;
    }

    public String getAppletInfo() {
        return PackageInfo.about();
    }
}

