/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BailoutException;
import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.DataCloset;
import edu.psu.bx.gmaj.GlobalState;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.InputSpecs;
import edu.psu.bx.gmaj.Killable;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.MajApplet;
import edu.psu.bx.gmaj.MajGui;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MultiFileChooser;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.View;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Maj
implements Killable {
    static final String rcsid = "$Revision: 1.63 $$Date: 2008/06/20 21:46:51 $";
    static final String[] PROMPTS = new String[]{Log.programName + " parameters file (or alignment file):", "Or, a zipped bundle containing the data files (see documentation):"};
    MajApplet applet;
    String specfile;
    String bundlefile;
    InputSpecs specs;
    DataCloset closet;
    BlockFile bf;
    int nmaf;
    int nseq;
    View[] views;
    MajGui[] guis;
    MajGui[][] dpguis;
    MajState[] states;
    MajState[][] dpstates;
    GlobalState global;
    URL postUrl;
    private JDialog wait;

    public Maj(MajApplet majApplet, String string, String string2, final String string3, final int n, final int n2, final String string4, int n3, boolean bl, boolean bl2) {
        Log.setCurrentInstance(this);
        this.applet = majApplet;
        this.specfile = string;
        this.bundlefile = string2;
        this.specs = null;
        this.closet = null;
        this.bf = null;
        this.global = new GlobalState(this, n3, bl, bl2);
        this.postUrl = null;
        this.wait = null;
        Config.setSmallFonts();
        Config.setMarkMode("red");
        MajGui.setDefaults();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Maj.this.showWaitDialog(true);
                Maj.this.setup(string3, n, n2, string4);
                Maj.this.showWaitDialog(false);
            }
        });
    }

    private void setup(String string, int n, int n2, String string2) {
        int n3;
        if (this.global.test) {
            Log.testWrap(this);
        }
        if (this.specfile.equals("") && this.bundlefile.equals("") && this.applet == null) {
            MultiFileChooser multiFileChooser = this.getChooser(this.specfile, this.bundlefile);
            String[] stringArray = multiFileChooser.showDialog();
            if (stringArray == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Log.exit(0);
                    }
                });
                return;
            }
            this.specfile = stringArray[0];
            this.bundlefile = stringArray[1];
        }
        if (this.specfile.equals("") && this.bundlefile.equals("")) {
            Log.showError("No input file specified.");
            Log.exit(1);
        }
        if (!this.specfile.equals("")) {
            this.specs = new InputSpecs(this, this.specfile);
            this.closet = new DataCloset(this.specs);
            this.bf = new BlockFile(this.specs);
        }
        if (!this.bundlefile.equals("")) {
            this.loadBundledData();
        }
        this.bf.loadFromSpecs();
        this.nmaf = this.bf.mafnames.size();
        this.nseq = this.bf.seqrefs.size();
        this.views = new View[this.nseq];
        int n4 = 0;
        while (n4 < this.nseq) {
            this.views[n4] = new View(this, n4);
            ++n4;
        }
        this.guis = new MajGui[this.nseq];
        this.dpguis = new MajGui[this.nseq][this.nseq];
        this.states = new MajState[this.nseq];
        this.dpstates = new MajState[this.nseq][this.nseq];
        this.global.setup();
        try {
            this.postUrl = string2 == null || string2.equals("") ? null : new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            Log.showError("Bad URL for exporting alignments:\n" + string2);
        }
        int n5 = this.bf.seqno(this.specs.getRefSeq());
        if (n5 < 0 && !this.specs.getRefSeq().equals("any")) {
            Log.showError("Invalid refseq value in parameters file: no such sequence.");
            Log.exit(1);
        }
        if ((n3 = this.bf.seqno(this.specs.resolveAlias(string))) < 0) {
            if (string != null) {
                Log.err("Invalid initzoom parameter: no such sequence.");
            }
            n3 = n5 >= 0 ? n5 : 0;
            n2 = -1;
            n = -1;
        } else if (n5 >= 0 && n3 != n5) {
            Log.err("Invalid initzoom sequence: parameters file restricts refseq.");
            n3 = n5;
            n2 = -1;
            n = -1;
        }
        this.displayView(n3, null, n, n2);
    }

    private void loadBundledData() {
        String string;
        if (this.specs != null && !this.specs.usingSpecs()) {
            Log.showError("Can't use bundle file and command-line MAF together.");
            Log.exit(1);
        }
        if ((string = IO.getFullName(this.bundlefile)) == null) {
            string = "";
        }
        try {
            BufferedReader bufferedReader;
            String string2;
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = (ZipInputStream)IO.getStream(string);
            if (this.specs == null) {
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null) {
                    Log.showError("Bundle file is empty.");
                    Log.exit(1);
                }
                string2 = IO.pathlessName(zipEntry.getName());
                bufferedReader = IO.getReader(zipInputStream, string2);
                this.specs = new InputSpecs(this, string2, bufferedReader);
                this.closet = new DataCloset(this.specs);
                this.bf = new BlockFile(this.specs);
                zipInputStream.closeEntry();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                string2 = IO.pathlessName(zipEntry.getName());
                bufferedReader = IO.getReader(zipInputStream, string2);
                BitSet bitSet = this.specs.inferTypes(string2);
                int n = Util.countSetBits(bitSet);
                if (n == 0) {
                    Log.showWarning("Warning:\nBundle entry \"" + string2 + "\" is not used in parameters file.");
                    continue;
                }
                if (n == 1 && bitSet.get(0)) {
                    this.bf.loadFile(string2, bufferedReader);
                } else {
                    this.closet.loadBundledFile(string2, bitSet, bufferedReader);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (ClassCastException classCastException) {
            Log.showError("Error loading bundled data from \"" + string + "\":" + "\n" + "not a .zip or .jar file.");
            Log.exit(1);
        }
        catch (IOException iOException) {
            Log.showError("Error loading bundled data from \"" + string + "\":" + "\n" + iOException);
            Log.exit(1);
        }
    }

    public void displayView(int n, MajState majState, int n2, int n3) {
        if (this.guis[n] == null) {
            Rectangle rectangle;
            Range range;
            this.views[n].activate();
            MajState majState2 = this.states[n] = new MajState(this, n);
            if (majState != null) {
                majState2.setMark(majState.getMark());
            }
            if ((range = this.bf.getExtent(n)) == null) {
                Log.showWarning("Warning:\nSequence \"" + this.bf.seqname(n) + "\" has no alignments.");
            } else {
                range = range.pad(0.05).intersect(this.bf.getBounds(n));
                majState2.zt.setZoom(Util.makeRectangle(range, new Range(0, 0)));
            }
            if (n2 > -1 || n3 > -1) {
                int n4 = this.specs.getOffset(n);
                if (majState2.zt.isValidZoom(n2 -= n4, n3 -= n4, true, false)) {
                    majState2.zt.setZoom(Util.makeRectangle(new Range(n2, n3), new Range(0, 0)));
                }
            } else if (majState != null && (rectangle = majState.convertZoom(n, -1)) != null) {
                majState2.zt.setZoom(rectangle);
            }
            this.guis[n] = new MajGui(this, n);
        } else if (this.nseq != 2) {
            this.guis[n].frame.show();
        }
        if (this.nseq == 2) {
            this.displayDotplot(n, 1 - n, this.states[n]);
        }
    }

    public void displayDotplot(int n, int n2, MajState majState) {
        if (!this.global.getShown(n2)) {
            Log.fatalBug("Maj.displayDotplot(): Plots vs. sequence \"" + n2 + "\" are hidden.");
        }
        if (this.dpguis[n][n2] == null) {
            Rectangle rectangle;
            this.views[n].activate();
            MajState majState2 = new MajState(this, n, true, n2);
            this.dpstates[n][n2] = majState2;
            MajState majState3 = majState2;
            Rectangle rectangle2 = this.views[n].plots[n2].getExtent();
            if (rectangle2 == null) {
                Log.showWarning("Warning:\nDotplot of \"" + this.bf.seqname(n) + "\" vs. \"" + this.bf.seqname(n2) + "\" has no alignments.");
            } else {
                rectangle2 = Util.padRectangle(rectangle2, 0.05);
                majState3.zt.setZoom(Util.intersect(rectangle2, majState3.zt.bounds));
            }
            if (majState != null && (rectangle = majState.convertZoom(n, n2)) != null) {
                majState3.zt.setZoom(rectangle);
            }
            this.dpguis[n][n2] = new MajGui(this, n, true, n2);
        } else {
            this.dpguis[n][n2].frame.show();
        }
    }

    public void closeView(int n) {
        final int n2 = n;
        int n3 = 0;
        while (n3 < this.nseq) {
            this.closeDotplot(n2, n3);
            ++n3;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Maj.this.guis[n2] != null) {
                    Maj.this.guis[n2].close();
                    Maj.this.guis[n2] = null;
                    Maj.this.states[n2] = null;
                    Maj.this.views[n2].deactivate();
                }
                if (Maj.this.noneLeft()) {
                    Log.exit(0);
                }
            }
        });
    }

    public void closeDotplot(int n, int n2) {
        final int n3 = n;
        final int n4 = n2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (Maj.this.dpguis[n3][n4] != null) {
                    Maj.this.dpguis[n3][n4].close();
                    Maj.this.dpguis[n3][n4] = null;
                    Maj.this.dpstates[n3][n4] = null;
                }
                if (Maj.this.noneLeft()) {
                    Log.exit(0);
                }
            }
        });
    }

    private boolean noneLeft() {
        int n = 0;
        while (n < this.nseq) {
            if (this.guis[n] != null && this.guis[n].frame.isVisible()) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.nseq) {
                if (this.dpguis[n][n2] != null && this.dpguis[n][n2].frame.isVisible()) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public void repaintAllGuis(boolean bl) {
        int n = 0;
        while (n < this.nseq) {
            if (this.guis[n] != null) {
                Util.repaint(this.guis[n].content, bl);
            }
            int n2 = 0;
            while (n2 < this.nseq) {
                if (this.dpguis[n][n2] != null) {
                    Util.repaint(this.dpguis[n][n2].content, bl);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void syncAllGuis() {
        int n = 0;
        while (n < this.nseq) {
            if (this.guis[n] != null) {
                this.guis[n].syncToState();
            }
            int n2 = 0;
            while (n2 < this.nseq) {
                if (this.dpguis[n][n2] != null) {
                    this.dpguis[n][n2].syncToState();
                }
                ++n2;
            }
            ++n;
        }
        this.global.redoLastMove();
    }

    public void rebuildAllGuis(final MajGui majGui) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MajGui.setDefaults();
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                while (n3 < Maj.this.nseq) {
                    if (Maj.this.guis[n3] != null) {
                        if (Maj.this.guis[n3] == majGui) {
                            n2 = n3;
                        } else {
                            Maj.this.guis[n3].close();
                            Maj.this.guis[n3] = new MajGui(Maj.this, n3);
                        }
                    }
                    int n4 = 0;
                    while (n4 < Maj.this.nseq) {
                        if (Maj.this.dpguis[n3][n4] != null) {
                            if (Maj.this.dpguis[n3][n4] == majGui) {
                                n2 = n3;
                                n = n4;
                            } else {
                                Maj.this.dpguis[n3][n4].close();
                                Maj.this.dpguis[n3][n4] = new MajGui(Maj.this, n3, true, n4);
                            }
                        }
                        ++n4;
                    }
                    ++n3;
                }
                if (n2 >= 0) {
                    if (n >= 0) {
                        Maj.this.dpguis[n2][n].close();
                        Maj.this.dpguis[n2][n] = new MajGui(Maj.this, n2, true, n);
                    } else {
                        Maj.this.guis[n2].close();
                        Maj.this.guis[n2] = new MajGui(Maj.this, n2);
                    }
                }
                if (Maj.this.noneLeft()) {
                    Log.showWarning("Warning:\nThere are no plots left; " + Log.programName + " is exiting.");
                    Log.exit(0);
                }
            }
        });
    }

    private void closeAllGuis() {
        final MajGui[] majGuiArray = this.guis;
        final MajGui[][] majGuiArray2 = this.dpguis;
        final int n = this.nseq;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n3;
                if (majGuiArray != null) {
                    n3 = 0;
                    while (n3 < n) {
                        if (majGuiArray[n3] != null) {
                            majGuiArray[n3].close();
                        }
                        ++n3;
                    }
                }
                if (majGuiArray2 != null) {
                    n3 = 0;
                    while (n3 < n) {
                        int n2 = 0;
                        while (n2 < n) {
                            if (majGuiArray2[n3][n2] != null) {
                                majGuiArray2[n3][n2].close();
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                }
            }
        });
    }

    public final void loadNewData() {
        MultiFileChooser multiFileChooser;
        String[] stringArray;
        if (this.applet != null) {
            Log.fatalBug("Maj.loadNewData(): Not available for applet.");
        }
        if ((stringArray = (multiFileChooser = this.getChooser(this.specfile, this.bundlefile)).showDialog()) == null) {
            return;
        }
        this.closeAllGuis();
        this.showWaitDialog(false);
        Log.setCurrentGuiFrame(null);
        Log.setCurrentInstance(null);
        Maj maj = new Maj(this.applet, stringArray[0], stringArray[1], null, -1, -1, this.postUrl == null ? null : this.postUrl.toString(), this.global.urlPause, this.global.verbose, this.global.test);
    }

    private MultiFileChooser getChooser(String string, String string2) {
        return new MultiFileChooser(null, "Load Data Files", PROMPTS, new String[]{string, string2});
    }

    private void showWaitDialog(boolean bl) {
        if (bl && this.applet != null) {
            this.wait = new JDialog((Frame)null, "Please wait", false);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Config.backgroundColor);
            jPanel.setBorder(Config.waitBorder);
            JLabel jLabel = new JLabel("Please wait, loading data ...");
            jLabel.setFont(Config.waitFont);
            jPanel.add(jLabel);
            this.wait.setContentPane(jPanel);
            this.wait.setCursor(Config.waitCursor);
            this.wait.pack();
            this.wait.setLocationRelativeTo(null);
            ((Component)this.wait).setVisible(true);
            this.refreshWaitDialog();
        } else if (!bl && this.wait != null) {
            ((Component)this.wait).setVisible(false);
            this.wait.dispose();
            this.wait = null;
        }
    }

    public void refreshWaitDialog() {
        if (this.wait != null) {
            JPanel jPanel = (JPanel)this.wait.getContentPane();
            int n = 0;
            while (n < 10) {
                Util.sleep(1);
                jPanel.paintImmediately(jPanel.getBounds(null));
                ++n;
            }
        }
    }

    public void setBusy(boolean bl) {
        int n = 0;
        while (n < this.nseq) {
            if (this.states != null && this.states[n] != null) {
                this.states[n].setBusy(bl);
            }
            if (this.dpstates != null) {
                int n2 = 0;
                while (n2 < this.nseq) {
                    if (this.dpstates[n][n2] != null) {
                        this.dpstates[n][n2].setBusy(bl);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void kill(int n) {
        if (this.applet != null) {
            this.closeAllGuis();
            this.showWaitDialog(false);
            Log.setCurrentGuiFrame(null);
            Log.setCurrentInstance(null);
            this.applet.closeInstance();
            if (n > 0) {
                throw new BailoutException("Gmaj invocation finished.");
            }
        } else {
            System.exit(n);
        }
    }
}

