/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Block;
import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.ReconScores;
import edu.psu.bx.gmaj.SeqRef;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MafReader {
    static final String rcsid = "$Revision: 1.24 $$Date: 2008/06/11 01:59:42 $";
    private BlockFile bf;
    private int mafno;
    private int bno;
    private String reconorg;

    public MafReader(String string, BufferedReader bufferedReader, BlockFile blockFile, int n) throws IOException {
        Block block;
        this.bf = blockFile;
        this.mafno = n;
        this.bno = 0;
        this.reconorg = blockFile.specs.getReconOrg();
        this.checkMafVersion(string);
        while ((block = this.blockFromReader(bufferedReader)) != null) {
            if (block.ncols < 0) continue;
            ++this.bno;
            block.bno = block.bno;
            blockFile.blocks.addElement(block);
        }
    }

    private void checkMafVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().equals("version=1")) continue;
            return;
        }
        Log.showWarning("maf_version", "Warning:\nAssuming MAF version is actually \"1\", e.g. in\n" + string);
    }

    private Block blockFromReader(BufferedReader bufferedReader) throws IOException {
        int n;
        Enumeration<Object> enumeration;
        Object object;
        String string = IO.getNonemptyLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (!Util.firstWord(string).equals("a")) {
            Log.showWarning("maf_paragraph", "Warning:\nSkipping non-\"a\" paragraph(s) in MAF file.");
            while ((string = bufferedReader.readLine()) != null && !string.trim().equals("")) {
            }
            return string == null ? null : new Block(this.bf, this.mafno, -1, -1);
        }
        Block block = new Block(this.bf, this.mafno, -1, -1);
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            int n3;
            String string2;
            int n4;
            boolean bl;
            int n5;
            int n6;
            String string3;
            if (string.trim().equals("")) break;
            if (string.trim().startsWith("#") || ((String)(object = ((StringTokenizer)(enumeration = new StringTokenizer(string))).nextToken())).equals("i") || ((String)object).equals("e")) continue;
            if (!((String)object).equals("s")) {
                Log.showWarning("maf_" + (String)object, "Warning:\nSkipping unrecognized line type \"" + (String)object + "\" in MAF file.");
                continue;
            }
            try {
                string3 = ((StringTokenizer)enumeration).nextToken();
                n6 = Integer.parseInt(((StringTokenizer)enumeration).nextToken());
                n5 = Integer.parseInt(((StringTokenizer)enumeration).nextToken());
                bl = !((StringTokenizer)enumeration).nextToken().equals("+");
                n4 = Integer.parseInt(((StringTokenizer)enumeration).nextToken());
                string2 = ((StringTokenizer)enumeration).nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new BadInputException("Not enough tokens:\n" + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadInputException("Cannot parse integer:\n" + string);
            }
            if (((StringTokenizer)enumeration).hasMoreTokens()) {
                throw new BadInputException("Too many tokens:\n" + string);
            }
            if ((string3 = this.bf.specs.resolveAlias(string3)).endsWith("~")) {
                throw new BadInputException(Log.programName + " does not support sequence names ending with \"" + "~" + "\"," + "\n" + "because it uses that suffix internally" + " to indicate self-alignments." + "\n" + string);
            }
            if (this.bf.self == 0 && !Config.isReconRow(string3)) {
                if (block.rows.isEmpty()) {
                    this.bf.selfname = string3;
                } else {
                    int n7 = this.bf.self = string3.equals(this.bf.selfname) ? 1 : -1;
                }
            }
            if (this.bf.self > 0 && !Config.isReconRow(string3)) {
                if (!string3.equals(this.bf.selfname)) {
                    throw new BadInputException("MAF file appears to be a self-alignment of \"" + this.bf.selfname + "\"," + "\n" + "but block " + this.bname() + " includes a different sequence name:" + "\n" + string);
                }
                if (!block.rows.isEmpty()) {
                    string3 = string3 + "~";
                }
            }
            if ((n = this.getSeqno(string3, n4, string)) < -1) continue;
            if (n < 0 && this.reconorg.equals("none")) {
                Log.showWarning("recon_noseq", "Warning:\nSkipping reconstruction annotations; no sequence specified.");
                continue;
            }
            if (block.ncols < 0) {
                block.ncols = string2.length();
            } else if (string2.length() != block.ncols) {
                throw new BadInputException("Row length does not match previous rows:\n" + string);
            }
            int n8 = 0;
            if (n >= 0) {
                int n9 = 0;
                while (n9 < string2.length()) {
                    char c = string2.charAt(n9);
                    if (c == '-') {
                        ++n8;
                    } else if (!Character.isLetter(c)) {
                        throw new BadInputException("Invalid character '" + c + "' in block " + this.bno + ":" + "\n" + string);
                    }
                    ++n9;
                }
            }
            if (n5 + n8 != string2.length()) {
                throw new BadInputException("Segment length contradiction:\n" + string + "\n" + "stated = " + n5 + "; count = " + (string2.length() - n8) + ".");
            }
            if (bl) {
                n3 = n4 - n6;
                n2 = n3 - n5 + 1;
            } else {
                n3 = n6 + 1;
                n2 = n3 + n5 - 1;
            }
            Range range = new Range(1, n4);
            if (!range.contains(n3) || !range.contains(n2) && n >= 0) {
                throw new BadInputException("Sequence coordinate outside stated range:\n" + string);
            }
            if (n >= 0) {
                block.append(new BlockRow(n, bl, n3, n2, string2));
                continue;
            }
            this.addReconAnnot(block, string3, bl, n4, string2, n3, n2, string);
        }
        block.rows.trimToSize();
        Collections.sort(block.rows, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((BlockRow)object).seqno;
                int n2 = ((BlockRow)object2).seqno;
                return n < n2 ? -1 : (n > n2 ? 1 : 0);
            }
        });
        if (this.bf.self == 0) {
            this.bf.self = -1;
        }
        if (this.bf.self > 0 && block.rows.size() != 2) {
            throw new BadInputException("MAF file appears to be a self-alignment,\nbut block " + this.bname() + " is not pairwise.");
        }
        n = -1;
        enumeration = block.rows.elements();
        while (enumeration.hasMoreElements()) {
            object = (BlockRow)enumeration.nextElement();
            if (((BlockRow)object).seqno < n) {
                Log.fatalBug("MafReader.blockFromReader(): Rows are not sorted.");
                continue;
            }
            if (((BlockRow)object).seqno == n) {
                throw new BadInputException("MAF file does not appear to be a self-alignment,\nbut block " + this.bname() + " has duplicate sequence names.");
            }
            n = ((BlockRow)object).seqno;
        }
        if (block.ncols < 0) {
            block.ncols = 0;
        }
        return block;
    }

    private int getSeqno(String string, int n, String string2) throws BadInputException {
        if (Config.isReconRow(string)) {
            return -1;
        }
        int n2 = 0;
        while (n2 < this.bf.seqrefs.size()) {
            SeqRef seqRef = this.bf.seqref(n2);
            if (seqRef != null && seqRef.filename.equals(string)) {
                if (n != seqRef.len) {
                    throw new BadInputException("Sequence length contradiction:\n" + string2 + "\n" + "current = " + n + "; previous = " + seqRef.len + ".");
                }
                return n2;
            }
            ++n2;
        }
        n2 = this.bf.specs.getSeqno(string);
        if (n2 < 0) {
            if (this.bf.specs.getSkipOtherSeq()) {
                return -2;
            }
            for (n2 = 0; this.bf.specs.isSeqUsed(n2) || n2 < this.bf.seqrefs.size() && this.bf.seqref(n2) != null; ++n2) {
            }
        }
        if (n2 >= this.bf.seqrefs.size()) {
            this.bf.seqrefs.setSize(n2 + 1);
            this.bf.scores.setSize(n2 + 1);
        }
        if (this.bf.seqrefs.set(n2, new SeqRef(string, "", n)) != null) {
            Log.fatalBug("MafReader.getSeqno(): Seqno already in use.");
        }
        this.bf.scores.set(n2, new Hashtable());
        return n2;
    }

    private void addReconAnnot(Block block, String string, boolean bl, int n, String string2, int n2, int n3, String string3) throws BadInputException {
        Hashtable hashtable;
        Vector<ReconScores> vector;
        Vector vector2 = block.orgRows(this.reconorg);
        if (vector2.size() == 0) {
            Log.warn("Encountered \"" + string + "\" row before row for \"" + this.reconorg + "\" in block " + this.bname() + "." + "\n" + string3);
            Log.showWarning("recon_missing", "Warning:\nSkipping reconstruction annotations for blocks where the \"" + this.reconorg + "\" row is missing or late.");
            return;
        }
        if (vector2.size() > 1) {
            throw new BadInputException("Multiple rows for reconstructed sequence \"" + this.reconorg + "\" in block " + this.bname() + "." + "\n" + string3);
        }
        BlockRow blockRow = (BlockRow)vector2.firstElement();
        SeqRef seqRef = this.bf.seqref(blockRow.seqno);
        if (n != seqRef.len) {
            throw new BadInputException("Sequence length mismatch in block " + this.bname() + ":" + "\n" + string3 + "\n" + "\"" + string + "\": " + n + "; \"" + this.reconorg + "\": " + seqRef.len + ".");
        }
        if (bl != blockRow.reverseComp) {
            throw new BadInputException("Reverse complement mismatch in block " + this.bname() + ":" + "\n" + string3 + "\n" + "\"" + string + "\": " + bl + "; \"" + this.reconorg + "\": " + blockRow.reverseComp + ".");
        }
        if (n2 != blockRow.start) {
            throw new BadInputException("Start point mismatch in block " + this.bname() + ":" + "\n" + string3 + "\n" + "\"" + string + "\": " + n2 + "; \"" + this.reconorg + "\": " + blockRow.start + ".");
        }
        int n4 = blockRow.text.length() - (Math.abs(blockRow.end - blockRow.start) + 1);
        Range range = new Range(1, n);
        if (!range.contains(n3 += bl ? n4 : -n4)) {
            throw new BadInputException("Sequence end point outside stated range:\n" + string3);
        }
        if (n3 != blockRow.end) {
            throw new BadInputException("End point mismatch in block " + this.bname() + ":" + "\n" + string3 + "\n" + "\"" + string + "\": " + n3 + "; \"" + this.reconorg + "\": " + blockRow.end + ".");
        }
        float[] fArray = new float[Math.abs(n3 - n2) + 1];
        int n5 = 0;
        int n6 = 0;
        while (n6 < string2.length()) {
            if (blockRow.text.charAt(n6) != '-') {
                fArray[n5++] = (float)(string2.charAt(n6) - 33) / 93.0f;
            }
            ++n6;
        }
        if (n5 != fArray.length) {
            Log.fatalBug("MafReader.addReconAnnot(): Bad array length.");
        }
        if ((vector = (Vector<ReconScores>)(hashtable = (Hashtable)this.bf.scores.elementAt(blockRow.seqno)).get(string)) == null) {
            vector = new Vector<ReconScores>();
            hashtable.put(string, vector);
        }
        vector.addElement(new ReconScores(n2, n3, fArray));
    }

    private String bname() {
        return this.mafno + "." + this.bno;
    }
}

