/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.GlobalState;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Killable;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.PackageInfo;
import edu.psu.bx.gmaj.Util;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public final class Log {
    static final String rcsid = "$Revision: 1.20 $$Date: 2008/06/11 01:59:42 $";
    static String programName = PackageInfo.program;
    static Killable currentInstance = null;
    static JFrame currentGuiFrame = null;

    static void setProgramName(String string) {
        if (!string.equals(PackageInfo.program)) {
            Log.showWarning("Program name \"" + string + "\" does not match" + "\n" + "\"" + PackageInfo.program + "\" in package manifest.");
        }
        programName = string;
    }

    static void setCurrentInstance(Killable killable) {
        currentInstance = killable;
    }

    static void setCurrentGuiFrame(JFrame jFrame) {
        currentGuiFrame = jFrame;
    }

    static boolean haveGui() {
        return !Thread.currentThread().getName().equals("main");
    }

    static void showMessage(String string, String string2, String string3) {
        if (currentInstance == null || !Log.getGlobal().dejaVu(string)) {
            Log.showMessage(string2, string3);
        }
    }

    static void showMessage(String string, String string2) {
        if (Log.haveGui()) {
            String string3 = Util.wrapAtWords(string, 120, "\n");
            MultiLineLabel multiLineLabel = new MultiLineLabel(string3 + "\n", null);
            JScrollPane jScrollPane = new JScrollPane(multiLineLabel);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (currentGuiFrame != null) {
                Rectangle rectangle = currentGuiFrame.getGraphicsConfiguration().getBounds();
                int n = (int)((double)rectangle.height * Math.pow(0.9, 2.0));
                Dimension dimension = jScrollPane.getPreferredSize();
                jScrollPane.setPreferredSize(new Dimension(dimension.width + 60, Math.min(dimension.height, n)));
            }
            JOptionPane.showMessageDialog(currentGuiFrame, jScrollPane, string2, 1);
            Log.refreshWaitDialog();
        } else {
            Log.err(string);
        }
    }

    static void showError(String string, String string2) {
        if (currentInstance == null || !Log.getGlobal().dejaVu(string)) {
            Log.showError(string2);
        }
    }

    static void showError(String string) {
        if (Log.haveGui()) {
            String string2 = Util.wrapAtWords(string, 120, "\n");
            JOptionPane.showMessageDialog(currentGuiFrame, new MultiLineLabel(string2 + "\n", null), "Error", 0);
            Log.refreshWaitDialog();
            Log.setBusy(false);
        } else {
            Log.err(string);
        }
    }

    static void showWarning(String string, String string2, String string3, String string4) {
        Log.showWarning(string, string2, string3, string4, null);
    }

    static void showWarning(String string, String string2, String string3, String string4, Exception exception) {
        if (string4 != null) {
            string2 = string2 + ", e.g.\n\n" + (string3 != null ? "[" + string3 + "]" + "\n" : "") + Util.replaceTabs(string4);
        }
        if (exception != null) {
            string2 = string2 + "\n\n" + exception;
        }
        Log.showWarning(string, "Warning:\n" + string2);
    }

    static void showWarning(String string, String string2) {
        if (currentInstance == null || !Log.getGlobal().dejaVu(string)) {
            Log.showWarning(string2 + "\n" + "\n" + "[keyword = " + string + "]");
        }
    }

    static void showWarning(String string) {
        if (Log.haveGui()) {
            String string2 = Util.wrapAtWords(string, 120, "\n");
            if (!string2.endsWith("]")) {
                string2 = string2 + "\n";
            }
            JOptionPane.showMessageDialog(currentGuiFrame, new MultiLineLabel(string2, null), "Warning", 2);
            Log.refreshWaitDialog();
            Log.setBusy(false);
        } else {
            Log.err(string);
        }
    }

    static boolean requestConfirm(String string, String string2) {
        if (currentInstance != null && Log.getGlobal().dejaVu(string, false)) {
            return true;
        }
        boolean bl = Log.requestConfirm(string2 + "\n" + "\n" + "[keyword = " + string + "]");
        if (currentInstance != null && bl) {
            Log.getGlobal().dejaVu(string);
        }
        return bl;
    }

    static boolean requestConfirm(String string) {
        if (Log.haveGui()) {
            String string2 = Util.wrapAtWords(string, 120, "\n");
            if (!string2.endsWith("]")) {
                string2 = string2 + "\n";
            }
            int n = JOptionPane.showConfirmDialog(currentGuiFrame, new MultiLineLabel(string2, null), "Warning", 2, 2);
            Log.refreshWaitDialog();
            return n == 0;
        }
        return false;
    }

    static void err(String string) {
        System.err.println();
        System.err.println(string.startsWith("Usage:") ? string : programName + ": " + string);
        System.err.flush();
    }

    static void warn(String string) {
        if (currentInstance == null || Log.getGlobal().verbose) {
            Log.err(string);
        }
    }

    static void fatalBug(String string) {
        String string2 = "\n>>> " + Util.toCap(programName) + " has detected the following internal error:" + "\n" + "\n";
        String string3 = "\n\nThis is probably due to a bug in " + programName + " --" + "\n" + "please report it to <cathy+" + programName.toLowerCase() + "@bio.cse.psu.edu>." + "\n" + "It will help if you can include your input files" + "\n" + "and describe what you were trying to do when the" + "\n" + "error occurred.  Thanks!" + "\n";
        Log.err(string2 + string + string3);
        Log.exit(1);
    }

    static void exit(int n) {
        if (currentInstance != null) {
            currentInstance.kill(n);
            currentInstance = null;
        }
    }

    static GlobalState getGlobal() {
        if (currentInstance != null) {
            return ((Maj)Log.currentInstance).global;
        }
        Log.fatalBug("Log.getGlobal(): Current instance is null.");
        return null;
    }

    static void setBusy(boolean bl) {
        if (currentInstance != null) {
            currentInstance.setBusy(bl);
        }
    }

    private static void refreshWaitDialog() {
        if (currentInstance != null) {
            currentInstance.refreshWaitDialog();
        }
    }

    static void testWrap(Maj maj) {
        Object object;
        Log.showMessage("The quick brown fox jumps over the lazy dog.", "Test Message");
        String string = "http://globin.bx.psu.edu/foo";
        try {
            object = IO.getReader(string);
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            Log.showError("Error reading file \"" + string + "\":" + "\n" + exception);
            Log.showWarning("Error reading file \"" + string + "\":" + "\n" + exception);
        }
        object = "http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=11114294&dopt=Abstract";
        String string2 = "httx://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=11114294&dopt=Abstract";
        try {
            IO.showURL(maj, new URL((String)object), "test");
            IO.showURL(maj, new URL(string2), "test");
        }
        catch (MalformedURLException malformedURLException) {
            Log.showError("Malformed URL \"" + string2 + "\":" + "\n" + malformedURLException);
        }
    }
}

