/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Linkbar;
import edu.psu.bx.gmaj.LinkbarList;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.ZoomPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

class LinkbarPane
extends ZoomPane {
    static final String rcsid = "$Revision: 1.11 $$Date: 2007/07/04 14:48:18 $";
    LinkbarList links;
    int rowHeight;
    int thickness;

    LinkbarPane(Maj maj, MajState majState, LinkbarList linkbarList) {
        super(maj, majState, 0, linkbarList.numRows * 6);
        this.links = linkbarList;
        this.rowHeight = 6;
        this.thickness = 3;
    }

    void paintContents(Graphics graphics) {
        this.paintLinkbars(graphics);
    }

    private void paintLinkbars(Graphics graphics) {
        Rectangle rectangle = this.state.zt.getZoom();
        Enumeration enumeration = this.links.regions.elements();
        while (enumeration.hasMoreElements()) {
            Linkbar linkbar = (Linkbar)enumeration.nextElement();
            if (!Util.overlaps(linkbar.start, linkbar.end, rectangle.x, rectangle.x + rectangle.width)) continue;
            this.paintLinkbar(graphics, linkbar);
        }
    }

    void paintLinkbar(Graphics graphics, Linkbar linkbar) {
        Rectangle rectangle = this.state.zt.getZoom();
        int n = this.w2s.transformX(Util.clamp(rectangle.x, linkbar.start, rectangle.x + rectangle.width));
        int n2 = this.w2s.transformX(Util.clamp(rectangle.x, linkbar.end, rectangle.x + rectangle.width));
        int n3 = this.w2s.transformY(linkbar.row * this.rowHeight + this.rowHeight / 2);
        Color color = this.links.getColor(linkbar.kind);
        if (color == null) {
            color = linkbar.color != null ? linkbar.color : Config.defaultAnnotColor;
        }
        this.drawBar(graphics, n, n2, n3, color);
    }

    void drawBar(Graphics graphics, int n, int n2, int n3, Color color) {
        int n4 = n3 - this.thickness / 2;
        int n5 = n2 - n;
        graphics.setColor(color);
        graphics.drawRect(n, n4, n5, this.thickness);
        graphics.fillRect(n, n4, n5, this.thickness);
    }

    void showMouseLoc(Point point) {
        this.state.showLinkLoc(point.x, this.links.findLinkbar(point.x, this.getRow(point.y)));
    }

    void doClick(Point point) {
        Linkbar linkbar = this.links.findLinkbar(point.x, this.getRow(point.y));
        if (linkbar != null) {
            IO.showURL(this.maj, linkbar.url, "linkbar");
        }
    }

    private int getRow(int n) {
        return n / this.rowHeight;
    }
}

