/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.DefaultExonColors;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.GenericAnnot;
import edu.psu.bx.gmaj.GenericAnnotList;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Linkbar;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinkbarList
implements Copyable {
    static final String rcsid = "$Revision: 1.15 $$Date: 2007/07/09 18:52:46 $";
    String filename;
    Hashtable colors;
    Vector regions;
    int numRows;

    public LinkbarList(String string, Hashtable hashtable, Vector vector, int n) {
        this.filename = string;
        this.colors = hashtable;
        this.regions = vector;
        this.numRows = n;
        vector.trimToSize();
    }

    public LinkbarList(GenericAnnotList genericAnnotList, int n) {
        this(genericAnnotList, n, new Range(0, 0));
    }

    public LinkbarList(GenericAnnotList genericAnnotList, int n, Range range) {
        this.filename = genericAnnotList.filename;
        this.colors = new Hashtable();
        this.regions = new Vector(genericAnnotList.regions.size());
        this.numRows = 0;
        try {
            this.fromGeneric(genericAnnotList, n, range);
            this.assignRows();
        }
        catch (BadInputException badInputException) {
            Log.showError("Error loading linkbars from file \"" + this.filename + "\":" + "\n" + badInputException);
        }
        this.regions.trimToSize();
    }

    public LinkbarList(String string) {
        this(string, null);
    }

    public LinkbarList(String string, BufferedReader bufferedReader) {
        this(string, bufferedReader, new Range(0, 0));
    }

    public LinkbarList(String string, BufferedReader bufferedReader, Range range) {
        this.filename = string;
        this.colors = new Hashtable();
        this.regions = new Vector();
        this.numRows = 0;
        try {
            if (bufferedReader != null) {
                this.fromReader(bufferedReader, range);
                this.assignRows();
            } else if (string != null && !string.equals("")) {
                BufferedReader bufferedReader2 = IO.getReader(string);
                this.fromReader(bufferedReader2, range);
                bufferedReader2.close();
                this.assignRows();
            }
        }
        catch (IOException iOException) {
            Log.showError("Error loading linkbars from" + (bufferedReader != null ? " bundled" : "") + " file \"" + string + "\":" + "\n" + iOException);
        }
        this.regions.trimToSize();
    }

    private void fromGeneric(GenericAnnotList genericAnnotList, int n, Range range) throws BadInputException {
        if (n == 1) {
            Object object;
            Object object2;
            FeatureList featureList = new FeatureList(genericAnnotList, n, range);
            Hashtable hashtable = DefaultExonColors.getColors();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = ColorTable.getColor((String)hashtable.get(object2));
                if (object == null) {
                    Log.fatalBug("LinkbarList.fromGeneric(): DefaultExonColors has bad color \"" + (String)hashtable.get(object2) + "\".");
                }
                this.colors.put(object2, object);
            }
            object2 = featureList.regions.elements();
            while (object2.hasMoreElements()) {
                object = (Feature)object2.nextElement();
                Linkbar linkbar = new Linkbar((Feature)object);
                linkbar.kind = DefaultExonColors.getKind((Feature)object);
                this.regions.addElement(linkbar);
            }
        } else if (n == 2) {
            FeatureList featureList = new FeatureList(genericAnnotList, n, range);
            Enumeration enumeration = featureList.regions.elements();
            while (enumeration.hasMoreElements()) {
                Feature feature = (Feature)enumeration.nextElement();
                Linkbar linkbar = new Linkbar(feature);
                linkbar.color = Config.defaultAnnotColor;
                this.regions.addElement(linkbar);
            }
        } else {
            Enumeration enumeration = genericAnnotList.regions.elements();
            while (enumeration.hasMoreElements()) {
                int n2;
                GenericAnnot genericAnnot = (GenericAnnot)enumeration.nextElement();
                if (genericAnnot.kind == null) {
                    genericAnnot.kind = "";
                }
                if (genericAnnot.name == null) {
                    genericAnnot.name = "";
                }
                if (genericAnnot.gene == null) {
                    genericAnnot.gene = "";
                }
                if (genericAnnot.group == null || genericAnnot.group.equals("")) {
                    genericAnnot.group = genericAnnot.gene;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (!genericAnnot.group.equals("") && !genericAnnot.name.startsWith(genericAnnot.group)) {
                    stringBuffer.append(genericAnnot.group + ":");
                }
                if (!genericAnnot.name.equals("")) {
                    stringBuffer.append(genericAnnot.name + ":");
                }
                if ((n2 = stringBuffer.length()) > 0) {
                    stringBuffer.deleteCharAt(n2 - 1);
                }
                if (genericAnnot.color == null) {
                    genericAnnot.color = Config.defaultAnnotColor;
                }
                Linkbar linkbar = new Linkbar(genericAnnot.kind, genericAnnot.start, genericAnnot.end, genericAnnot.dir, stringBuffer.toString(), genericAnnot.color, genericAnnot.url, -1);
                if (range.start != 0 && !Util.overlaps(linkbar.start, linkbar.end, range.start, range.end)) continue;
                this.regions.addElement(linkbar);
            }
        }
        Collections.sort(this.regions, new Comparator(){

            public int compare(Object object, Object object2) {
                Linkbar linkbar = (Linkbar)object;
                Linkbar linkbar2 = (Linkbar)object2;
                int n = linkbar.end - linkbar.start;
                int n2 = linkbar2.end - linkbar2.start;
                return n > n2 ? -1 : (n < n2 ? 1 : (linkbar.start < linkbar2.start ? -1 : (linkbar.start > linkbar2.start ? 1 : 0)));
            }
        });
    }

    private void fromReader(BufferedReader bufferedReader, Range range) throws IOException {
        String string = IO.getNonemptyLine(bufferedReader);
        while (string != null) {
            String string2;
            StringTokenizer stringTokenizer = this.getTokenizer(string);
            if (!stringTokenizer.nextToken().equals("%define")) {
                throw new BadInputException("Expecting \"%define\":\n" + string);
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("type")) {
                string2 = this.readType(bufferedReader);
            } else if (string3.equals("annotation")) {
                string2 = this.readLinkbar(bufferedReader, range);
            } else {
                throw new BadInputException("Invalid keyword \"" + string3 + "\":" + "\n" + string);
            }
            this.checkNoneLeft(stringTokenizer, string);
            string = string2;
        }
    }

    private String readType(BufferedReader bufferedReader) throws IOException {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        while ((string = IO.getNonemptyLine(bufferedReader)) != null) {
            object = this.getTokenizer(string);
            String string4 = ((StringTokenizer)object).nextToken();
            if (string4.equals("%define")) break;
            if (string4.equals("%name")) {
                string3 = ((StringTokenizer)object).nextToken();
            } else if (string4.equals("%color")) {
                string2 = ((StringTokenizer)object).nextToken();
            } else {
                throw new BadInputException("Invalid keyword \"" + string4 + "\":" + "\n" + string);
            }
            this.checkNoneLeft((StringTokenizer)object, string);
        }
        if (string3 == null || string2 == null) {
            throw new BadInputException("Incomplete type definition: name or color is missing.");
        }
        object = ColorTable.getColor(string2);
        if (object == null) {
            throw new BadInputException("Invalid color \"" + string2 + "\".");
        }
        this.colors.put(string3, object);
        return string;
    }

    private String readLinkbar(BufferedReader bufferedReader, Range range) throws IOException {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        while ((string = IO.getNonemptyLine(bufferedReader)) != null) {
            object = this.getTokenizer(string);
            String string8 = ((StringTokenizer)object).nextToken();
            if (string8.equals("%define")) break;
            if (string8.equals("%type")) {
                if (this.notMulti(string8, string7)) {
                    string7 = ((StringTokenizer)object).nextToken();
                }
            } else if (string8.equals("%range")) {
                if (this.notMulti(string8, string6)) {
                    if (((StringTokenizer)object).countTokens() < 2) {
                        throw new BadInputException("Not enough tokens:\n" + string);
                    }
                    string6 = ((StringTokenizer)object).nextToken();
                    string5 = ((StringTokenizer)object).nextToken();
                }
            } else if (string8.equals("%dir")) {
                if (this.notMulti(string8, string4)) {
                    string4 = ((StringTokenizer)object).nextToken();
                }
            } else if (string8.equals("%label")) {
                if (this.notMulti(string8, string3)) {
                    string3 = ((StringTokenizer)object).nextToken("\n\r\f").trim();
                }
            } else if (string8.equals("%summary")) {
                while (!this.nextLineIsNewField(bufferedReader)) {
                    bufferedReader.readLine();
                }
                object = null;
            } else if (string8.equals("%url")) {
                String string9 = ((StringTokenizer)object).nextToken("\n\r\f").trim();
                while (!this.nextLineIsNewField(bufferedReader)) {
                    String string10 = bufferedReader.readLine().trim();
                    if (string10.equals("") || string10.startsWith("#")) continue;
                    string9 = string9 + string10;
                }
                if (this.notMulti(string8, string2)) {
                    string2 = string9;
                }
            } else {
                throw new BadInputException("Invalid keyword \"" + string8 + "\":" + "\n" + string);
            }
            this.checkNoneLeft((StringTokenizer)object, string);
        }
        if (string7 == null || string6 == null || string3 == null) {
            throw new BadInputException("Incomplete linkbar: type, range, or label is missing.");
        }
        if (!this.colors.containsKey(string7)) {
            throw new BadInputException("Linkbar type \"" + string7 + "\" has not been defined yet.");
        }
        object = new Linkbar(string7, string6, string5, string4, string3, string2);
        if (range.start == 0 || Util.overlaps(((Linkbar)object).start, ((Linkbar)object).end, range.start, range.end)) {
            this.regions.addElement(object);
        }
        return string;
    }

    private boolean notMulti(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        Log.showWarning("linkbar_multi_" + string, "Warning:\n" + Log.programName + " does not support multiple \"" + string + "\"s in the same" + "\n" + "linkbar annotation.  Only the first one for each linkbar" + "\n" + "will be used.");
        return false;
    }

    private boolean nextLineIsNewField(BufferedReader bufferedReader) throws IOException {
        bufferedReader.mark(3);
        int n = bufferedReader.read();
        int n2 = bufferedReader.read();
        bufferedReader.reset();
        return n < 0 || n == 37 && n2 >= 0 && Character.isLetter((char)n2);
    }

    private StringTokenizer getTokenizer(String string) throws BadInputException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            throw new BadInputException("Not enough tokens:\n" + string);
        }
        return stringTokenizer;
    }

    private void checkNoneLeft(StringTokenizer stringTokenizer, String string) throws BadInputException {
        if (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            throw new BadInputException("Too many tokens:\n" + string);
        }
    }

    private void assignRows() {
        Vector<Linkbar> vector;
        Vector vector2 = new Vector();
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Linkbar linkbar = (Linkbar)enumeration.nextElement();
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                vector = (Vector)vector2.elementAt(n2);
                boolean bl = true;
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    if (!linkbar.overlaps((Linkbar)enumeration2.nextElement())) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    vector.addElement(linkbar);
                    linkbar.row = n2;
                    break;
                }
                ++n2;
            }
            if (linkbar.row >= 0) continue;
            linkbar.row = n;
            vector = new Vector<Linkbar>();
            vector.addElement(linkbar);
            vector2.addElement(vector);
        }
        this.numRows = vector2.size();
        int n = this.numRows - 1;
        vector = this.regions.elements();
        while (vector.hasMoreElements()) {
            Linkbar linkbar = (Linkbar)vector.nextElement();
            linkbar.row = n - linkbar.row;
        }
    }

    public Color getColor(String string) {
        Color color = (Color)this.colors.get(string);
        if (color == null) {
            color = null;
        }
        return color;
    }

    public Linkbar findLinkbar(int n, int n2) {
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Linkbar linkbar = (Linkbar)enumeration.nextElement();
            if (linkbar.row != n2 || linkbar.start > n || n > linkbar.end) continue;
            return linkbar;
        }
        return null;
    }

    public Copyable copy() {
        Vector<Copyable> vector = new Vector<Copyable>(this.regions.size());
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Linkbar linkbar = (Linkbar)enumeration.nextElement();
            vector.addElement(linkbar.copy());
        }
        return new LinkbarList(this.filename, (Hashtable)this.colors.clone(), vector, this.numRows);
    }
}

