/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.Log;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;

public class Linkbar
implements Copyable {
    static final String rcsid = "$Revision: 1.8 $$Date: 2007/07/04 14:48:18 $";
    static final int NONE = 0;
    static final int LEFT = -1;
    static final int RIGHT = 1;
    public String kind;
    public int start;
    public int end;
    public int dir;
    public String label;
    public Color color;
    public URL url;
    public int row;

    public Linkbar(String string, int n, int n2, int n3, String string2, Color color, URL uRL, int n4) {
        this.kind = string;
        this.start = n;
        this.end = n2;
        this.dir = n3;
        this.label = string2;
        this.color = color;
        this.url = uRL;
        this.row = n4;
    }

    public Linkbar(String string, String string2, String string3, String string4, String string5, String string6) throws BadInputException {
        this.kind = string;
        try {
            this.start = Integer.parseInt(string2);
            this.end = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Invalid endpoint: not an integer.");
        }
        if (this.end < this.start) {
            throw new BadInputException("Invalid endpoints: end < start.");
        }
        if (string4 == null || string4.equals("None")) {
            this.dir = 0;
        } else if (string4.equals("Left")) {
            this.dir = -1;
        } else if (string4.equals("Right")) {
            this.dir = 1;
        } else {
            throw new BadInputException("Invalid direction \"" + string4 + "\".");
        }
        this.label = string5;
        this.color = null;
        try {
            this.url = string6 == null ? null : new URL(string6);
        }
        catch (MalformedURLException malformedURLException) {
            throw new BadInputException("\"" + string6 + "\"" + "\n" + "is not a well-formed URL.");
        }
        this.row = -1;
    }

    public Linkbar(Feature feature) {
        this.kind = feature.kind;
        this.start = feature.start;
        this.end = feature.end;
        this.dir = feature.dir;
        this.label = feature.label;
        this.color = null;
        this.url = null;
        this.row = -1;
    }

    public boolean overlaps(Linkbar linkbar) {
        if (linkbar == null) {
            return false;
        }
        return this.start < linkbar.end && this.end > linkbar.start;
    }

    public Copyable copy() {
        try {
            URL uRL = this.url == null ? null : new URL(this.url.toString());
            return new Linkbar(this.kind, this.start, this.end, this.dir, this.label, this.color, uRL, this.row);
        }
        catch (MalformedURLException malformedURLException) {
            Log.fatalBug("Linkbar.copy(): Malformed url.");
            return null;
        }
    }
}

