/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.SimpleTokenizer;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class InputSpecs {
    static final String rcsid = "$Revision: 1.37 $$Date: 2008/04/10 04:09:41 $";
    static final int MAF = 0;
    static final int EXON = 1;
    static final int REPEAT = 2;
    static final int LINKBAR = 3;
    static final int UNDERLAY = 4;
    static final int HILIGHT = 5;
    Maj maj;
    private String specfile;
    private String fullspecfile;
    private boolean usingspecs;
    private String title;
    private String datapath;
    private String fulldatapath;
    private Vector af;
    private String refseq;
    private String reconorg;
    private Vector tabext;
    private boolean skipotherseq;
    private Vector sn;
    private Hashtable sa;
    private Vector ex;
    private Vector rp;
    private Vector ln;
    private Vector un;
    private Vector ud;
    private Vector hi;
    private Vector os;
    private int maxseq;
    private BitSet seqused;
    private Hashtable usedAs;

    public InputSpecs(Maj maj, String string) {
        this(maj, string, null);
    }

    public InputSpecs(Maj maj, String string, BufferedReader bufferedReader) {
        this.maj = maj;
        this.specfile = string;
        this.fullspecfile = null;
        this.usingspecs = false;
        this.title = null;
        this.datapath = null;
        this.fulldatapath = null;
        this.af = new Vector();
        this.refseq = "any";
        this.reconorg = "none";
        this.tabext = new Vector();
        this.skipotherseq = false;
        this.sn = new Vector();
        this.sa = new Hashtable();
        this.ex = new Vector();
        this.rp = new Vector();
        this.ln = new Vector();
        this.un = new Vector();
        this.ud = new Vector();
        this.hi = new Vector();
        this.os = new Vector();
        this.maxseq = -1;
        this.seqused = new BitSet();
        this.usedAs = new Hashtable();
        if (maj.global.test) {
            this.testFind();
            Log.exit(2);
        }
        try {
            if (bufferedReader != null) {
                this.fromReader(bufferedReader);
            } else {
                this.fullspecfile = IO.getFullName(string);
                BufferedReader bufferedReader2 = IO.getReader(this.fullspecfile);
                this.fromReader(bufferedReader2);
                bufferedReader2.close();
            }
        }
        catch (IOException iOException) {
            if (string == null) {
                string = "";
            }
            Log.showError("Error loading contents of" + (bufferedReader != null ? " bundled" : "") + " file \"" + string + "\":" + "\n" + iOException);
            Log.exit(1);
        }
        this.fulldatapath = this.findDatapath(this.datapath);
    }

    private void fromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = -1;
        while ((string = bufferedReader.readLine()) != null && string.trim().equals("")) {
        }
        if (string == null) {
            throw new BadInputException("The input file is empty.");
        }
        if (string.startsWith("#:gmaj")) {
            this.usingspecs = true;
            while ((string = IO.getNonemptyLine(bufferedReader)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (stringTokenizer.nextToken().toLowerCase().equals("seq")) {
                    n = this.readSeqno(stringTokenizer, string);
                    continue;
                }
                this.readSpec(n, string);
            }
            this.checkSpecs();
        } else if (string.startsWith("##maf")) {
            this.usingspecs = false;
            if (this.fullspecfile == null) {
                throw new BadInputException("Must supply a parameters file when bundling input files.");
            }
            this.af.addElement(this.fullspecfile);
        } else {
            throw new BadInputException("The input is not a #:gmaj or ##maf file.");
        }
    }

    private int readSeqno(StringTokenizer stringTokenizer, String string) throws IOException {
        int n;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken(" \t\n\r\f:"));
        }
        catch (RuntimeException runtimeException) {
            throw new BadInputException("Missing or invalid sequence number:\n" + string);
        }
        if (n < 0) {
            throw new BadInputException("Invalid sequence number:\n" + string);
        }
        if (this.seqused.get(n)) {
            throw new BadInputException("Duplicate sequence number:\n" + string);
        }
        this.seqused.set(n);
        if (n > this.maxseq) {
            this.growMax(n);
        }
        return n;
    }

    private void readSpec(int n, String string) throws IOException {
        block34: {
            String string2 = null;
            try {
                string = string.trim();
                int n2 = string.indexOf(61);
                if (n2 <= 0) {
                    throw new BadInputException("Settings in parameters file must have the format \"keyword = value(s)\":");
                }
                string2 = Util.take(string, n2).trim().toLowerCase();
                String string3 = Util.drop(string, n2 + 1);
                SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string3.replace('\t', ' '), ' ', true, true, this.specfile);
                String string4 = Util.unquote(simpleTokenizer.getToken());
                if (string4 == null) {
                    return;
                }
                if (string2.equals("title")) {
                    this.title = string4;
                    break block34;
                }
                if (string2.equals("datapath")) {
                    this.datapath = string4;
                    break block34;
                }
                if (string2.equals("alignfile")) {
                    while (string4 != null) {
                        if (this.af.contains(string4)) {
                            throw new BadInputException("Duplicate alignfile name:");
                        }
                        this.af.addElement(string4);
                        this.recordType(string4, 0);
                        string4 = Util.unquote(simpleTokenizer.getToken());
                    }
                    break block34;
                }
                if (string2.equals("refseq")) {
                    this.refseq = string4;
                    break block34;
                }
                if (string2.equals("reconorg")) {
                    this.reconorg = string4;
                    break block34;
                }
                if (string2.equals("reconseq")) {
                    this.reconorg = string4;
                    break block34;
                }
                if (string2.equals("tabext")) {
                    while (string4 != null) {
                        this.tabext.addElement(string4);
                        string4 = Util.unquote(simpleTokenizer.getToken());
                    }
                    break block34;
                }
                if (string2.equals("nowarn")) {
                    while (string4 != null) {
                        this.maj.global.dejaVu(string4);
                        string4 = Util.unquote(simpleTokenizer.getToken());
                    }
                    break block34;
                }
                if (string2.equals("skipotherseq")) {
                    this.skipotherseq = Util.grokBoolean(string4);
                    break block34;
                }
                if (string2.equals("seqname")) {
                    String string5 = null;
                    while (string4 != null) {
                        String string6;
                        if (string5 == null) {
                            string5 = string4;
                            this.sn.set(n, string5);
                        }
                        if ((string6 = this.sa.put(string4, string5)) != null && !string6.equals(string5)) {
                            throw new BadInputException("Duplicate sequence alias:");
                        }
                        string4 = Util.unquote(simpleTokenizer.getToken());
                    }
                    break block34;
                }
                if (string2.equals("exons")) {
                    this.ex.set(n, this.makeAnnotSpec(string4, simpleTokenizer, 1));
                    break block34;
                }
                if (string2.equals("repeats")) {
                    this.rp.set(n, this.makeAnnotSpec(string4, simpleTokenizer, 2));
                    break block34;
                }
                if (string2.equals("links")) {
                    this.ln.set(n, this.makeAnnotSpec(string4, simpleTokenizer, 3));
                    break block34;
                }
                if (string2.startsWith("underlays")) {
                    int n3 = string2.indexOf(46);
                    if (n3 < 0) {
                        this.ud.set(n, this.makeAnnotSpec(string4, simpleTokenizer, 4));
                    } else {
                        int n4 = Integer.parseInt(Util.drop(string2, n3 + 1));
                        if (n4 < 0 || n4 == n) {
                            throw new BadInputException("Invalid sequence number:");
                        }
                        if (n4 > this.maxseq) {
                            this.growMax(n4);
                        }
                        ((Vector)this.un.get(n)).set(n4, this.makeAnnotSpec(string4, simpleTokenizer, 4));
                    }
                    break block34;
                }
                if (string2.equals("highlights")) {
                    this.hi.set(n, this.makeAnnotSpec(string4, simpleTokenizer, 5));
                    break block34;
                }
                if (string2.equals("offset")) {
                    this.os.set(n, new Integer(string4));
                    break block34;
                }
                throw new BadInputException("Unrecognized keyword:");
            }
            catch (BadInputException badInputException) {
                throw new BadInputException(badInputException + "\n" + string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new BadInputException("No current sequence number:\n" + string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string2.startsWith("underlays")) {
                    throw new BadInputException("Missing or invalid sequence number:\n" + string);
                }
                throw new BadInputException("Invalid offset number:\n" + string);
            }
        }
    }

    private AnnotSpec makeAnnotSpec(String string, SimpleTokenizer simpleTokenizer, int n) throws BadInputException {
        this.recordType(string, n);
        return new AnnotSpec(string, Util.unquote(simpleTokenizer.getToken()), Util.unquote(simpleTokenizer.getToken()));
    }

    private void recordType(String string, int n) {
        if (!this.usedAs.containsKey(string)) {
            this.usedAs.put(string, new BitSet());
        }
        BitSet bitSet = (BitSet)this.usedAs.get(string);
        bitSet.set(n);
    }

    private void growMax(int n) {
        this.maxseq = Math.max(this.maxseq, n);
        int n2 = this.maxseq + 1;
        this.sn.setSize(n2);
        this.ex.setSize(n2);
        this.rp.setSize(n2);
        this.ln.setSize(n2);
        this.un.setSize(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.un.get(n3) == null) {
                this.un.set(n3, new Vector());
            }
            ((Vector)this.un.get(n3)).setSize(n2);
            ++n3;
        }
        this.ud.setSize(n2);
        this.hi.setSize(n2);
        this.os.setSize(n2);
    }

    private void checkSpecs() throws BadInputException {
        if (this.usingspecs && this.af.isEmpty()) {
            throw new BadInputException("No alignfile specified.");
        }
        int n = 0;
        while (n <= this.maxseq) {
            Object object;
            if (this.seqused.get(n)) {
                object = (String)this.sn.get(n);
                if (object == null || ((String)object).equals("")) {
                    throw new BadInputException("Sequence name is missing for sequence " + n + ".");
                }
                if (this.sn.indexOf(object, n + 1) >= 0) {
                    if (n == 0 && this.maxseq <= 1) {
                        this.sn.set(1, (String)object + "~");
                    } else {
                        throw new BadInputException("Sequence name \"" + (String)object + "\" appears more than once.");
                    }
                }
            }
            object = (Vector)this.un.get(n);
            int n2 = 0;
            while (n2 <= this.maxseq) {
                if (((Vector)object).get(n2) != null && !this.seqused.get(n2)) {
                    throw new BadInputException("An underlay file involving sequence " + n2 + " is mentioned," + "\n" + "but no defining section for that sequence is provided.");
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean usingSpecs() {
        return this.usingspecs;
    }

    public String getSpecFile() {
        return this.specfile;
    }

    public String getTitle() {
        return this.title;
    }

    public Vector getAlignFiles() {
        return this.af;
    }

    public String getRefSeq() {
        return this.resolveAlias(this.refseq);
    }

    public String getReconOrg() {
        if (!this.resolveAlias(this.reconorg).equals(this.reconorg)) {
            Log.showError("Sequence aliases do not apply to the \"reconorg\" parameter,\nbecause it specifies an organism rather than a single sequence.");
        }
        return this.reconorg;
    }

    public Vector getTabExt() {
        return this.tabext;
    }

    public boolean getSkipOtherSeq() {
        return this.skipotherseq;
    }

    public String resolveAlias(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.sa.get(string);
        return string2 == null ? string : string2;
    }

    public int getSeqno(String string) {
        return this.sn.indexOf(string);
    }

    public String getSeqName(int n) {
        return n >= 0 && n <= this.maxseq ? (String)this.sn.get(n) : null;
    }

    public AnnotSpec getExonSpec(int n) {
        return n >= 0 && n <= this.maxseq ? (AnnotSpec)this.ex.get(n) : null;
    }

    public AnnotSpec getRepeatSpec(int n) {
        return n >= 0 && n <= this.maxseq ? (AnnotSpec)this.rp.get(n) : null;
    }

    public AnnotSpec getLinkSpec(int n) {
        return n >= 0 && n <= this.maxseq ? (AnnotSpec)this.ln.get(n) : null;
    }

    public AnnotSpec getUnderlaySpec(int n, int n2) {
        AnnotSpec annotSpec = null;
        if (n >= 0 && n <= this.maxseq) {
            Vector vector = (Vector)this.un.get(n);
            if (n2 >= 0 && n2 <= this.maxseq) {
                annotSpec = (AnnotSpec)vector.get(n2);
            }
            if (annotSpec == null) {
                annotSpec = (AnnotSpec)this.ud.get(n);
            }
        }
        return annotSpec;
    }

    public AnnotSpec getHighlightSpec(int n) {
        return n >= 0 && n <= this.maxseq ? (AnnotSpec)this.hi.get(n) : null;
    }

    public int getOffset(int n) {
        Integer n2;
        if (n >= 0 && n <= this.maxseq && (n2 = (Integer)this.os.get(n)) != null) {
            return n2;
        }
        return 0;
    }

    public int[] getOffsets(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getOffset(n2);
            ++n2;
        }
        return nArray;
    }

    public int getMaxSeq() {
        return this.maxseq;
    }

    public boolean isSeqUsed(int n) {
        return n >= 0 && n <= this.maxseq ? this.seqused.get(n) : false;
    }

    public boolean anyExons() {
        int n = 0;
        while (n <= this.maxseq) {
            if (this.ex.get(n) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean anyRepeats() {
        int n = 0;
        while (n <= this.maxseq) {
            if (this.rp.get(n) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean anyLinks() {
        int n = 0;
        while (n <= this.maxseq) {
            if (this.ln.get(n) != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean anyUnderlays() {
        int n = 0;
        while (n <= this.maxseq) {
            if (this.ud.get(n) != null) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 <= this.maxseq) {
            Vector vector = (Vector)this.un.get(n2);
            int n3 = 0;
            while (n3 <= this.maxseq) {
                if (vector.get(n3) != null) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public BitSet inferTypes(String string) {
        BitSet bitSet = (BitSet)this.usedAs.get(string);
        return bitSet == null ? new BitSet() : (BitSet)bitSet.clone();
    }

    static int priorityType(BitSet bitSet) {
        if (bitSet == null) {
            Log.fatalBug("InputSpecs.priorityType(): Null argument.");
        }
        if (bitSet.get(1)) {
            return 1;
        }
        if (bitSet.get(2)) {
            return 2;
        }
        if (bitSet.get(3)) {
            return 3;
        }
        if (bitSet.get(4)) {
            return 4;
        }
        if (bitSet.get(5)) {
            return 5;
        }
        Log.fatalBug("InputSpecs.priorityType(): No valid filetypes.");
        return -1;
    }

    static String typeName(int n) {
        switch (n) {
            case 0: {
                return "MAF";
            }
            case 1: {
                return "exon";
            }
            case 2: {
                return "repeat";
            }
            case 3: {
                return "linkbar";
            }
            case 4: 
            case 5: {
                return "underlay";
            }
        }
        return "(unknown format)";
    }

    String findFile(String string) {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (this.isAbsolute(string)) {
            return string;
        }
        if (this.fulldatapath != null && (string3 = IO.seekFullName(string2 = this.fulldatapath + "foo", string, true)) != null) {
            return string3;
        }
        string3 = IO.seekFullName(this.fullspecfile, string, true);
        if (string3 != null) {
            return string3;
        }
        if (!this.maj.global.test) {
            Log.showError("Can't find file \"" + string + "\".");
        }
        return null;
    }

    private String findDatapath(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (this.isAbsolute(string)) {
            string2 = string;
        } else {
            string2 = IO.seekFullName(this.fullspecfile, string, false);
            if (string2 == null) {
                if (!this.maj.global.test) {
                    Log.showError("Invalid datapath \"" + string + "\".");
                }
                return null;
            }
        }
        if (string2 != null) {
            String string3;
            String string4 = string3 = IO.isUrl(string2) ? "/" : File.separator;
            if (!string2.endsWith(string3)) {
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    private boolean isAbsolute(String string) {
        if (IO.isUrl(string)) {
            return true;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            if (string.startsWith("/")) {
                if (this.maj.applet != null) {
                    return false;
                }
                return file.exists();
            }
            return true;
        }
        return false;
    }

    private void testFind() {
        String string = "http://globin.bx.psu.edu/java/gmaj/test/";
        String string2 = "http://globin.bx.psu.edu/java/gmaj/test";
        String string3 = "/java/gmaj/test/";
        String string4 = "/java/gmaj/test";
        String string5 = "sub1/";
        String string6 = "sub1";
        String string7 = "http://globin.bx.psu.edu/html/";
        String string8 = "http://globin.bx.psu.edu/java/gmaj/test/findme0u.txt";
        String string9 = "/java/gmaj/test/findme0u.txt";
        String string10 = "sub1/findme1u.txt";
        String string11 = "findme0u.txt";
        String string12 = "http://globin.bx.psu.edu/html/intro.html";
        String string13 = "/home/cathy/gmaj/data/test/";
        String string14 = "/home/cathy/gmaj/data/test";
        String string15 = "sub1/";
        String string16 = "sub1";
        String string17 = "/home/cathy/tmp/";
        String string18 = "/home/cathy/gmaj/data/test/findme0.txt";
        String string19 = "sub1/findme1.txt";
        String string20 = "findme0.txt";
        String string21 = "/home/cathy/tmp/foo.tmp";
        String string22 = "C:\\gmaj\\test\\";
        String string23 = "C:\\gmaj\\test";
        String string24 = "\\gmaj\\test\\";
        String string25 = "\\gmaj\\test";
        String string26 = "sub1\\";
        String string27 = "sub1";
        String string28 = "C:\\temp\\";
        String string29 = "C:\\gmaj\\test\\findme0.txt";
        String string30 = "\\gmaj\\test\\findme0.txt";
        String string31 = "sub1\\findme1.txt";
        String string32 = "findme0.txt";
        String string33 = "C:\\temp\\foo.tmp";
        System.out.println("------ Testing ability to find specfile ------");
        int n = 0;
        n += this.sftest("--", string8, string8);
        n += this.sftest("us", string18, string18);
        n += this.sftest("us", string19, string13 + string19);
        n += this.sftest("us", string20, string13 + string20);
        n += this.sftest("ws", string29, string29);
        n += this.sftest("ws", string30, string29);
        n += this.sftest("ws", string31, string22 + string31);
        System.out.println("sftest: " + (n += this.sftest("ws", string32, string22 + string32)) + " errors." + IO.EOLP);
        System.out.println("------ Testing ability to find datapath ------");
        n = 0;
        n += this.dptest("--", string12, string, string);
        n += this.dptest("--", string12, string2, string);
        n += this.dptest("--", string8, string3, string);
        n += this.dptest("--", string8, string4, string);
        n += this.dptest("--", string8, string5, string + string5);
        n += this.dptest("--", string8, string6, string + string5);
        n += this.dptest("u-", string18, string, string);
        n += this.dptest("u-", string18, string2, string);
        n += this.dptest("w-", string29, string, string);
        n += this.dptest("w-", string29, string2, string);
        n += this.dptest("us", string21, string13, string13);
        n += this.dptest("us", string21, string14, string13);
        n += this.dptest("us", string18, string15, string13 + string15);
        n += this.dptest("us", string18, string16, string13 + string15);
        n += this.dptest("us", string8, string13, string13);
        n += this.dptest("us", string8, string14, string13);
        n += this.dptest("ws", string33, string22, string22);
        n += this.dptest("ws", string33, string23, string22);
        n += this.dptest("ws", string29, string24, string22);
        n += this.dptest("ws", string29, string25, string22);
        n += this.dptest("ws", string29, string26, string22 + string26);
        n += this.dptest("ws", string29, string27, string22 + string26);
        n += this.dptest("ws", string8, string22, string22);
        System.out.println("dptest: " + (n += this.dptest("ws", string8, string23, string22)) + " errors." + IO.EOLP);
        System.out.println("------ Testing ability to find filenames ------");
        n = 0;
        n += this.fntest("--", string12, string7, string8, string8);
        n += this.fntest("--", string12, string, string9, string8);
        n += this.fntest("--", string12, string, string10, string + string10);
        n += this.fntest("--", string12, string, string11, string + string11);
        n += this.fntest("--", string12, string, "missing", null);
        n += this.fntest("--", string12, string + string5, string11, null);
        n += this.fntest("--", string8, string7, string9, string8);
        n += this.fntest("--", string8, string7, string10, string + string10);
        n += this.fntest("--", string8, string7, string11, string + string11);
        n += this.fntest("--", string8, string7, "missing", null);
        n += this.fntest("--", string + string10, string7, string11, null);
        n += this.fntest("us", string21, string17, string18, string18);
        n += this.fntest("us", string21, string13, string19, string13 + string19);
        n += this.fntest("us", string21, string13, string20, string13 + string20);
        n += this.fntest("us", string21, string13, "missing", null);
        n += this.fntest("us", string21, string13 + string15, string20, null);
        n += this.fntest("us", string18, string17, string19, string13 + string19);
        n += this.fntest("us", string18, string17, string20, string13 + string20);
        n += this.fntest("us", string18, string17, "missing", null);
        n += this.fntest("us", string13 + string19, string17, string20, null);
        n += this.fntest("ws", string33, string28, string29, string29);
        n += this.fntest("ws", string33, string22, string30, string29);
        n += this.fntest("ws", string33, string22, string31, string22 + string31);
        n += this.fntest("ws", string33, string22, string32, string22 + string32);
        n += this.fntest("ws", string33, string22, "missing", null);
        n += this.fntest("ws", string33, string22 + string26, string32, null);
        n += this.fntest("ws", string29, string28, string30, string29);
        n += this.fntest("ws", string29, string28, string31, string22 + string31);
        n += this.fntest("ws", string29, string28, string32, string22 + string32);
        n += this.fntest("ws", string29, string28, "missing", null);
        System.out.println("fntest: " + (n += this.fntest("ws", string22 + string31, string28, string32, null)) + " errors." + IO.EOLP);
        System.out.flush();
    }

    private int sftest(String string, String string2, String string3) {
        boolean bl;
        boolean bl2 = File.separatorChar == '\\';
        boolean bl3 = bl = this.maj.applet != null;
        if (!this.matchSystem(string, bl2, bl)) {
            return 0;
        }
        String string4 = IO.getFullName(string2);
        boolean bl4 = this.testReport(string2, string4, string3);
        if (bl4 && string4 != null) {
            bl4 = this.testOpen(string4);
        }
        return bl4 ? 0 : 1;
    }

    private int dptest(String string, String string2, String string3, String string4) {
        boolean bl;
        boolean bl2 = File.separatorChar == '\\';
        boolean bl3 = bl = this.maj.applet != null;
        if (!this.matchSystem(string, bl2, bl)) {
            return 0;
        }
        this.fullspecfile = string2;
        String string5 = this.findDatapath(string3);
        boolean bl4 = this.testReport(string2, string3, string5, string4);
        return bl4 ? 0 : 1;
    }

    private int fntest(String string, String string2, String string3, String string4, String string5) {
        boolean bl;
        boolean bl2 = File.separatorChar == '\\';
        boolean bl3 = bl = this.maj.applet != null;
        if (!this.matchSystem(string, bl2, bl)) {
            return 0;
        }
        this.fullspecfile = string2;
        this.fulldatapath = string3;
        String string6 = this.findFile(string4);
        boolean bl4 = this.testReport(string2, string3, string4, string6, string5);
        if (bl4 && string6 != null) {
            bl4 = this.testOpen(string6);
        }
        return bl4 ? 0 : 1;
    }

    private boolean matchSystem(String string, boolean bl, boolean bl2) {
        if (string.charAt(0) == 'u' && bl) {
            return false;
        }
        if (string.charAt(0) == 'w' && !bl) {
            return false;
        }
        if (string.charAt(1) == 's' && bl2) {
            return false;
        }
        return string.charAt(1) != 'a' || bl2;
    }

    private boolean testReport(String string, String string2, String string3) {
        boolean bl = Util.equals(string2, string3);
        if (bl && !this.maj.global.verbose) {
            return bl;
        }
        System.out.println(bl ? "Passed:" : "Failed:");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        System.out.println("\tspecfile     = \"" + string + "\"" + IO.EOLP + "\tfullspecfile = \"" + string2 + "\"");
        if (!bl) {
            System.out.println("\texpected     = \"" + string3 + "\"");
        }
        return bl;
    }

    private boolean testReport(String string, String string2, String string3, String string4) {
        boolean bl = Util.equals(string3, string4);
        if (bl && !this.maj.global.verbose) {
            return bl;
        }
        System.out.println(bl ? "Passed:" : "Failed:");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        System.out.println("\tfullspecfile = \"" + string + "\"" + IO.EOLP + "\tdatapath     = \"" + string2 + "\"" + IO.EOLP + "\tfulldatapath = \"" + string3 + "\"");
        if (!bl) {
            System.out.println("\texpected     = \"" + string4 + "\"");
        }
        return bl;
    }

    private boolean testReport(String string, String string2, String string3, String string4, String string5) {
        boolean bl = Util.equals(string4, string5);
        if (bl && !this.maj.global.verbose) {
            return bl;
        }
        System.out.println(bl ? "Passed:" : "Failed:");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        System.out.println("\tfullspecfile = \"" + string + "\"" + IO.EOLP + "\tfulldatapath = \"" + string2 + "\"" + IO.EOLP + "\tfilename     = \"" + string3 + "\"" + IO.EOLP + "\tfullfilename = \"" + string4 + "\"");
        if (!bl) {
            System.out.println("\texpected     = \"" + string5 + "\"");
        }
        return bl;
    }

    private boolean testOpen(String string) {
        boolean bl = false;
        try {
            BufferedReader bufferedReader = IO.getReader(string);
            int n = bufferedReader.read();
            if (this.maj.global.verbose) {
                System.out.println("\t\"" + string + "\" opened successfully.");
            }
            bufferedReader.close();
            bl = true;
        }
        catch (IOException iOException) {
            if (string == null) {
                string = "";
            }
            System.out.println("Error reading from \"" + string + "\":" + IO.EOLP + "\t" + iOException);
            bl = false;
        }
        return bl;
    }

    static final class AnnotSpec {
        String filename;
        String seqalias;
        int typehint;

        AnnotSpec(String string, String string2, String string3) throws BadInputException {
            this.filename = string;
            this.seqalias = null;
            String string4 = null;
            if (string2 != null) {
                if (string2.equals("exons") || string2.equals("repeats")) {
                    string4 = string2;
                    this.seqalias = string3;
                } else {
                    this.seqalias = string2;
                    string4 = string3;
                }
            }
            int n = string4 == null ? -1 : (string4.equals("exons") ? 1 : (this.typehint = string4.equals("repeats") ? 2 : -9));
            if (this.typehint < -1) {
                throw new BadInputException("If present, annotation type hint must be either \"exons\" or \"repeats\".");
            }
        }
    }
}

