/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

final class IO {
    static final String rcsid = "$Revision: 1.16 $$Date: 2008/05/06 18:22:32 $";
    static final String EOLP = System.getProperty("line.separator");
    static final String EOL = "\n";
    static final String CRLF = "\r\n";
    static final String WS = " \t\n\r\f";
    static final char DQ = '\"';
    static /* synthetic */ Class class$edu$psu$bx$gmaj$Maj;

    IO() {
    }

    static String pathlessName(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0 || (n = string.lastIndexOf(92)) >= 0 || (n = string.lastIndexOf(58)) >= 0) {
            return Util.drop(string, n + 1);
        }
        return string;
    }

    static boolean isUrl(String string) {
        try {
            URL uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    static boolean existsURL(URL uRL) {
        if (Log.getGlobal().test) {
            Util.sleep(Log.getGlobal().urlPause);
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("HEAD");
                int n = httpURLConnection.getResponseCode();
                return n >= 200 && n < 300;
            }
            InputStream inputStream = uRLConnection.getInputStream();
            int n = inputStream.read();
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.warn("IO.existsURL (\"" + uRL.toString() + "\"):" + " IOException" + EOL + iOException);
            return false;
        }
        catch (SecurityException securityException) {
            Log.warn("IO.existsURL (\"" + uRL.toString() + "\"):" + " SecurityException" + EOL + securityException);
            return false;
        }
        return true;
    }

    static String getFullUrl(URL uRL, String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        try {
            return new URL(uRL, string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            Log.showError("\"" + string + "\"" + EOL + "is not a well-formed URL.");
            return "";
        }
    }

    static String seekFullName(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            uRL = new URL(uRL, string2);
            return !bl || IO.existsURL(uRL) ? uRL.toString() : null;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                File file;
                if (string2.charAt(0) == '\\' && File.separatorChar == '\\' && string.indexOf(58) == 1) {
                    file = new File(Util.take(string, 2) + string2);
                } else {
                    String string3 = new File(string).getParent();
                    file = new File(string3, string2);
                }
                return !bl || file.exists() ? file.getAbsolutePath() : null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }

    static String getFullName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            return new URL(string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string).getAbsolutePath();
        }
    }

    static BufferedReader getReader(InputStream inputStream, String string) throws IOException {
        return new BufferedReader(new InputStreamReader(IO.wrapZipStream(inputStream, string)));
    }

    static BufferedReader getReader(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(IO.getStream(string)));
    }

    static InputStream getStream(String string) throws IOException {
        InputStream inputStream;
        if (string == null || string.equals("")) {
            throw new IOException("Missing input file name.");
        }
        try {
            URL uRL = new URL(string);
            Util.sleep(Log.getGlobal().urlPause);
            inputStream = uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                Log.fatalBug("IO.getStream(): Source filename is relative.");
            }
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Can't find file \"" + string + "\".");
            }
            catch (SecurityException securityException) {
                throw new IOException("Access denied to file \"" + string + "\".");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Can't open url \"" + string + "\".");
        }
        catch (SecurityException securityException) {
            throw new IOException("Access denied to url \"" + string + "\".");
        }
        return IO.wrapZipStream(inputStream, string);
    }

    static InputStream wrapZipStream(InputStream inputStream, String string) throws IOException {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim().toLowerCase();
        return string2.endsWith(".gz") ? new GZIPInputStream(inputStream) : (string2.endsWith(".zip") ? new ZipInputStream(inputStream) : (string2.endsWith(".jar") ? new JarInputStream(inputStream) : inputStream));
    }

    static String getNonemptyLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (!(string = string.trim()).equals("") && !string.startsWith("#")) break;
        }
        return string;
    }

    static boolean prefixInUse(String string) throws IOException {
        String string2;
        String[] stringArray;
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        if ((stringArray = file2.list(new FilenameFilter(string2 = file.getName()){
            private final /* synthetic */ String val$bname;
            {
                this.val$bname = string;
            }

            public boolean accept(File file, String string) {
                return string.startsWith(this.val$bname);
            }
        })) == null) {
            throw new IOException("Can't retrieve contents of directory \"" + file2 + "\".");
        }
        return stringArray.length > 0;
    }

    static URL getDocURL(String string) {
        int n;
        int n2;
        String string2 = "Maj.class";
        URL uRL = null;
        String string3 = (class$edu$psu$bx$gmaj$Maj == null ? (class$edu$psu$bx$gmaj$Maj = IO.class$("edu.psu.bx.gmaj.Maj")) : class$edu$psu$bx$gmaj$Maj).getResource(string2).toString();
        if (string3.startsWith("jar:")) {
            int n3 = string3.indexOf(33);
            n2 = 4;
            n = string3.lastIndexOf(92, n3);
            if (n < 0) {
                n = string3.lastIndexOf(47, n3);
            }
            ++n;
        } else {
            n2 = 0;
            n = string3.indexOf(string2);
        }
        string3 = string3.substring(n2, n);
        try {
            uRL = new URL(string3 + string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.showError("Bad URL for document page:\n" + string3 + string);
        }
        return uRL;
    }

    static void showURL(Maj maj, URL uRL, String string) {
        if (uRL != null) {
            if (maj.applet != null) {
                maj.applet.getAppletContext().showDocument(uRL, string);
            } else {
                Log.showMessage("The requested resource should be available at:\n\n" + uRL.toString() + EOL, "Resource URL");
            }
        } else {
            Log.showMessage("There is no URL associated with this item.", "Resource URL");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

