/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.PlotBlock;
import edu.psu.bx.gmaj.PlotPane;
import edu.psu.bx.gmaj.TextPane;
import edu.psu.bx.gmaj.Underlay;
import edu.psu.bx.gmaj.Util;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class GlobalState {
    static final String rcsid = "$Revision: 1.3 $$Date: 2008/06/11 01:59:42 $";
    Maj maj;
    static final int IDENTITY = 0;
    static final int UNDERLAY = 1;
    int ilimit;
    int ulimit;
    BitSet showMafs;
    boolean showTagged;
    BitSet usertags;
    int tagcount;
    Hashtable showPanels;
    BitSet showSeq;
    int headerCols;
    int urlPause;
    boolean verbose;
    boolean test;
    Hashtable warned;
    MouseEvent lastMove;

    public GlobalState(Maj maj, int n, boolean bl, boolean bl2) {
        this.maj = maj;
        this.ulimit = 0;
        this.ilimit = 0;
        this.showMafs = new BitSet();
        this.showTagged = true;
        this.usertags = new BitSet();
        this.tagcount = 0;
        this.showPanels = new Hashtable();
        this.showSeq = new BitSet();
        this.headerCols = 0;
        this.urlPause = n >= 0 ? n : 100;
        this.verbose = bl;
        this.test = bl2;
        this.warned = new Hashtable();
        this.lastMove = null;
    }

    public void setup() {
        int n = 0;
        while (n < this.maj.nmaf) {
            this.showMafs.set(n);
            ++n;
        }
        this.showPanels.put("posline", Boolean.TRUE);
        this.showPanels.put("markline", Boolean.TRUE);
        this.showPanels.put("vis", new Boolean(this.maj.nmaf > 1));
        this.showPanels.put("ruler", Boolean.TRUE);
        this.showPanels.put("recon", new Boolean(this.maj.bf.anyRecon()));
        this.showPanels.put("links", new Boolean(this.maj.specs.anyLinks()));
        this.showPanels.put("exons", new Boolean(this.maj.specs.anyExons()));
        this.showPanels.put("repeats", new Boolean(this.maj.specs.anyRepeats()));
        this.showPanels.put("text", Boolean.TRUE);
        this.showPanels.put("dotunderlay", new Boolean(this.maj.specs.anyUnderlays()));
        int n2 = 0;
        while (n2 < this.maj.nseq) {
            this.showSeq.set(n2);
            ++n2;
        }
        this.showSeq.set(this.maj.nseq);
        this.headerCols = this.maj.bf.maxMafSeqnameLength();
    }

    public void setLimit(int n, String string) {
        try {
            switch (n) {
                case 0: {
                    this.ilimit = Integer.parseInt(string);
                    break;
                }
                case 1: {
                    this.ulimit = Integer.parseInt(string);
                    break;
                }
                default: {
                    Log.fatalBug("GlobalState.setLimit(): Bad threshold identifier.");
                }
            }
            this.maj.syncAllGuis();
        }
        catch (NumberFormatException numberFormatException) {
            Log.showError("Threshold must be an integer.");
        }
    }

    public void adjustLimit(int n, int n2) {
        switch (n) {
            case 0: {
                this.ilimit += n2;
                break;
            }
            case 1: {
                this.ulimit += n2;
                break;
            }
            default: {
                Log.fatalBug("GlobalState.adjustLimit(): Bad threshold identifier.");
            }
        }
        this.maj.syncAllGuis();
    }

    public void setShowMaf(int n, boolean bl) {
        if (n < 0 || n >= this.maj.nmaf) {
            Log.fatalBug("GlobalState.setShowMaf(): Invalid MAF number \"" + n + "\".");
        }
        if (bl) {
            this.showMafs.set(n);
        } else {
            this.showMafs.clear(n);
        }
        this.maj.syncAllGuis();
    }

    public void setShowTagged(boolean bl) {
        this.showTagged = bl;
        this.maj.syncAllGuis();
    }

    public void toggleTag(MarkInfo markInfo) {
        if (markInfo == null) {
            Log.showError("The mark must be set first.");
        } else {
            this.toggleTag(markInfo.blockno);
        }
    }

    public void toggleTag(int n) {
        if (n < 0 || n >= this.maj.bf.blocks.size()) {
            Log.fatalBug("GlobalState.toggleTag(): Invalid block number \"" + n + "\".");
        }
        if (!this.usertags.get(n)) {
            this.usertags.set(n);
            ++this.tagcount;
        } else {
            this.usertags.clear(n);
            --this.tagcount;
        }
        this.maj.syncAllGuis();
    }

    public void clearTags() {
        this.usertags.xor(this.usertags);
        this.tagcount = 0;
        this.maj.syncAllGuis();
    }

    public boolean isVisible(int n) {
        if (n < 0 || n >= this.maj.bf.blocks.size()) {
            Log.fatalBug("GlobalState.isVisible(): Invalid block number \"" + n + "\".");
        }
        if (this.usertags.get(n)) {
            return this.showTagged;
        }
        return this.showMafs.get(this.maj.bf.block((int)n).mafno);
    }

    public boolean isVisible(PlotBlock plotBlock) {
        if (plotBlock.pm < this.ilimit) {
            return false;
        }
        return this.isVisible(plotBlock.blockno);
    }

    public boolean isVisible(Underlay underlay) {
        return underlay.score >= this.ulimit;
    }

    public boolean isTagged(int n) {
        if (n < 0 || n >= this.maj.bf.blocks.size()) {
            Log.fatalBug("GlobalState.isTagged(): Invalid block number \"" + n + "\".");
        }
        return this.usertags.get(n);
    }

    public void setShown(String string, boolean bl) {
        if (!this.showPanels.containsKey(string)) {
            Log.fatalBug("GlobalState.setShown(): Invalid item name \"" + string + "\".");
        }
        this.showPanels.put(string, new Boolean(bl));
    }

    public void setShown(int n, boolean bl) {
        if (n > this.showSeq.length() - 2) {
            Log.fatalBug("GlobalState.setShown(): Invalid sequence number \"" + n + "\".");
        }
        if (bl) {
            this.showSeq.set(n);
        } else {
            this.showSeq.clear(n);
        }
    }

    public boolean getShown(String string) {
        Boolean bl = (Boolean)this.showPanels.get(string);
        if (bl == null) {
            Log.fatalBug("GlobalState.getShown(): Invalid item name \"" + string + "\".");
        }
        return bl;
    }

    public boolean getShown(int n) {
        if (n > this.showSeq.length() - 2) {
            Log.fatalBug("GlobalState.getShown(): Invalid sequence number \"" + n + "\".");
        }
        return this.showSeq.get(n);
    }

    public int countShownSeq() {
        return Util.countSetBits(this.showSeq);
    }

    public boolean dejaVu(String string) {
        return this.dejaVu(string, true);
    }

    public boolean dejaVu(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (!bl) {
            return this.warned.get(string) != null;
        }
        return this.warned.put(string, "") != null;
    }

    public void redoLastMove() {
        block8: {
            if (this.lastMove != null) {
                Object object = this.lastMove.getSource();
                if (object instanceof PlotPane) {
                    ((PlotPane)object).mouseMoved(this.lastMove);
                } else if (object instanceof MultiLineLabel) {
                    try {
                        TextPane textPane = (TextPane)SwingUtilities.getAncestorOfClass(Class.forName("edu.psu.bx.gmaj.TextPane"), (MultiLineLabel)object);
                        if (textPane != null) {
                            textPane.mouseMoved(this.lastMove);
                            break block8;
                        }
                        Log.warn("Can't find TextPane to reprocess mouse event.");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.warn("Can't find TextPane to reprocess mouse event.");
                    }
                } else {
                    Log.warn("Unexpected source for reprocessing mouse event.");
                }
            }
        }
    }
}

