/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.EmptyIntervalException;
import edu.psu.bx.gmaj.GenericAnnot;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.SimpleTokenizer;
import edu.psu.bx.gmaj.UnrecognizedFormatException;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GenericAnnotList
implements Copyable {
    static final String rcsid = "$Revision: 1.3 $$Date: 2007/07/09 22:14:48 $";
    static final String ALL = "[all]";
    String filename;
    Vector regions;
    String seqname;
    String trackName;
    private Hashtable colors;
    private boolean haveTrackLine;
    private String trackColor;
    private boolean itemRgb;
    private boolean useScore;
    private int offset;
    private String trackUrl;
    private int versionGff;
    private Vector nondna;

    public GenericAnnotList(String string, Vector vector, String string2, String string3) {
        this.filename = string;
        this.regions = vector;
        this.seqname = string2;
        this.trackName = string3;
        this.colors = null;
        this.resetTrackVars();
        this.nondna = null;
        vector.trimToSize();
    }

    public GenericAnnotList(String string) {
        this(string, null);
    }

    public GenericAnnotList(String string, BufferedReader bufferedReader) {
        this.filename = string;
        this.regions = new Vector();
        this.seqname = null;
        this.trackName = null;
        this.colors = new Hashtable();
        this.colors.put("default", Config.defaultAnnotColor);
        this.resetTrackVars();
        try {
            BufferedReader bufferedReader2 = bufferedReader;
            if (bufferedReader2 == null && string != null && !string.equals("")) {
                bufferedReader2 = IO.getReader(string);
            }
            if (bufferedReader2 != null) {
                this.fromReader(bufferedReader2);
            }
            if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                bufferedReader2.close();
            }
        }
        catch (IOException iOException) {
            Log.showError("Error loading annotations from" + (bufferedReader != null ? " bundled" : "") + " file \"" + string + "\":" + "\n" + iOException);
        }
        this.regions.trimToSize();
    }

    private void resetTrackVars() {
        this.haveTrackLine = false;
        this.trackColor = null;
        this.itemRgb = false;
        this.useScore = false;
        this.offset = 0;
        this.trackUrl = null;
        this.versionGff = -1;
        this.nondna = new Vector();
    }

    private void fromReader(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            try {
                String string2 = string.trim();
                if (string2.equals("") || string2.startsWith("browser")) continue;
                if (string2.startsWith("track")) {
                    this.resetTrackVars();
                    this.parseTrack(string2, bufferedReader);
                    continue;
                }
                if (string2.startsWith("##")) {
                    this.parsePragma(Util.drop(string2, 2));
                    continue;
                }
                if (string2.startsWith("#")) continue;
                this.parseAnnot(string);
            }
            catch (BadInputException badInputException) {
                throw new BadInputException(badInputException + "\n" + "\n" + Util.replaceTabs(string));
            }
        }
    }

    private void parseTrack(String string, BufferedReader bufferedReader) throws IOException {
        if (string == null) {
            return;
        }
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string.replace('\t', ' '), ' ', true, true, this.filename);
        String string2 = simpleTokenizer.nextToken();
        if (!string2.equals("track")) {
            Log.fatalBug("GenericAnnotList.parseTrack(): No \"track\" token.");
        }
        this.haveTrackLine = true;
        while (true) {
            try {
                string2 = simpleTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            int n = string2.indexOf(61);
            if (n <= 0) {
                throw new BadInputException("Track line items must have the format \"attribute=value\".");
            }
            if (n == string2.length() - 1) continue;
            String string3 = Util.take(string2, n).toLowerCase();
            String string4 = Util.unquote(Util.drop(string2, n + 1));
            if (string3.equals("type") && string4.startsWith("wiggle")) {
                this.resetTrackVars();
                this.parseTrack(this.skipToNextTrack(bufferedReader), bufferedReader);
                return;
            }
            if (string3.equals("name")) {
                this.trackName = this.trackName == null || this.trackName.equals(string4) ? string4 : "";
                continue;
            }
            if (string3.equals("color")) {
                this.trackColor = this.storeColor(string4, string);
                continue;
            }
            if (string3.equals("itemrgb")) {
                this.itemRgb = string4.toLowerCase().equals("on");
                continue;
            }
            if (string3.equals("usescore")) {
                this.useScore = string4.equals("1");
                continue;
            }
            if (string3.equals("offset")) {
                try {
                    this.offset = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadInputException("Offset must be an integer.");
                }
            }
            if (!string3.equals("url")) continue;
            this.trackUrl = string4;
        }
    }

    private String skipToNextTrack(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.trim();
            if (!string2.startsWith("track")) continue;
            return string2;
        }
        return null;
    }

    private void parsePragma(String string) throws BadInputException {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string.replace('\t', ' '), ' ', true, true, this.filename);
        try {
            String string2 = simpleTokenizer.nextToken().toLowerCase();
            if (string2.equals("gff-version")) {
                this.versionGff = Integer.parseInt(Util.unquote(simpleTokenizer.nextToken()));
            } else if (string2.equals("type")) {
                String string3;
                String string4 = simpleTokenizer.nextToken().toLowerCase();
                String string5 = string3 = simpleTokenizer.hasMoreTokens() ? simpleTokenizer.nextToken() : null;
                if (string3 == null) {
                    if (!string4.equals("dna")) {
                        this.nondna.addElement(ALL);
                    }
                } else {
                    string3 = Util.unquote(string3);
                    if (!string4.equals("dna")) {
                        this.nondna.addElement(string3);
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BadInputException("Not enough tokens for pragma.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("GFF version must be an integer.");
        }
    }

    private void parseAnnot(String string) throws BadInputException {
        if (this.nondna.contains(ALL)) {
            return;
        }
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string, '\t', false, false, this.filename);
        try {
            String string2 = simpleTokenizer.nextToken();
            String string3 = simpleTokenizer.nextToken().trim();
            String string4 = simpleTokenizer.nextToken().trim();
            if (Util.isInteger(string3) && Util.isInteger(string4)) {
                this.parseBED(string);
            } else {
                this.parseGFF(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.showWarning("annot_format", "Skipping annotations in unrecognized formats", this.filename, string);
        }
        catch (UnrecognizedFormatException unrecognizedFormatException) {
            Log.showWarning("annot_format", "Skipping annotations in unrecognized formats", this.filename, string);
        }
    }

    private void parseGFF(String string) throws BadInputException {
        Object object;
        Object object2;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(Util.trimComment(string), '\t', false, false, this.filename);
        try {
            string7 = Util.unquote(simpleTokenizer.nextToken());
            String string8 = Util.unquote(simpleTokenizer.nextToken());
            string6 = Util.unquote(simpleTokenizer.nextToken());
            string5 = Util.unquote(simpleTokenizer.nextToken());
            string4 = Util.unquote(simpleTokenizer.nextToken());
            string3 = Util.unquote(simpleTokenizer.nextToken());
            string2 = Util.unquote(simpleTokenizer.nextToken());
            String string9 = Util.unquote(simpleTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new UnrecognizedFormatException();
        }
        if (this.nondna.contains(string7)) {
            return;
        }
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = simpleTokenizer.allRemaining();
        if (string16 != null) {
            if (this.versionGff == 1) {
                string15 = Util.unquote(string16);
            } else {
                object2 = string6 == null ? "" : string6.toLowerCase();
                object = this.parseAttrs(string16);
                Enumeration enumeration = ((Hashtable)object).keys();
                while (enumeration.hasMoreElements()) {
                    String string17 = (String)enumeration.nextElement();
                    Vector vector = (Vector)((Hashtable)object).get(string17);
                    if (((Hashtable)object).size() == 1 && vector.isEmpty()) {
                        string15 = string17;
                        break;
                    }
                    String string18 = string17.toLowerCase();
                    if (string18.equals("gene") || string18.equals("gene_id")) {
                        string14 = this.singleVal(string17, vector);
                        continue;
                    }
                    if (((String)object2).equals("repeatmasker") && string18.equals("sequence")) {
                        string13 = this.singleVal(string17, vector);
                        continue;
                    }
                    if (string18.equals("name")) {
                        string12 = this.singleVal(string17, vector);
                        continue;
                    }
                    if (string18.equals("color")) {
                        string11 = this.storeColor(this.singleVal(string17, vector), string);
                        continue;
                    }
                    if (!string18.equals("url") && !string18.equals("ucsc_id")) continue;
                    string10 = this.singleVal(string17, vector);
                }
            }
        }
        this.seqname = this.seqname == null || this.seqname.equals(string7) ? string7 : "";
        object2 = this.getColor(this.haveTrackLine, this.itemRgb, this.useScore, this.trackColor, string11, string3);
        object = this.trackUrl != null ? this.trackUrl : string10;
        this.regions.addElement(new GenericAnnot(0, string7, string5, string4, this.offset, string2, string6, string12, string14, string15, string13, (Color)object2, string3, (String)object, this.filename, string));
    }

    /*
     * Unable to fully structure code
     */
    private Hashtable parseAttrs(String var1_1) throws BadInputException {
        if (var1_1.indexOf(9) >= 0) {
            throw new UnrecognizedFormatException();
        }
        var2_2 = new Hashtable<String, Vector<E>>();
        var3_3 = new Vector<String>();
        var4_4 = new SimpleTokenizer(var1_1, ';', false, true, this.filename);
        try {
            while (true) {
                if ((var5_5 = var4_4.nextToken().trim()).equals("")) {
                    continue;
                }
                var3_3.addElement(var5_5);
            }
        }
        catch (NoSuchElementException var5_6) {
            var5_7 = var3_3.elements();
            ** while (var5_7.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            var1_1 = (String)var5_7.nextElement();
            var6_8 = new Vector<String>();
            var4_4 = new SimpleTokenizer(var1_1, ' ', true, true, this.filename);
            try {
                while (true) {
                    var6_8.addElement(var4_4.nextToken());
                }
            }
            catch (NoSuchElementException var7_10) {
                var7_9 = null;
                var8_11 = new Vector<String>();
                var9_12 = var6_8.elements();
                ** while (var9_12.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var10_13 = (String)var9_12.nextElement();
                if (var10_13 == null || var10_13.equals("")) continue;
                var10_13 = Util.unquote(var10_13);
                if (var7_9 == null) {
                    var7_9 = var10_13;
                    continue;
                }
                var8_11.addElement(var10_13);
                continue;
            }
lbl35:
            // 1 sources

            if (var7_9 == null) continue;
            var2_2.put(var7_9, var8_11);
            continue;
        }
lbl39:
        // 1 sources

        return var2_2;
    }

    private String singleVal(String string, Vector vector) throws BadInputException {
        if (vector.isEmpty()) {
            throw new BadInputException("Missing value for the \"" + string + "\" tag.");
        }
        if (vector.size() > 1) {
            throw new BadInputException("Multiple values for the \"" + string + "\" tag are not supported.");
        }
        return (String)vector.firstElement();
    }

    private void parseBED(String string) throws BadInputException {
        String string2;
        String string3;
        String string4;
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(string, '\t', false, false, this.filename);
        try {
            string4 = Util.unquote(simpleTokenizer.nextToken());
            string3 = Util.unquote(simpleTokenizer.nextToken());
            string2 = Util.unquote(simpleTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new UnrecognizedFormatException();
        }
        if (this.nondna.contains(string4)) {
            return;
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        try {
            string13 = Util.unquote(simpleTokenizer.nextToken());
            string12 = Util.unquote(simpleTokenizer.nextToken());
            string11 = Util.unquote(simpleTokenizer.nextToken());
            string10 = Util.unquote(simpleTokenizer.nextToken());
            string9 = Util.unquote(simpleTokenizer.nextToken());
            string8 = this.storeColor(Util.unquote(simpleTokenizer.nextToken()), string);
            string7 = Util.unquote(simpleTokenizer.nextToken());
            string6 = Util.unquote(simpleTokenizer.nextToken());
            string5 = Util.unquote(simpleTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (simpleTokenizer.hasMoreTokens()) {
            throw new UnrecognizedFormatException();
        }
        this.seqname = this.seqname == null || this.seqname.equals(string4) ? string4 : "";
        Color color = this.getColor(this.haveTrackLine, this.itemRgb, this.useScore, this.trackColor, string8, string12);
        String string14 = this.trackUrl;
        if (string7 != null) {
            Log.showWarning("bed_blocks", "Assuming that BED12 blocks are exons", this.filename, string);
            try {
                this.regions.addElement(new GenericAnnot(1, string4, string3, string2, null, null, this.offset, string11, "gene", string13, color, string12, string14, this.filename, string));
            }
            catch (EmptyIntervalException emptyIntervalException) {
                // empty catch block
            }
            SimpleTokenizer simpleTokenizer2 = new SimpleTokenizer(string6, ',', true, false, this.filename);
            SimpleTokenizer simpleTokenizer3 = new SimpleTokenizer(string5, ',', true, false, this.filename);
            try {
                int n = Integer.parseInt(string7);
                int n2 = 0;
                while (n2 < n) {
                    String string15 = simpleTokenizer2.nextToken().trim();
                    String string16 = simpleTokenizer3.nextToken().trim();
                    try {
                        this.regions.addElement(new GenericAnnot(1, string4, string3, string2, string16, string15, this.offset, string11, "exon", string13, color, string12, string14, this.filename, string));
                    }
                    catch (EmptyIntervalException emptyIntervalException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadInputException("blockCount must be an integer.");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new BadInputException("Wrong number of blockSizes or blockStarts.");
            }
            if (simpleTokenizer2.hasMoreTokens() || simpleTokenizer3.hasMoreTokens()) {
                throw new BadInputException("Wrong number of blockSizes or blockStarts.");
            }
        } else {
            try {
                this.regions.addElement(new GenericAnnot(1, string4, string3, string2, null, null, this.offset, string11, null, string13, color, string12, string14, this.filename, string));
            }
            catch (EmptyIntervalException emptyIntervalException) {
                // empty catch block
            }
        }
        if (string10 != null || string9 != null) {
            Log.showWarning("bed_thick", "Assuming that BED thickStart/thickEnd are CDS endpoints", this.filename, string);
            try {
                this.regions.addElement(new GenericAnnot(1, string4, string10, string9, null, null, this.offset, string11, string7 == null ? "cds_for_exon" : "cds", string13, color, string12, string14, this.filename, string));
            }
            catch (EmptyIntervalException emptyIntervalException) {
                // empty catch block
            }
        }
    }

    private String storeColor(String string, String string2) {
        if (string == null) {
            return null;
        }
        if ((string = Util.stripChar(' ', string)).equals("") || string.equals(".") || string.equals("0")) {
            return null;
        }
        if (!this.colors.containsKey(string)) {
            try {
                this.colors.put(string, Util.makeColor(string));
            }
            catch (BadInputException badInputException) {
                Log.showWarning("color_format", "Skipping unrecognized color formats", this.filename, string2, badInputException);
                return null;
            }
        }
        return string;
    }

    private Color getColor(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3) {
        String string4 = !bl ? (string2 != null ? string2 : "default") : (!bl2 ? (string != null ? string : "default") : (string2 != null ? string2 : (string != null ? string : "default")));
        Color color = (Color)this.colors.get(string4);
        if (color == null) {
            Log.fatalBug("GenericAnnotList.getColor(): No color for \"" + string4 + "\".");
        }
        if (bl3) {
            Log.showWarning("score_shading", "\"useScore\" shading is not yet supported.", null, null);
        }
        return color;
    }

    public Copyable copy() {
        Vector<Copyable> vector = new Vector<Copyable>(this.regions.size());
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            GenericAnnot genericAnnot = (GenericAnnot)enumeration.nextElement();
            vector.addElement(genericAnnot.copy());
        }
        return new GenericAnnotList(this.filename, vector, this.seqname, this.trackName);
    }
}

