/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.EmptyIntervalException;
import edu.psu.bx.gmaj.FeatureStyles;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;

public class GenericAnnot
implements Copyable {
    static final String rcsid = "$Revision: 1.2 $$Date: 2007/07/09 18:52:46 $";
    static final int GFF = 0;
    static final int BED = 1;
    static final int NONE = 0;
    static final int LEFT = -1;
    static final int RIGHT = 1;
    public int format;
    public String seqname;
    public int start;
    public int end;
    public int dir;
    public String kind;
    public String name;
    public String gene;
    public String group;
    public Color color;
    public float score;
    public URL url;

    public GenericAnnot(int n, String string, int n2, int n3, int n4, String string2, String string3, String string4, String string5, Color color, float f, URL uRL) {
        if (n3 < n2) {
            Log.fatalBug("GenericAnnot.GenericAnnot(): Invalid endpoints: end < start.");
        }
        this.format = n;
        this.seqname = string;
        this.start = n2;
        this.end = n3;
        this.dir = n4;
        this.kind = string2;
        this.name = string3;
        this.gene = string4;
        this.group = string5;
        this.color = color;
        this.score = f;
        this.url = uRL;
    }

    public GenericAnnot(int n, String string, String string2, String string3, int n2, String string4, String string5, String string6, String string7, String string8, String string9, Color color, String string10, String string11, String string12, String string13) throws BadInputException {
        if (n != 0) {
            Log.fatalBug("GenericAnnot.GenericAnnot(): Wrong format for GFF constructor.");
        }
        this.format = n;
        if (string == null || string.equals("")) {
            throw new BadInputException("Missing or empty value for seqname field.");
        }
        this.seqname = string;
        try {
            this.start = Integer.parseInt(string2);
            this.end = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Start, end must be integers.");
        }
        if (this.start < 1 || this.end < 1) {
            Log.showWarning("gff_coord", "GFF start or end is < 1", string12, string13);
        }
        if (this.end < this.start) {
            throw new BadInputException("GFF requires start <= end.");
        }
        this.start += n2;
        this.end += n2;
        this.dir = this.parseStrand(string4, string12, string13);
        this.kind = this.parseFeature(string5, string9, string12, string13);
        this.name = string6;
        this.gene = string7;
        this.group = string8;
        this.color = color;
        this.score = this.parseScore(string10, string12, string13);
        this.url = this.parseUrl(string11, string6, string12, string13);
    }

    public GenericAnnot(int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7, String string8, Color color, String string9, String string10, String string11, String string12) throws BadInputException, EmptyIntervalException {
        if (n != 1) {
            Log.fatalBug("GenericAnnot.GenericAnnot(): Wrong format for BED constructor.");
        }
        this.format = n;
        if (string == null || string.equals("")) {
            throw new BadInputException("Missing or empty value for chrom field.");
        }
        this.seqname = string;
        try {
            this.start = Integer.parseInt(string2);
            this.end = Integer.parseInt(string3);
            if (this.start < 0 || this.end < 0) {
                Log.showWarning("bed_coord", "BED start or end is < 0", string11, string12);
            }
            if (this.end < this.start) {
                throw new BadInputException("BED requires start <= end.");
            }
            if (this.end == this.start) {
                throw new EmptyIntervalException("BED interval has zero length.");
            }
            this.start += 1 + n2;
            this.end += n2;
            if (string4 != null || string5 != null) {
                if (string4 == null || string5 == null) {
                    throw new BadInputException("Invalid BED12 block.");
                }
                int n3 = Integer.parseInt(string4);
                int n4 = Integer.parseInt(string5);
                if (n3 < 0 || n4 < 0 || this.start + n3 + n4 - 1 > this.end) {
                    throw new BadInputException("Invalid BED12 block.");
                }
                if (n4 == 0) {
                    throw new EmptyIntervalException("BED12 block has zero length.");
                }
                this.start += n3;
                this.end = this.start + n4 - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Start, end, etc. must be integers.");
        }
        this.dir = this.parseStrand(string6, string11, string12);
        this.kind = this.parseFeature(string7, null, string11, string12);
        this.name = string8;
        this.gene = null;
        this.group = null;
        this.color = color;
        this.score = this.parseScore(string9, string11, string12);
        this.url = this.parseUrl(string10, string8, string11, string12);
    }

    private int parseStrand(String string, String string2, String string3) {
        if (string == null || string.equals("") || string.equals(".")) {
            return 0;
        }
        if (string.equals("-")) {
            return -1;
        }
        if (string.equals("+")) {
            return 1;
        }
        Log.showWarning("bad_strand", "Ignoring invalid strands", string2, string3);
        return 0;
    }

    private String parseFeature(String string, String string2, String string3, String string4) {
        if (string == null || string.equals("") || string.equals(".")) {
            return "";
        }
        String string5 = string.toLowerCase();
        if (string5.equals("gene") || string5.startsWith("gene_")) {
            return "gene";
        }
        if (string5.equals("exon") || string5.startsWith("exon_")) {
            return "exon";
        }
        if (string5.equals("start_codon") || string5.equals("str_codon")) {
            return "start_codon";
        }
        if (string5.equals("stop_codon") || string5.equals("stp_codon")) {
            return "stop_codon";
        }
        if (string5.equals("cds")) {
            return "cds";
        }
        if (string5.equals("cds_for_exon")) {
            return "cds_for_exon";
        }
        if (string5.equals("repeatmasker")) {
            if (string2 == null || string2.equals("")) {
                Log.showWarning("unrec_repeat", "Ignoring unrecognized repeats", string3, string4);
                return "";
            }
            int n = string2.indexOf(47);
            if (n <= 0 || n == string2.length() - 1) {
                Log.showWarning("unrec_repeat", "Ignoring unrecognized repeats", string3, string4);
                return "";
            }
            String string6 = FeatureStyles.getRepeatKind(Util.take(string2, n), Util.drop(string2, n + 1));
            if (string6 == null) {
                Log.showWarning("unrec_repeat", "Ignoring unrecognized repeats", string3, string4);
                return "";
            }
            return string6;
        }
        return string;
    }

    private float parseScore(String string, String string2, String string3) {
        try {
            return string == null || string.equals("") || string.equals(".") ? Float.NaN : Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                Log.showWarning("bad_score", "Ignoring invalid scores", string2, string3);
                return Float.NaN;
            }
        }
    }

    private URL parseUrl(String string, String string2, String string3, String string4) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.indexOf("$$") >= 0) {
            if (string2 == null) {
                Log.showWarning("url_subst", "Missing item name(s) for URL substitution", string3, string4);
                string2 = "";
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length() - 1) {
                if (stringBuffer.charAt(n) == '$' && stringBuffer.charAt(n + 1) == '$') {
                    stringBuffer.replace(n, n + 2, string2);
                    n += string2.length() - 1;
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.showWarning("bad_url", "Ignoring malformed URLs", string3, string4);
            return null;
        }
    }

    public Copyable copy() {
        try {
            URL uRL = this.url == null ? null : new URL(this.url.toString());
            return new GenericAnnot(this.format, this.seqname, this.start, this.end, this.dir, this.kind, this.name, this.gene, this.group, this.color, this.score, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Log.fatalBug("GenericAnnot.copy(): Malformed url.");
            return null;
        }
    }
}

