/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Log;
import java.awt.Color;
import java.util.Hashtable;

public final class FeatureStyles {
    static final String rcsid = "$Revision: 1.5 $$Date: 2007/07/04 14:48:18 $";
    static final int NONE = 0;
    static final int BOX = 1;
    static final int ARROWBOX = 2;
    static final int TRIANGLE = 3;
    static final Color BLACK = ColorTable.getColor("Black");
    static final Color DARKGRAY = ColorTable.getColor("Gray");
    static final Color LIGHTGRAY = ColorTable.getColor("LightGray");
    static final Color WHITE = ColorTable.getColor("White");
    static final String GENE = "Gene";
    static final String EXON = "Exon";
    static final String UTR = "UTR";
    static final String UNKNOWN = "Other";
    static final Hashtable styles = new Hashtable();
    static final String[][] rules;

    public static boolean isKind(String string) {
        return styles.containsKey(string);
    }

    public static boolean isRepeat(String string) {
        Spec spec = (Spec)styles.get(string);
        return spec != null && spec.repeat;
    }

    public static int getShape(String string) {
        int n = 0;
        try {
            n = ((Spec)FeatureStyles.styles.get((Object)string)).shape;
        }
        catch (NullPointerException nullPointerException) {
            Log.fatalBug("FeatureStyles.getShape(): Invalid feature name \"" + string + "\".");
        }
        return n;
    }

    public static Color getColor(String string) {
        Spec spec = (Spec)styles.get(string);
        if (spec == null) {
            Log.fatalBug("FeatureStyles.getColor(): Invalid feature name \"" + string + "\".");
        }
        return spec.color;
    }

    public static double getHeight(String string) {
        double d = 0.0;
        try {
            d = ((Spec)FeatureStyles.styles.get((Object)string)).height;
        }
        catch (NullPointerException nullPointerException) {
            Log.fatalBug("FeatureStyles.getHeight(): Invalid feature name \"" + string + "\".");
        }
        return d;
    }

    public static boolean hasDirection(String string) {
        boolean bl = false;
        try {
            bl = ((Spec)FeatureStyles.styles.get((Object)string)).shape > 1;
        }
        catch (NullPointerException nullPointerException) {
            Log.fatalBug("FeatureStyles.hasDirection(): Invalid feature name \"" + string + "\".");
        }
        return bl;
    }

    public static String getRepeatKind(String string, String string2) {
        int n = 0;
        while (n < rules.length) {
            if (rules[n][0].equals("N") && string.indexOf(rules[n][1]) >= 0 || rules[n][0].equals("T") && string2.indexOf(rules[n][1]) >= 0) {
                return rules[n][2];
            }
            ++n;
        }
        return null;
    }

    static {
        styles.put(GENE, new Spec(0, null, 0.0, false));
        styles.put(EXON, new Spec(1, BLACK, 1.0, false));
        styles.put(UTR, new Spec(1, LIGHTGRAY, 1.0, false));
        styles.put("Xon", new Spec(1, BLACK, 1.0, false));
        styles.put("RNA", new Spec(2, WHITE, 1.0, true));
        styles.put("Simple", new Spec(1, WHITE, 1.6, true));
        styles.put("Alu", new Spec(3, LIGHTGRAY, 1.6, true));
        styles.put("B1", new Spec(3, LIGHTGRAY, 1.6, true));
        styles.put("B2", new Spec(3, LIGHTGRAY, 1.6, true));
        styles.put("SINE", new Spec(3, LIGHTGRAY, 1.6, true));
        styles.put("LINE1", new Spec(2, LIGHTGRAY, 1.6, true));
        styles.put("MIR", new Spec(3, BLACK, 1.6, true));
        styles.put("LINE2", new Spec(2, BLACK, 1.6, true));
        styles.put("LTR", new Spec(2, DARKGRAY, 1.6, true));
        styles.put("DNA", new Spec(3, DARKGRAY, 1.6, true));
        styles.put(UNKNOWN, new Spec(3, DARKGRAY, 1.6, true));
        styles.put("CpG60", new Spec(1, WHITE, 3.2, true));
        styles.put("CpG75", new Spec(1, DARKGRAY, 3.2, true));
        rules = new String[][]{{"N", "Alu", "Alu"}, {"N", "MIR", "MIR"}, {"T", "L2", "LINE2"}, {"T", "L1", "LINE1"}, {"T", "LTR", "LTR"}, {"T", "ERV", "LTR"}, {"N", "LTR", "LTR"}, {"N", "HERV", "LTR"}, {"T", "DNA", "DNA"}, {"N", "B1", "B1"}, {"T", "B2", "B2"}, {"T", "SINE", "SINE"}, {"T", "LINE", UNKNOWN}, {"N", "MML", UNKNOWN}, {"N", "BUR1", UNKNOWN}, {"T", UNKNOWN, UNKNOWN}, {"T", "Unknown", UNKNOWN}, {"T", "RNA", "RNA"}, {"T", "Simple", "Simple"}, {"T", "Low", "Simple"}, {"T", "Satellite", "Simple"}};
    }

    static final class Spec {
        int shape;
        Color color;
        double height;
        boolean repeat;

        Spec(int n, Color color, double d, boolean bl) {
            this.shape = n;
            this.color = color;
            this.height = d;
            this.repeat = bl;
        }
    }
}

