/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.FeatureStyles;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Util;
import edu.psu.bx.gmaj.ZoomPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;

class FeaturePane
extends ZoomPane {
    static final String rcsid = "$Revision: 1.9 $$Date: 2007/04/05 19:26:12 $";
    static final int featureTop = 100;
    FeatureList features;

    FeaturePane(Maj maj, MajState majState, FeatureList featureList) {
        super(maj, majState, 0, 100);
        this.features = featureList;
    }

    void paintContents(Graphics graphics) {
        this.paintFeatures(graphics);
    }

    private void paintFeatures(Graphics graphics) {
        Rectangle rectangle = this.state.zt.getZoom();
        Enumeration enumeration = this.features.regions.elements();
        while (enumeration.hasMoreElements()) {
            Feature feature = (Feature)enumeration.nextElement();
            if (feature.kind.equals("Gene") || !Util.overlaps(feature.start, feature.end, rectangle.x, rectangle.x + rectangle.width)) continue;
            this.paintFeature(graphics, feature);
        }
    }

    private void paintFeature(Graphics graphics, Feature feature) {
        int n = FeatureStyles.getShape(feature.kind);
        Color color = FeatureStyles.getColor(feature.kind);
        int n2 = (int)(100.0 / FeatureStyles.getHeight(feature.kind));
        int n3 = this.w2s.transformX(feature.start);
        int n4 = this.w2s.transformX(feature.end);
        int n5 = this.w2s.transformY(0);
        int n6 = this.w2s.transformY(n2);
        switch (n) {
            case 1: {
                this.drawBox(graphics, n3, n5, n4, n6, color);
                break;
            }
            case 2: {
                this.drawArrowbox(graphics, n3, n5, n4, n6, feature.dir, color);
                break;
            }
            case 3: {
                this.drawTriangle(graphics, n3, n5, n4, n6, feature.dir, color);
                break;
            }
            default: {
                Log.showError("Can't paint feature; bad shape:" + n);
            }
        }
    }

    private void drawBox(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        int n5 = n3 - n;
        int n6 = n2 - n4;
        graphics.setColor(color);
        graphics.fillRect(n, n4, n5, n6);
        graphics.setColor(Config.foregroundColor);
        graphics.drawRect(n, n4, n5, n6);
    }

    private void drawTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        Polygon polygon = new Polygon();
        switch (n5) {
            case -1: {
                polygon.addPoint(n, (n2 + n4) / 2);
                polygon.addPoint(n3, n4);
                polygon.addPoint(n3, n2);
                break;
            }
            case 1: {
                polygon.addPoint(n, n2);
                polygon.addPoint(n, n4);
                polygon.addPoint(n3, (n2 + n4) / 2);
                break;
            }
            default: {
                Log.showError("Can't paint feature; bad direction:" + n5);
            }
        }
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.setColor(Config.foregroundColor);
        graphics.drawPolygon(polygon);
    }

    private void drawArrowbox(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        int n6 = Math.min((n2 - n4) / 2, (n3 - n) / 2);
        Polygon polygon = new Polygon();
        switch (n5) {
            case -1: {
                polygon.addPoint(n, (n2 + n4) / 2);
                polygon.addPoint(n + n6, n4);
                polygon.addPoint(n3, n4);
                polygon.addPoint(n3, n2);
                polygon.addPoint(n + n6, n2);
                break;
            }
            case 1: {
                polygon.addPoint(n, n2);
                polygon.addPoint(n, n4);
                polygon.addPoint(n3 - n6, n4);
                polygon.addPoint(n3, (n2 + n4) / 2);
                polygon.addPoint(n3 - n6, n2);
                break;
            }
            default: {
                Log.showError("Can't paint feature; bad direction:" + n5);
            }
        }
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.setColor(Config.foregroundColor);
        graphics.drawPolygon(polygon);
    }

    void showMouseLoc(Point point) {
        this.state.showFeatureLoc(point.x, this.features.findFeatures(point.x));
    }

    void doClick(Point point) {
    }
}

